/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CArmy;
import client.gui.AttackMenu;
import client.gui.CMainFrame;
import client.gui.CMapPanel;
import client.gui.dialog.PlanetSearchDialog;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import common.House;
import common.Influences;
import common.Planet;
import common.UnitFactory;
import common.util.MMNetXStream;
import common.util.StringConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class InnerStellarMap
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener {
    InnerStellarMapConfig conf = new InnerStellarMapConfig();
    private CMapPanel mp;
    private MWClient mwclient;
    private IconProvider iconCache = new IconProvider();
    private Planet selectedPlanet = null;
    private static final String[] displayStr = new String[]{"Planet Names", "Planet Control", "Factories", "Warehouses", "Attack Ranges", "Recent Changes"};
    private static final int DISPLAY_NAMES = 0;
    private static final int DISPLAY_INFLUENCE = 1;
    private static final int DISPLAY_UNITS = 2;
    private static final int DISPLAY_WAREHOUSES = 3;
    private static final int DISPLAY_RANGES = 4;
    private static final int DISPLAY_LAST_CHANGED = 5;
    private JCheckBoxMenuItem[] display = new JCheckBoxMenuItem[displayStr.length];
    private Map changesSinceLastRefresh;
    private boolean blinkPhase = false;
    private int xcoord;
    private int ycoord;
    Point lastMousePos = null;
    int mouseMod = 0;

    public CMapPanel getMapPanel() {
        return this.mp;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            final Planet p = this.nearestNeighbour(this.scr2mapX(e.getX()), this.scr2mapY(e.getY()));
            this.activate(p);
            JPopupMenu popup = new JPopupMenu();
            JMenuItem info = new JMenuItem("Information");
            info.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Boolean.valueOf(InnerStellarMap.this.mwclient.getserverConfigs("UseStaticMaps")).booleanValue()) {
                        JEditorPane label = new JEditorPane("text/html", "<html" + InnerStellarMap.this.mp.getPPanel().getPlanet().getAdvanceDescription(InnerStellarMap.this.mwclient.getUser(InnerStellarMap.this.mwclient.getUsername()).getUserlevel()) + "</html>");
                        label.setEditable(false);
                        label.setCaretPosition(0);
                        label.setPreferredSize(new Dimension(500, 400));
                        JOptionPane.showMessageDialog(InnerStellarMap.this, new JScrollPane(label), "Information for " + InnerStellarMap.this.mp.getPPanel().getPlanet().getName(), 1);
                    } else {
                        JEditorPane label = new JEditorPane("text/html", "<html>" + InnerStellarMap.this.mp.getPPanel().getPlanet().getLongDescription(true) + "</html>");
                        label.setEditable(false);
                        label.setCaretPosition(0);
                        label.setPreferredSize(new Dimension(500, 400));
                        JOptionPane.showMessageDialog(InnerStellarMap.this, new JScrollPane(label), "Information for " + InnerStellarMap.this.mp.getPPanel().getPlanet().getName(), 1);
                    }
                }
            });
            popup.add(info);
            AttackMenu aMenu = new AttackMenu(this.mwclient, -1, p.getName());
            aMenu.updateMenuItems(false);
            popup.add(aMenu);
            if (this.mwclient.getMyStatus() != MWClient.STATUS_ACTIVE) {
                aMenu.setEnabled(false);
            }
            popup.addSeparator();
            JMenuItem search = new JMenuItem("Find Planet");
            search.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InnerStellarMap.this.createPlanetSearchDialog();
                }
            });
            popup.add(search);
            JMenu centerM = new JMenu("Center Map");
            JMenuItem item = new JMenuItem("On Selected Planet");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InnerStellarMap.this.conf.offset.setLocation(-p.getPosition().x * InnerStellarMap.this.conf.scale, p.getPosition().y * InnerStellarMap.this.conf.scale);
                    InnerStellarMap.this.mp.repaint();
                }
            });
            centerM.add(item);
            item = new JMenuItem("On Natural Center");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InnerStellarMap.this.conf.offset = new Point();
                    InnerStellarMap.this.conf.scale = 1.0;
                    InnerStellarMap.this.mp.getSlider().setValue((int)Math.round(50.0 / InnerStellarMap.this.conf.scale));
                    InnerStellarMap.this.mp.repaint();
                }
            });
            centerM.add(item);
            popup.add(centerM);
            JMenu displayMenu = new JMenu("Display");
            popup.add(displayMenu);
            for (int i = 0; i < displayStr.length; ++i) {
                displayMenu.add(this.display[i]);
            }
            popup.addSeparator();
            item = new JMenuItem("Refresh");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InnerStellarMap.this.changesSinceLastRefresh.clear();
                    InnerStellarMap.this.mwclient.refreshData();
                    InnerStellarMap.this.mp.repaint();
                }
            });
            popup.add(item);
            if (this.mwclient.isAdmin()) {
                try {
                    File loadJar = new File("./MekWarsAdmin.jar");
                    if (!loadJar.exists()) {
                        MWClient.mwClientLog.clientErrLog("AdminMapPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                    } else {
                        URLClassLoader loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                        Class<?> c = loader.loadClass("admin.AdminMapPopupMenu");
                        Object o = c.newInstance();
                        c.getDeclaredMethod("createMenu", MWClient.class, InnerStellarMap.class, Integer.class, Integer.class, Planet.class).invoke(o, this.mwclient, this, new Integer((int)this.scr2mapX(e.getX())), new Integer((int)this.scr2mapY(e.getY())), this.mp.getPPanel().getPlanet());
                        popup.add((JMenu)o);
                    }
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog("AdminMapPopupMenu creation FAILED!");
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            popup.show(this, e.getX() + 10, e.getY() + 10);
        } else if (e.getButton() == 1 && e.getClickCount() >= 2) {
            if (Boolean.valueOf(this.mwclient.getserverConfigs("UseStaticMaps")).booleanValue()) {
                JEditorPane label = new JEditorPane("text/html", "<html" + this.mp.getPPanel().getPlanet().getAdvanceDescription(this.mwclient.getUser(this.mwclient.getUsername()).getUserlevel()) + "</html>");
                label.setEditable(false);
                label.setCaretPosition(0);
                label.setPreferredSize(new Dimension(500, 400));
                JOptionPane.showMessageDialog(this, new JScrollPane(label), "Information for " + this.mp.getPPanel().getPlanet().getName(), 1);
            } else {
                JEditorPane label = new JEditorPane("text/html", "<html>" + this.mp.getPPanel().getPlanet().getLongDescription(true) + "</html>");
                label.setEditable(false);
                label.setCaretPosition(0);
                label.setPreferredSize(new Dimension(500, 400));
                JOptionPane.showMessageDialog(this, new JScrollPane(label), "Information for " + this.mp.getPPanel().getPlanet().getName(), 1);
            }
        }
    }

    InnerStellarMap(CMapPanel panel, MWClient client, CMainFrame mainFrame) {
        Planet currPlan;
        double storedValue;
        this.mwclient = client;
        this.setBackground(Color.BLACK);
        this.mp = panel;
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        try {
            File dir = new File(client.getCacheDir());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.conf = (InnerStellarMapConfig)xml.fromXML(new FileReader(client.getCacheDir() + "/mapconf.xml"));
            if (this.conf.display.length != displayStr.length) {
                throw new RuntimeException("not my file");
            }
        }
        catch (Throwable e) {
            if (!(e instanceof FileNotFoundException)) {
                MWClient.mwClientLog.clientErrLog(e);
            }
            MWClient.mwClientLog.clientOutputLog("could not read map config file. Will use defaults");
            this.conf = new InnerStellarMapConfig();
        }
        for (int i = 0; i < displayStr.length; ++i) {
            this.display[i] = new JCheckBoxMenuItem(displayStr[i], this.conf.display[i]);
            this.display[i].addActionListener(this);
        }
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InnerStellarMap.this.processTick();
            }
        });
        this.changesSinceLastRefresh = client.getChangesSinceLastRefresh();
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    InnerStellarMap.this.blinkPhase = !InnerStellarMap.this.blinkPhase;
                    if (InnerStellarMap.this.changesSinceLastRefresh.size() <= 0) continue;
                    InnerStellarMap.this.mp.repaint();
                }
            }
        }.start();
        Double storedZoom = new Double(client.getConfigParam("MAPZOOMLEVEL"));
        if (storedZoom != null && (storedValue = storedZoom.doubleValue()) != 0.0) {
            this.conf.scale = storedValue;
        }
        int storedXOffset = Integer.parseInt(client.getConfigParam("MAPXOFFSET"));
        int storedYOffset = Integer.parseInt(client.getConfigParam("MAPYOFFSET"));
        this.conf.offset = new Point(storedXOffset, storedYOffset);
        String storedPlanetName = client.getConfigParam("SELECTEDPLANET");
        if (storedPlanetName != null && !storedPlanetName.trim().equals("") && (currPlan = client.getData().getPlanetByName(storedPlanetName)) != null) {
            this.activate(currPlan, false);
        }
    }

    private Planet nearestNeighbour(double x, double y) {
        Iterator it = this.mp.getData().getAllPlanets().iterator();
        double minDiff = Double.MAX_VALUE;
        double diff = 0.0;
        Planet minPlanet = null;
        while (it.hasNext()) {
            Planet p = (Planet)it.next();
            diff = p.getPosition().distanceSq(x, y);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            minPlanet = p;
        }
        return minPlanet;
    }

    private double scr2mapX(int x) {
        return Math.round((double)(x - this.getWidth() / 2 - this.conf.offset.x) / this.conf.scale);
    }

    private int map2scrX(double x) {
        return (int)Math.round((double)(this.getWidth() / 2) + x * this.conf.scale) + this.conf.offset.x;
    }

    private double scr2mapY(int y) {
        return Math.round((double)(this.getHeight() / 2 - (y - this.conf.offset.y)) / this.conf.scale);
    }

    private int map2scrY(double y) {
        return (int)Math.round((double)(this.getHeight() / 2) - y * this.conf.scale) + this.conf.offset.y;
    }

    public void paint(Graphics g) {
        int y;
        int x;
        Iterator it = this.mp.getData().getAllPlanets().iterator();
        g.setColor(StringConverter.html2Color(this.conf.backgroundColor));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int size = (int)Math.round(Math.max(5.0, Math.log(this.conf.scale) * 15.0 + 5.0));
        size = Math.max(Math.min(size, this.conf.maxdotSize), this.conf.minDotSize);
        Random r = new Random(0L);
        while (it.hasNext()) {
            int pos;
            Planet p = (Planet)it.next();
            Integer houseID = p.getInfluence().getOwner();
            String houseColor = "";
            houseColor = houseID == null || p.getInfluence().getInfluence(houseID) < this.mwclient.getMinPlanetOwnerShip(p) ? this.mwclient.getserverConfigs("DisputedPlanetColor") : this.mwclient.getData().getHouse(houseID).getHouseColor();
            Color c = Color.WHITE;
            if (Boolean.valueOf(this.mwclient.getConfigParam("DARKERMAP")).booleanValue()) {
                try {
                    c = StringConverter.html2Color(houseColor);
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    MWClient.mwClientLog.clientErrLog("Bad House for planet: " + p.getName());
                }
            } else {
                try {
                    c = this.adjustColor(StringConverter.html2Color(houseColor));
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    MWClient.mwClientLog.clientErrLog("Bad House for planet: " + p.getName());
                }
            }
            x = this.map2scrX(p.getPosition().x) - size / 2;
            y = this.map2scrY(p.getPosition().y) - size / 2;
            if (this.mp.getPPanel() != null && this.mp.getPPanel().getPlanet() == p) {
                g.setColor(Color.WHITE);
                g.fillArc(x - 2, y - 2, size + 4, size + 4, 0, 360);
            }
            int dotSize = size;
            boolean blink = false;
            if (this.conf.display[5] && this.blinkPhase && this.changesSinceLastRefresh.containsKey(new Integer(p.getId()))) {
                g.setColor(Color.WHITE);
                ++dotSize;
                blink = true;
            } else {
                g.setColor(c);
            }
            if (size < 3) {
                g.fillRect(x, y, dotSize, dotSize);
            } else {
                g.fillArc(x, y, dotSize, dotSize, 0, 360);
            }
            if (!blink) {
                g.setColor(c);
            }
            if (this.conf.display[0] && (this.conf.showPlanetNamesThreshold == 0.0 || this.conf.scale > this.conf.showPlanetNamesThreshold)) {
                g.drawString(p.getName(), x + size, y);
            }
            if (this.conf.display[1] && (this.conf.showInfluenceThreshold == 0.0 || this.conf.scale > this.conf.showInfluenceThreshold)) {
                pos = 0;
                for (House h : p.getInfluence().getHouses()) {
                    int flu;
                    if (h == null || (flu = p.getInfluence().getInfluence(new Integer(h.getId())) / 10) == 10) continue;
                    Color factionColor = StringConverter.html2Color(h.getHouseColor());
                    g.setColor(factionColor);
                    g.fillRect(x - 10, y + size + pos, 10, flu);
                    pos += flu;
                }
            }
            if (this.conf.display[2] && (this.conf.showUnitFactoriesThreshold == 0.0 || this.conf.scale > this.conf.showUnitFactoriesThreshold)) {
                pos = 0;
                if (p.getFactoryCount() > 0) {
                    ImageIcon staricon = this.iconCache.get("data/images/star.gif");
                    staricon.paintIcon(this, g, x + size + pos, y + size / 2);
                }
            }
            if (!this.conf.display[3] || p.getBaysProvided() <= 0) continue;
            g.setColor(Color.WHITE);
            g.drawString(Integer.toString(p.getBaysProvided()), x - 8, y);
        }
        try {
            if (this.conf.display[4]) {
                TreeMap<String, String> legalOps = new TreeMap<String, String>();
                for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                    legalOps.putAll(currA.getLegalOperations());
                }
                for (String typeName : legalOps.values()) {
                    Planet p = this.mp.getPPanel().getPlanet();
                    x = this.map2scrX(p.getPosition().x);
                    y = this.map2scrY(p.getPosition().y);
                    String[] vals = this.mwclient.getAllOps().get(typeName);
                    Color c = StringConverter.html2Color(vals[1]);
                    double range = Double.parseDouble(vals[0]);
                    g.setColor(c);
                    int rSize = (int)Math.round(2.0 * range * this.conf.scale);
                    g.drawArc(x - rSize / 2, y - rSize / 2, rSize, rSize, 0, 360);
                }
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    private String getBestFactory(Planet p) {
        int type = Integer.MAX_VALUE;
        int weight = Integer.MIN_VALUE;
        int tempType = 0;
        int tempWeight = 0;
        String id = "";
        Iterator i = p.getUnitFactories().iterator();
        if (!i.hasNext()) {
            return "";
        }
        while (i.hasNext()) {
            UnitFactory uf = (UnitFactory)i.next();
            tempType = uf.getBestTypeProducable();
            tempWeight = uf.getWeightclass();
            if (tempType <= type && tempWeight > weight) {
                weight = tempWeight;
                type = tempType;
            }
            if (type != 0 || weight != 3) continue;
            return "am";
        }
        if (type == Integer.MAX_VALUE && weight == Integer.MIN_VALUE) {
            return "";
        }
        switch (weight) {
            case 0: {
                id = "l";
                break;
            }
            case 1: {
                id = "m";
                break;
            }
            case 2: {
                id = "h";
                break;
            }
            case 3: {
                id = "a";
            }
        }
        switch (type) {
            case 0: {
                id = id + "m";
                break;
            }
            case 1: {
                id = id + "v";
                break;
            }
            case 2: {
                id = id + "i";
            }
        }
        return id;
    }

    private int adj(int r) {
        if (this.conf.colorAdjustment == 0.0) {
            return r;
        }
        if (this.conf.colorAdjustment == 1.0) {
            return 255;
        }
        int i = (int)(1.0 / this.conf.colorAdjustment);
        if (r > 0 && r < i) {
            r = i;
        }
        return Math.min((int)((double)r / (1.0 - this.conf.colorAdjustment)), 255);
    }

    public Color adjustColor(Color c) {
        return new Color(this.adj(c.getRed()), this.adj(c.getGreen()), this.adj(c.getBlue()));
    }

    public void activate(Planet p) {
        if (p == null) {
            return;
        }
        if (this.mp.getPPanel() != null && this.mp.getPPanel().getPlanet() != p) {
            this.mp.getPPanel().update(p);
            this.conf.planetID = p.getId();
            this.mp.repaint();
            this.saveMapSelection(p);
        }
    }

    public void activate(Planet p, boolean center) {
        if (p == null) {
            return;
        }
        this.activate(p);
        if (center) {
            this.conf.offset.setLocation(-p.getPosition().x * this.conf.scale, p.getPosition().y * this.conf.scale);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.lastMousePos = new Point(e.getX(), e.getY());
    }

    public void mouseExited(MouseEvent e) {
        this.lastMousePos = null;
    }

    public void mousePressed(MouseEvent e) {
        this.mouseMod = e.getButton();
        if (e.getButton() != 1) {
            return;
        }
        this.selectedPlanet = this.nearestNeighbour(this.scr2mapX(e.getX()), this.scr2mapY(e.getY()));
        this.activate(this.selectedPlanet);
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseMod = 0;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mouseMod != 3) {
            return;
        }
        if (this.lastMousePos != null) {
            this.conf.offset.x -= this.lastMousePos.x - e.getX();
            this.conf.offset.y -= this.lastMousePos.y - e.getY();
        }
        this.mouseMoved(e);
        this.mp.repaint();
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        MWClient.mwClientLog.clientErrLog(keyCode);
        if (keyCode == 37) {
            this.conf.offset.y = (int)((double)this.conf.offset.y - this.conf.scale);
        } else if (keyCode == 38) {
            this.conf.offset.x = (int)((double)this.conf.offset.x - this.conf.scale);
        } else if (keyCode == 39) {
            this.conf.offset.y = (int)((double)this.conf.offset.y + this.conf.scale);
        } else if (keyCode == 40) {
            this.conf.offset.x = (int)((double)this.conf.offset.x + this.conf.scale);
        } else {
            return;
        }
        this.mp.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.lastMousePos == null) {
            this.lastMousePos = new Point(e.getX(), e.getY());
        } else {
            this.lastMousePos.x = e.getX();
            this.lastMousePos.y = e.getY();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mp.getSlider().setValue(this.mp.getSlider().getValue() + e.getWheelRotation() * 3);
        if (this.selectedPlanet != null) {
            this.conf.offset.setLocation(-this.selectedPlanet.getPosition().x * this.conf.scale, this.selectedPlanet.getPosition().y * this.conf.scale);
            this.mp.repaint();
        }
    }

    public void setScale(double scale) {
        this.conf.scale = scale;
        if (this.selectedPlanet != null) {
            this.conf.offset.setLocation(-this.selectedPlanet.getPosition().x * this.conf.scale, this.selectedPlanet.getPosition().y * this.conf.scale);
        }
    }

    public void setXOff(int off) {
        this.conf.offset.x = off;
    }

    public void setYOff(int off) {
        this.conf.offset.y = off;
    }

    public void setSelectedPlanet(Planet p) {
        this.selectedPlanet = p;
    }

    public void actionPerformed(ActionEvent e) {
        this.mp.repaint();
        for (int i = 0; i < displayStr.length; ++i) {
            this.conf.display[i] = this.display[i].isSelected();
        }
    }

    public void processTick() {
        try {
            new MMNetXStream().toXML(this.conf, new FileWriter(this.mwclient.getCacheDir() + "/mapconf.xml"));
        }
        catch (IOException e1) {
            MWClient.mwClientLog.clientErrLog(e1);
        }
    }

    public void dataFetched(Map changes) {
        for (Integer id : changes.keySet()) {
            Influences addinf = (Influences)changes.get(id);
            Influences oldinf = (Influences)this.changesSinceLastRefresh.get(id);
            if (oldinf != null) {
                addinf.add(oldinf);
            }
            this.changesSinceLastRefresh.put(id, addinf);
        }
    }

    public Map getChangesSinceLastRefresh() {
        return this.changesSinceLastRefresh;
    }

    public void createPlanetSearchDialog() {
        PlanetSearchDialog searchDialog = new PlanetSearchDialog(this, this.mwclient.getData().getAllPlanets());
        searchDialog.setVisible(true);
    }

    public void saveMapSelection(Planet p) {
        this.mwclient.getConfig().setParam("SELECTEDPLANET", p.getName());
        this.mwclient.getConfig().setParam("MAPZOOMLEVEL", "" + this.conf.scale);
        this.mwclient.getConfig().setParam("MAPYOFFSET", "" + (int)this.conf.offset.getY());
        this.mwclient.getConfig().setParam("MAPXOFFSET", "" + (int)this.conf.offset.getX());
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
    }

    private class IconProvider
    extends Hashtable {
        private IconProvider() {
        }

        public ImageIcon get(String key) {
            if (!this.contains(key)) {
                this.put(key, new ImageIcon(key));
            }
            return (ImageIcon)super.get(key);
        }
    }

    public static final class InnerStellarMapConfig {
        int minDotSize = 2;
        int maxdotSize = 25;
        int reverseScaleMax = 100;
        int reverseScaleMin = 2;
        double showInfluenceThreshold = 0.0;
        double showUnitFactoriesThreshold = 0.0;
        double showPlanetNamesThreshold = 0.0;
        double colorAdjustment = 0.5;
        String backgroundColor = "#000000";
        boolean[] display = new boolean[]{true, false, true, true, true, true};
        double scale = 1.0;
        Point offset = new Point();
        int planetID;
    }
}

