/*
 * Decompiled with CFR 0.152.
 */
package client.gui.commands;

import client.CConfig;
import client.CUser;
import client.MWClient;
import client.gui.CCommPanel;
import client.gui.commands.CGUICommand;
import client.protocol.TransportCodec;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;

public class MailGCmd
extends CGUICommand {
    CConfig Config = null;
    String fontcolor = "black";

    public MailGCmd(MWClient mwclient) {
        super(mwclient);
        this.Config = mwclient.getConfig();
        this.name = "mail";
        this.alias = "m";
        this.command = "comm\t";
        this.fontcolor = this.Config.getParam("CHATFONTCOLOR");
    }

    public boolean execute(String input) {
        StringTokenizer ST = new StringTokenizer(input, " ");
        if (this.check(ST.nextToken())) {
            input = this.decompose(input);
            String receiver = input.substring(0, input.indexOf(","));
            if (this.Config.isParam("REPLYTORECEIVER") && receiver != null && !receiver.equals("")) {
                this.mwclient.setLastQuery(receiver);
            }
            this.send(TransportCodec.encode("CH|" + MWClient.CAMPAIGN_PREFIX + "mail " + input));
            this.echo(input);
            return true;
        }
        return false;
    }

    protected void echo(String input) {
        String name = input.substring(0, input.indexOf(","));
        String message = input.substring(input.indexOf(",") + 1);
        CUser user = this.mwclient.getUser(name);
        String factioncolor = "";
        String usercolor = this.mwclient.getUser(name).getColor();
        String addon = this.mwclient.getUser(name).getAddon();
        factioncolor = user.getHouse().length() > 1 && this.mwclient.getData().getHouseByName(user.getHouse()) != null ? this.mwclient.getData().getHouseByName(user.getHouse()).getHouseColor() : "black";
        String colorSetting = this.mwclient.getConfig().getParam("PLAYERCHATCOLORMODE").toLowerCase();
        if (colorSetting.equals("factionadd") || colorSetting.equals("factionall")) {
            addon = addon.equals("") ? "" : " <b><font color=\"" + factioncolor + "\">[" + addon + "]</b></font>";
        } else {
            String string = addon = addon.equals("") ? "" : " <b><font color=\"" + usercolor + "\">[" + addon + "]</b></font>";
        }
        name = colorSetting.equals("factionname") || colorSetting.equals("factionall") ? (name.equals("") ? "" : " <b><font color=\"" + factioncolor + "\">" + name + "</b></font>") : (name.equals("") ? "" : " <b><font color=\"" + usercolor + "\">" + name + "</b></font>");
        String fontcolor = this.mwclient.getConfig().getParam("CHATFONTCOLOR");
        message = "=> " + name + addon + "<font color=\"" + fontcolor + "\"><b>:</b> " + message.trim() + "</font>";
        if (this.Config.isTimeStamp()) {
            message = this.mwclient.getShortTime() + message;
        }
        this.mwclient.addToChat(message, CCommPanel.CHANNEL_PMAIL);
        if (this.Config.isParam("MAINCHANNELPM")) {
            String sysColour = this.mwclient.getConfigParam("SYSMESSAGECOLOR");
            this.mwclient.addToChat("<font color=\"" + sysColour + "\"><b>Private Mail: </b></font>" + message);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }
}

