/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CommandDialog
extends JDialog
implements ActionListener {
    private JList matchingCommandList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private String toReturn = null;
    private ArrayList possibleCommands = null;
    private MWClient mwclient;

    public CommandDialog(MWClient client, String boxText) {
        super(new JFrame(), boxText, true);
        this.mwclient = client;
        Vector<String> commandList = new Vector<String>();
        Enumeration<String> commands = client.getData().getCommandTable().keys();
        Enumeration<Integer> accessLevels = client.getData().getCommandTable().elements();
        while (commands.hasMoreElements()) {
            String command = commands.nextElement();
            Integer accessLevel = accessLevels.nextElement();
            if (accessLevel > client.getUser(client.getUsername()).getUserlevel()) continue;
            commandList.add(command);
        }
        Collections.sort(commandList);
        final Object[] commandNames = commandList.toArray();
        this.matchingCommandList = new JList<Object>(commandNames);
        this.matchingCommandList.setVisibleRowCount(10);
        this.matchingCommandList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = CommandDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            CommandDialog.this.matchingCommandList.setListData(commandNames);
                            return;
                        }
                        CommandDialog.this.possibleCommands = new ArrayList();
                        text = text.toLowerCase();
                        int until = commandNames.length;
                        for (int i = 0; i < until; ++i) {
                            String currPlayer = (String)commandNames[i];
                            if (currPlayer.toLowerCase().indexOf(text) == -1) continue;
                            CommandDialog.this.possibleCommands.add(currPlayer);
                        }
                        CommandDialog.this.matchingCommandList.setListData(CommandDialog.this.possibleCommands.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = CommandDialog.this.possibleCommands.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                CommandDialog.this.matchingCommandList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            CommandDialog.this.matchingCommandList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingCommandList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedCommand = (String)this.matchingCommandList.getSelectedValue();
            if (selectedCommand == null) {
                selectedCommand = this.nameField.getText();
            }
            if (selectedCommand == null || selectedCommand.equals("")) {
                return;
            }
            if (this.matchingCommandList.getModel().getSize() == 1) {
                selectedCommand = (String)this.matchingCommandList.getModel().getElementAt(0);
            }
            this.setCommandName(selectedCommand);
            this.setVisible(false);
            return;
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setCommandName(String name) {
        this.toReturn = name;
    }

    public String getCommandName() {
        return this.toReturn;
    }
}

