/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import client.gui.dialog.CamoSelectionDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class ConfigurationDialog
implements ActionListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Okay";
    private static final String cancelCommand = "Cancel";
    private static final String camoCommand = "Camo";
    private static final String windowName = "MekWars Configuration";
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JButton camoButton = new JButton("Select Camo");
    private final JTextField hqTabNameField = new JTextField(10);
    private final JTextField bmTabNameField = new JTextField(10);
    private final JTextField hsTabNameField = new JTextField(10);
    private final JTextField batTabNameField = new JTextField(10);
    private final JTextField mapTabNameField = new JTextField(10);
    private final JTextField mcTabNameField = new JTextField(10);
    private final JTextField hmTabNameField = new JTextField(10);
    private final JTextField pmTabNameField = new JTextField(10);
    private final JTextField pLogTabNameField = new JTextField(10);
    private final JTextField sysLogTabNameField = new JTextField(10);
    private final JTextField miscTabNameField = new JTextField(10);
    private final JTextField hqTabMnemonicField = new JTextField(1);
    private final JTextField bmTabMnemonicField = new JTextField(1);
    private final JTextField hsTabMnemonicField = new JTextField(1);
    private final JTextField batTabMnemonicField = new JTextField(1);
    private final JTextField mapTabMnemonicField = new JTextField(1);
    private final JTextField mcTabMnemonicField = new JTextField(1);
    private final JTextField hmTabMnemonicField = new JTextField(1);
    private final JTextField pmTabMnemonicField = new JTextField(1);
    private final JTextField pLogTabMnemonicField = new JTextField(1);
    private final JTextField sysLogTabMnemonicField = new JTextField(1);
    private final JTextField miscTabMnemonicField = new JTextField(1);
    private final JTextField uNameField = new JTextField(11);
    private final JPasswordField passwordField = new JPasswordField();
    private final JTextField chatNameColorField = new JTextField();
    private final JTextField defaultArmyNameField = new JTextField();
    private final JTextField hqColumnsField = new JTextField(3);
    private final JTextField keywordsField = new JTextField();
    private final JTextField ignorePublicField = new JTextField();
    private final JTextField ignoreHouseField = new JTextField();
    private final JTextField ignorePrivateField = new JTextField();
    private final JTextField challengeStringField = new JTextField();
    private final JTextField soundOnCallField = new JTextField();
    private final JTextField soundOnKeywordField = new JTextField();
    private final JTextField soundOnMessageField = new JTextField();
    private final JTextField soundOnAttackField = new JTextField();
    private final JTextField soundOnBMWinField = new JTextField();
    private final JTextField maxPlayersField = new JTextField(11);
    private final JTextField hostCommentsField = new JTextField(11);
    private final JTextField f1Field = new JTextField(30);
    private final JTextField f2Field = new JTextField(30);
    private final JTextField f3Field = new JTextField(30);
    private final JTextField f4Field = new JTextField(30);
    private final JTextField f5Field = new JTextField(30);
    private final String[] schemeChoices = new String[]{"Grey", "Tan", "Classic"};
    private final JComboBox schemeComboBox = new JComboBox<String>(this.schemeChoices);
    private final String[] lookandFeelChoices = new String[]{"Native", "CDE/Motif", "Java/Metal", "Liquid", "Metouia", "Plastic (Desert)", "Plastic (Sky)", "Plastic XP", "Steel", "Windows - J"};
    private final JComboBox lookandfeelComboBox = new JComboBox<String>(this.lookandFeelChoices);
    private final String[] playerChatColorChoices = new String[]{"Player Defined", "House Colors", "Mixed (House Tag)", "Mixed (House Name)"};
    private final JComboBox playerChatColorComboBox = new JComboBox<String>(this.playerChatColorChoices);
    private final String[] sysMessageColorChoices = new String[]{"Dark Green", "Gold", "Indigo", "Navy", "Orange", "Red", "Teal"};
    private final JComboBox sysMessageColorComboBox = new JComboBox<String>(this.sysMessageColorChoices);
    private final JCheckBox hqTabVisBox = new JCheckBox();
    private final JCheckBox bmTabVisBox = new JCheckBox();
    private final JCheckBox hsTabVisBox = new JCheckBox();
    private final JCheckBox batTabVisBox = new JCheckBox();
    private final JCheckBox mapTabVisBox = new JCheckBox();
    private final JCheckBox hmTabVisBox = new JCheckBox();
    private final JCheckBox pmTabVisBox = new JCheckBox();
    private final JCheckBox pLogTabVisBox = new JCheckBox();
    private final JCheckBox sysLogTabVisBox = new JCheckBox();
    private final JCheckBox miscTabVisBox = new JCheckBox();
    private final JCheckBox hqTabonTopBox = new JCheckBox();
    private final JCheckBox bmTabonTopBox = new JCheckBox();
    private final JCheckBox hsTabonTopBox = new JCheckBox();
    private final JCheckBox batTabonTopBox = new JCheckBox();
    private final JCheckBox mapTabonTopBox = new JCheckBox();
    private final JCheckBox timeStampBox = new JCheckBox();
    private final JCheckBox autoJoinGameBox = new JCheckBox();
    private final JCheckBox showHexinHQBox = new JCheckBox();
    private final JCheckBox useStatusForIconBox = new JCheckBox();
    private final JCheckBox darkenMapBox = new JCheckBox();
    private final JCheckBox bmPreviewImageBox = new JCheckBox();
    private final JCheckBox autoConnectBox = new JCheckBox();
    private final JCheckBox hmInMainBox = new JCheckBox();
    private final JCheckBox pmInMainBox = new JCheckBox();
    private final JCheckBox miscInMainBox = new JCheckBox();
    private final JCheckBox sysLogInMainBox = new JCheckBox();
    private final JCheckBox pmReplyToSender = new JCheckBox();
    private final JCheckBox pmReplyToReciever = new JCheckBox();
    private final JCheckBox colorEmotesBox = new JCheckBox();
    private final JCheckBox showEnterExitBox = new JCheckBox();
    private final JCheckBox blockImagesBox = new JCheckBox();
    private final JCheckBox enableSoundOnCall = new JCheckBox();
    private final JCheckBox enableSoundOnMessage = new JCheckBox();
    private final JCheckBox enableSoundOnAttack = new JCheckBox();
    private final JCheckBox enableSoundOnKeyword = new JCheckBox();
    private final JCheckBox enableSoundOnBMWin = new JCheckBox();
    private final JCheckBox systemMessageKeyword = new JCheckBox();
    private final JCheckBox enableDedicatedServerCB = new JCheckBox();
    private final JTextField portField = new JTextField();
    private final JTextField nameField = new JTextField();
    private final JTextField prefixField = new JTextField();
    private final JTextField ownersField = new JTextField();
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public ConfigurationDialog(MWClient c) {
        this.mwclient = c;
        int originalColumns = Integer.parseInt(this.mwclient.getConfigParam("UNITAMOUNT"));
        String originalUnitHex = this.mwclient.getConfigParam("UNITHEX");
        String originalScheme = this.mwclient.getConfigParam("HQCOLORSCHEME").toLowerCase();
        String originalSkin = this.mwclient.getConfigParam("LOOKANDFEEL").toLowerCase();
        String originalMapBrightness = this.mwclient.getConfigParam("DARKERMAP").toLowerCase();
        String originalBMPreview = this.mwclient.getConfigParam("BMPREVIEWIMAGE").toLowerCase();
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.camoButton.setActionCommand(camoCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.camoButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.camoButton.setToolTipText("Select Camo to be Preloaded in MegaMek");
        JPanel playerPanel = new JPanel();
        JPanel chatPanel = new JPanel();
        JPanel soundPanel = new JPanel();
        JPanel tabVisibilityPanel = new JPanel();
        JPanel tabNamingPanel = new JPanel();
        JPanel keyBindPanel = new JPanel();
        JPanel dedicatedHostPanel = new JPanel();
        playerPanel.setLayout(new BoxLayout(playerPanel, 1));
        JPanel playerFieldsPanel = new JPanel(new SpringLayout());
        JPanel playerFieldsWrapper = new JPanel();
        playerFieldsWrapper.add(playerFieldsPanel);
        JPanel playerLowerCBoxesPanel = new JPanel();
        JPanel playerUpperCBoxesPanel = new JPanel(new SpringLayout());
        int userFieldRows = 3;
        Dimension newDim = new Dimension();
        newDim.setSize(this.uNameField.getMaximumSize().getWidth(), this.uNameField.getMinimumSize().getHeight());
        playerFieldsPanel.add(new JLabel("User Name:", 11));
        this.uNameField.setMaximumSize(newDim);
        this.uNameField.setToolTipText("<HTML><BODY>User Name. Leave blank to be prompted<br>for a username/pass when connecting.</BODY></HTML>");
        playerFieldsPanel.add(this.uNameField);
        playerFieldsPanel.add(new JLabel("Password:", 11));
        this.passwordField.setMaximumSize(newDim);
        this.passwordField.setToolTipText("Account Password");
        playerFieldsPanel.add(this.passwordField);
        playerFieldsPanel.add(new JLabel("Color:", 11));
        this.chatNameColorField.setMaximumSize(newDim);
        this.chatNameColorField.setToolTipText("<HTML>Chat colour. Can be any HTML keyword<br>colour (blue) or hex code (#003366)</HTML>");
        playerFieldsPanel.add(this.chatNameColorField);
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            playerFieldsPanel.add(new JLabel("HQ Columns:", 11));
            this.hqColumnsField.setMaximumSize(newDim);
            this.hqColumnsField.setToolTipText("Number of columns in Headquarters");
            playerFieldsPanel.add(this.hqColumnsField);
            playerFieldsPanel.add(new JLabel("New Army Name:", 11));
            this.defaultArmyNameField.setMaximumSize(newDim);
            this.defaultArmyNameField.setToolTipText("<HTML>Name given to each newly created army. Useful<br>for starter strings. For example, start all new<br>armies as 'Tau Ceti Rangers,' adding lance and<br>company descriptions afterwards.</HTML>");
            playerFieldsPanel.add(this.defaultArmyNameField);
            userFieldRows += 2;
        }
        SpringLayoutHelper.setupSpringGrid(playerFieldsPanel, userFieldRows, 2);
        int upperCBoxesCounter = 0;
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            this.showHexinHQBox.setText("Hexes in HQ");
            this.showHexinHQBox.setToolTipText("If enabled, hexes will be shows under units in HQ.");
            playerUpperCBoxesPanel.add(this.showHexinHQBox);
            ++upperCBoxesCounter;
        }
        if (this.mwclient.getConfig().isParam("BMTABVISIBLE")) {
            this.bmPreviewImageBox.setText("BM Preview");
            this.bmPreviewImageBox.setToolTipText("Check to show a unit preview image in BM tab.");
            playerUpperCBoxesPanel.add(this.bmPreviewImageBox);
            ++upperCBoxesCounter;
        }
        if (this.mwclient.getConfig().isParam("MAPTABVISIBLE")) {
            this.darkenMapBox.setText("Darken Map");
            this.darkenMapBox.setToolTipText("Check to reduce brightness of planets on map.");
            playerUpperCBoxesPanel.add(this.darkenMapBox);
            ++upperCBoxesCounter;
        }
        if (upperCBoxesCounter != 0) {
            this.useStatusForIconBox.setText("Status For Icon");
            this.useStatusForIconBox.setToolTipText("<HTML>If checked, the server icon will be replaced with<br>an activity status image. This can be helpful, but<br>can make it harder to find the client window when<br>moving between multiple servers or programs.<br><br>REQUIRES RESTART. DOES NOT WORK ON ALL PLATFORMS!</HTML>");
            playerUpperCBoxesPanel.add(this.useStatusForIconBox);
            ++upperCBoxesCounter;
        }
        if (upperCBoxesCounter == 1) {
            SpringLayoutHelper.setupSpringGrid(playerUpperCBoxesPanel, 1, 1);
        } else if (upperCBoxesCounter == 2) {
            SpringLayoutHelper.setupSpringGrid(playerUpperCBoxesPanel, 2, 1);
        } else if (upperCBoxesCounter == 3 || upperCBoxesCounter == 4) {
            SpringLayoutHelper.setupSpringGrid(playerUpperCBoxesPanel, 2, 2);
        }
        JPanel schemeWrapper = new JPanel();
        schemeWrapper.setLayout(new BoxLayout(schemeWrapper, 1));
        Dimension comboDim = new Dimension();
        comboDim.setSize(this.lookandfeelComboBox.getMinimumSize().getWidth() * 1.6, this.uNameField.getMinimumSize().getHeight() + 2.0);
        JLabel schemeHeader = new JLabel("HQ Color Scheme:");
        schemeHeader.setAlignmentX(0.5f);
        schemeWrapper.add(schemeHeader);
        schemeWrapper.add(this.schemeComboBox);
        this.schemeComboBox.setAlignmentX(0.5f);
        this.schemeComboBox.setMaximumSize(comboDim);
        JPanel skinWrapper = new JPanel();
        skinWrapper.setLayout(new BoxLayout(skinWrapper, 1));
        JLabel skinHeader = new JLabel("Look and Feel:");
        skinHeader.setAlignmentX(0.5f);
        skinWrapper.add(skinHeader);
        skinWrapper.add(this.lookandfeelComboBox);
        this.lookandfeelComboBox.setAlignmentX(0.5f);
        this.lookandfeelComboBox.setMaximumSize(comboDim);
        JPanel sysMessageWrapper = new JPanel();
        sysMessageWrapper.setLayout(new BoxLayout(sysMessageWrapper, 1));
        JLabel sysMesHeader = new JLabel("System Message Color:");
        sysMesHeader.setAlignmentX(0.5f);
        sysMessageWrapper.add(sysMesHeader);
        sysMessageWrapper.add(this.sysMessageColorComboBox);
        this.sysMessageColorComboBox.setAlignmentX(0.5f);
        this.sysMessageColorComboBox.setMaximumSize(comboDim);
        this.autoConnectBox.setText("Autoconnect");
        this.autoConnectBox.setToolTipText("Check to send username and password automatically.");
        this.timeStampBox.setText("Timestamps");
        this.timeStampBox.setToolTipText("If enabled, timestamps will be shown in chat.");
        this.autoJoinGameBox.setText("Autojoin");
        this.autoJoinGameBox.setToolTipText("<HTML>Enable to join hosts set up by opponents automatically.<br>Example: Players A and B start a game. Player B has<br>Autojoin enabled. Player A sets up a host. Player B's<br>client automatically logs him into A's host.</HTML>");
        playerLowerCBoxesPanel.add(this.autoConnectBox);
        playerLowerCBoxesPanel.add(this.timeStampBox);
        playerLowerCBoxesPanel.add(this.autoJoinGameBox);
        playerPanel.add(playerFieldsWrapper);
        playerPanel.add(playerUpperCBoxesPanel);
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            playerPanel.add(schemeWrapper);
        } else {
            playerPanel.add(new JLabel("\n"));
            playerPanel.add(this.camoButton);
            this.camoButton.setAlignmentX(0.5f);
            this.camoButton.setAlignmentY(0.5f);
            playerPanel.add(new JLabel("\n"));
        }
        playerPanel.add(sysMessageWrapper);
        playerPanel.add(skinWrapper);
        if (!this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            playerPanel.add(new JLabel("\n"));
        }
        playerPanel.add(playerLowerCBoxesPanel);
        JPanel hostPanelWrapper = new JPanel();
        hostPanelWrapper.setLayout(new BoxLayout(hostPanelWrapper, 1));
        JPanel dedInfoPanel = new JPanel(new SpringLayout());
        JLabel genOptHeader = new JLabel("General Options:");
        genOptHeader.setAlignmentX(0.5f);
        JPanel genOptSpring = new JPanel(new SpringLayout());
        genOptSpring.add(new JLabel("Max Players:", 11));
        this.maxPlayersField.setMaximumSize(newDim);
        this.maxPlayersField.setToolTipText("Number of players allowed to join host");
        genOptSpring.add(this.maxPlayersField);
        genOptSpring.add(new JLabel("Comment:", 11));
        this.hostCommentsField.setMaximumSize(newDim);
        this.hostCommentsField.setToolTipText("Host Comment");
        genOptSpring.add(this.hostCommentsField);
        genOptSpring.add(new JLabel("Port:", 11));
        this.portField.setMaximumSize(newDim);
        this.portField.setToolTipText("<HTML>The port which will be used to host.<br>Must open this port if you are using<br>a firewall and forwarded if you are<br>behind a router.</HTML>");
        genOptSpring.add(this.portField);
        SpringLayoutHelper.setupSpringGrid(genOptSpring, 3, 2);
        hostPanelWrapper.add(new JLabel("\n"));
        hostPanelWrapper.add(genOptHeader);
        hostPanelWrapper.add(genOptSpring);
        hostPanelWrapper.add(new JLabel("\n"));
        JLabel dedicatedServiceHeader = new JLabel("<HTML><body><CENTER><b>Warning: Do not set or change the options<br>below unless you want to use this client as<br>a dedicated host. Options above are general<br>and may be set any time.</b></CENTER></body></HTML>");
        dedicatedServiceHeader.setForeground(Color.RED);
        dedicatedServiceHeader.setAlignmentX(0.5f);
        dedicatedServiceHeader.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(4, 5, 4, 5)));
        hostPanelWrapper.add(dedicatedServiceHeader);
        hostPanelWrapper.add(new JLabel("\n"));
        this.enableDedicatedServerCB.setText("Convert Client To Dedicated Host");
        this.enableDedicatedServerCB.setToolTipText("<HTML>Warning: Only check this box if you<BR> want this client to be turned into a dedicated host!</HTML>");
        this.enableDedicatedServerCB.setAlignmentX(0.5f);
        dedInfoPanel.add(new JLabel("Dedicated Name:", 11));
        this.nameField.setMaximumSize(newDim);
        this.nameField.setToolTipText("<HTML>Name of your Dedicated Host</HTML>");
        dedInfoPanel.add(this.nameField);
        dedInfoPanel.add(new JLabel("Ded Prefix:", 11));
        this.prefixField.setMaximumSize(newDim);
        this.prefixField.setToolTipText("<HTML>The prefix that should go before all commands</HTML>");
        dedInfoPanel.add(this.prefixField);
        dedInfoPanel.add(new JLabel("Ded Owners:", 11));
        this.ownersField.setMaximumSize(newDim);
        this.ownersField.setToolTipText("<HTML>List of people, sperated by $,<br>that you want to give control of your ded too</HTML>");
        dedInfoPanel.add(this.ownersField);
        SpringLayoutHelper.setupSpringGrid(dedInfoPanel, 3, 2);
        hostPanelWrapper.add(this.enableDedicatedServerCB);
        hostPanelWrapper.add(dedInfoPanel);
        dedicatedHostPanel.add(hostPanelWrapper);
        JPanel chatPanelWrapper = new JPanel();
        chatPanelWrapper.setLayout(new BoxLayout(chatPanelWrapper, 1));
        JPanel ignorePanel = new JPanel(new SpringLayout());
        JPanel inMainPanel = new JPanel();
        JPanel mailDirectionPanel = new JPanel();
        JPanel miscChatBoxesPanel = new JPanel();
        ignorePanel.add(new JLabel("Ignore in Main:", 11));
        ignorePanel.add(this.ignorePublicField);
        ignorePanel.add(new JLabel("Ignore in House:", 11));
        ignorePanel.add(this.ignoreHouseField);
        ignorePanel.add(new JLabel("Ignore in Private:", 11));
        ignorePanel.add(this.ignorePrivateField);
        ignorePanel.add(new JLabel("Keywords:", 11));
        ignorePanel.add(this.keywordsField);
        ignorePanel.add(new JLabel("Challenge Text:", 11));
        ignorePanel.add(this.challengeStringField);
        this.challengeStringField.setToolTipText("The string text which precedes auto-generated match requests.");
        SpringLayoutHelper.setupSpringGrid(ignorePanel, 5, 2);
        JLabel intoMainHeader = new JLabel("Content from selected tabs shows in Main Channel:");
        intoMainHeader.setAlignmentX(0.5f);
        this.hmInMainBox.setText("House");
        this.pmInMainBox.setText("Private");
        this.sysLogInMainBox.setText("System");
        this.miscInMainBox.setText("Misc.");
        inMainPanel.add(this.hmInMainBox);
        inMainPanel.add(this.pmInMainBox);
        inMainPanel.add(this.sysLogInMainBox);
        inMainPanel.add(this.miscInMainBox);
        JLabel mailDirectionHeader = new JLabel("Private Message Options (Select One):");
        mailDirectionHeader.setAlignmentX(0.5f);
        this.pmReplyToSender.setText("To Last Sender");
        this.pmReplyToReciever.setText("To Last Recipient");
        mailDirectionPanel.add(this.pmReplyToSender);
        mailDirectionPanel.add(this.pmReplyToReciever);
        comboDim.setSize(this.playerChatColorComboBox.getMinimumSize().getWidth() * 1.2, this.playerChatColorComboBox.getMinimumSize().getHeight() + 2.0);
        JLabel chatNameColorHeader = new JLabel("Chat Name Color Modes:");
        chatNameColorHeader.setAlignmentX(0.5f);
        this.playerChatColorComboBox.setAlignmentX(0.5f);
        this.playerChatColorComboBox.setMaximumSize(comboDim);
        this.colorEmotesBox.setText("Color Emotes");
        this.colorEmotesBox.setToolTipText("If checked, names in /me's will be colored and bolded.");
        this.showEnterExitBox.setText("Enter & Exit");
        this.showEnterExitBox.setToolTipText("Uncheck to suppress Enter and Exit messages in chat.");
        this.blockImagesBox.setText("Block Images");
        this.blockImagesBox.setToolTipText("If checked, images in faction, private and mod chat will be blocked.");
        miscChatBoxesPanel.add(this.colorEmotesBox);
        miscChatBoxesPanel.add(this.showEnterExitBox);
        miscChatBoxesPanel.add(this.blockImagesBox);
        chatPanelWrapper.add(ignorePanel);
        chatPanelWrapper.add(new JLabel("\n"));
        chatPanelWrapper.add(intoMainHeader);
        chatPanelWrapper.add(inMainPanel);
        chatPanelWrapper.add(new JLabel("\n"));
        chatPanelWrapper.add(mailDirectionHeader);
        chatPanelWrapper.add(mailDirectionPanel);
        chatPanelWrapper.add(new JLabel("\n"));
        chatPanelWrapper.add(chatNameColorHeader);
        chatPanelWrapper.add(this.playerChatColorComboBox);
        chatPanelWrapper.add(new JLabel("\n"));
        chatPanelWrapper.add(miscChatBoxesPanel);
        chatPanel.add(chatPanelWrapper);
        JPanel soundPanelWrapper = new JPanel();
        soundPanelWrapper.setLayout(new BoxLayout(soundPanelWrapper, 1));
        JPanel soundFieldsPanel = new JPanel(new SpringLayout());
        JPanel soundCBoxPanel = new JPanel(new SpringLayout());
        soundFieldsPanel.add(new JLabel(""));
        soundFieldsPanel.add(new JLabel("Sound Files:", 0));
        soundFieldsPanel.add(new JLabel("Enabled:", 0));
        soundFieldsPanel.add(new JLabel("Attacked:", 11));
        soundFieldsPanel.add(this.soundOnAttackField);
        this.enableSoundOnAttack.setHorizontalAlignment(0);
        soundFieldsPanel.add(this.enableSoundOnAttack);
        soundFieldsPanel.add(new JLabel("Called:", 11));
        soundFieldsPanel.add(this.soundOnCallField);
        this.enableSoundOnCall.setHorizontalAlignment(0);
        soundFieldsPanel.add(this.enableSoundOnCall);
        soundFieldsPanel.add(new JLabel("Keyword:", 11));
        soundFieldsPanel.add(this.soundOnKeywordField);
        this.enableSoundOnKeyword.setHorizontalAlignment(0);
        soundFieldsPanel.add(this.enableSoundOnKeyword);
        soundFieldsPanel.add(new JLabel("Message:", 11));
        soundFieldsPanel.add(this.soundOnMessageField);
        this.enableSoundOnMessage.setHorizontalAlignment(0);
        soundFieldsPanel.add(this.enableSoundOnMessage);
        soundFieldsPanel.add(new JLabel("BM Win:", 11));
        soundFieldsPanel.add(this.soundOnBMWinField);
        this.enableSoundOnBMWin.setHorizontalAlignment(0);
        soundFieldsPanel.add(this.enableSoundOnBMWin);
        SpringLayoutHelper.setupSpringGrid(soundFieldsPanel, 6, 3);
        this.systemMessageKeyword.setText("Check System Messages for Keywords");
        this.systemMessageKeyword.setToolTipText("If enabled, all text in all channels will be searched for keywords.");
        soundCBoxPanel.add(this.systemMessageKeyword);
        SpringLayoutHelper.setupSpringGrid(soundCBoxPanel, 1, 1);
        soundPanelWrapper.add(soundFieldsPanel);
        soundPanelWrapper.add(soundCBoxPanel);
        soundPanel.add(soundPanelWrapper);
        JPanel tabVisibilitySpring = new JPanel(new SpringLayout());
        tabVisibilitySpring.add(new JLabel(""));
        tabVisibilitySpring.add(new JLabel(" Visible:  ", 0));
        tabVisibilitySpring.add(new JLabel("Top Panel:", 0));
        tabVisibilitySpring.add(new JLabel("Headquarters:", 11));
        this.hqTabVisBox.setHorizontalAlignment(0);
        this.hqTabonTopBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.hqTabVisBox);
        tabVisibilitySpring.add(this.hqTabonTopBox);
        tabVisibilitySpring.add(new JLabel("Black Market:", 11));
        this.bmTabVisBox.setHorizontalAlignment(0);
        this.bmTabonTopBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.bmTabVisBox);
        tabVisibilitySpring.add(this.bmTabonTopBox);
        tabVisibilitySpring.add(new JLabel("House Status:", 11));
        this.hsTabVisBox.setHorizontalAlignment(0);
        this.hsTabonTopBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.hsTabVisBox);
        tabVisibilitySpring.add(this.hsTabonTopBox);
        tabVisibilitySpring.add(new JLabel("Battles:", 11));
        this.batTabVisBox.setHorizontalAlignment(0);
        this.batTabonTopBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.batTabVisBox);
        tabVisibilitySpring.add(this.batTabonTopBox);
        tabVisibilitySpring.add(new JLabel("Map:", 11));
        this.mapTabVisBox.setHorizontalAlignment(0);
        this.mapTabonTopBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.mapTabVisBox);
        tabVisibilitySpring.add(this.mapTabonTopBox);
        tabVisibilitySpring.add(new JLabel("House Channel:", 11));
        this.hmTabVisBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.hmTabVisBox);
        JCheckBox dopeCBox1 = new JCheckBox("", false);
        dopeCBox1.setEnabled(false);
        dopeCBox1.setHorizontalAlignment(0);
        tabVisibilitySpring.add(dopeCBox1);
        tabVisibilitySpring.add(new JLabel("Private Channel:", 11));
        this.pmTabVisBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.pmTabVisBox);
        JCheckBox dopeCBox2 = new JCheckBox("", false);
        dopeCBox2.setEnabled(false);
        dopeCBox2.setHorizontalAlignment(0);
        tabVisibilitySpring.add(dopeCBox2);
        tabVisibilitySpring.add(new JLabel("Personal Log:", 11));
        this.pLogTabVisBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.pLogTabVisBox);
        JCheckBox dopeCBox3 = new JCheckBox("", false);
        dopeCBox3.setEnabled(false);
        dopeCBox3.setHorizontalAlignment(0);
        tabVisibilitySpring.add(dopeCBox3);
        tabVisibilitySpring.add(new JLabel("System Log:", 11));
        this.sysLogTabVisBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.sysLogTabVisBox);
        JCheckBox dopeCBox4 = new JCheckBox("", false);
        dopeCBox4.setEnabled(false);
        dopeCBox4.setHorizontalAlignment(0);
        tabVisibilitySpring.add(dopeCBox4);
        tabVisibilitySpring.add(new JLabel("Miscellaneous:", 11));
        this.miscTabVisBox.setHorizontalAlignment(0);
        tabVisibilitySpring.add(this.miscTabVisBox);
        JCheckBox dopeCBox5 = new JCheckBox("", false);
        dopeCBox5.setEnabled(false);
        dopeCBox5.setHorizontalAlignment(0);
        tabVisibilitySpring.add(dopeCBox5);
        SpringLayoutHelper.setupSpringGrid(tabVisibilitySpring, 11, 3);
        JLabel tabVisFooter1 = new JLabel("Restart required for tab", 0);
        JLabel tabVisFooter2 = new JLabel("changes to take effect.", 0);
        tabVisFooter1.setAlignmentX(0.5f);
        tabVisFooter2.setAlignmentX(0.5f);
        JPanel tabVisBox = new JPanel();
        tabVisBox.setLayout(new BoxLayout(tabVisBox, 1));
        tabVisBox.add(tabVisibilitySpring);
        tabVisBox.add(new JLabel("\n"));
        tabVisBox.add(tabVisFooter1);
        tabVisBox.add(tabVisFooter2);
        tabVisibilityPanel.add(tabVisBox);
        JPanel tabNamingSpring = new JPanel(new SpringLayout());
        JPanel tabNamingBox = new JPanel();
        tabNamingBox.setLayout(new BoxLayout(tabNamingBox, 1));
        tabNamingBox.add(tabNamingSpring);
        JLabel tabNamingFooter1 = new JLabel("Restart required for tab", 0);
        JLabel tabNamingFooter2 = new JLabel("changes to take effect.", 0);
        tabNamingFooter1.setAlignmentX(0.5f);
        tabNamingFooter2.setAlignmentX(0.5f);
        tabNamingBox.add(new JLabel("\n"));
        tabNamingBox.add(tabNamingFooter1);
        tabNamingBox.add(tabNamingFooter2);
        tabNamingPanel.add(tabNamingBox);
        tabNamingSpring.add(new JLabel(""));
        tabNamingSpring.add(new JLabel("Name Displayed:", 0));
        tabNamingSpring.add(new JLabel("Key:", 0));
        tabNamingSpring.add(new JLabel("Headquarters:", 11));
        tabNamingSpring.add(this.hqTabNameField);
        tabNamingSpring.add(this.hqTabMnemonicField);
        tabNamingSpring.add(new JLabel("Black Market:", 11));
        tabNamingSpring.add(this.bmTabNameField);
        tabNamingSpring.add(this.bmTabMnemonicField);
        tabNamingSpring.add(new JLabel("House Status:", 11));
        tabNamingSpring.add(this.hsTabNameField);
        tabNamingSpring.add(this.hsTabMnemonicField);
        tabNamingSpring.add(new JLabel("Battles:", 11));
        tabNamingSpring.add(this.batTabNameField);
        tabNamingSpring.add(this.batTabMnemonicField);
        tabNamingSpring.add(new JLabel("Map:", 11));
        tabNamingSpring.add(this.mapTabNameField);
        tabNamingSpring.add(this.mapTabMnemonicField);
        tabNamingSpring.add(new JLabel("Main Channel:", 11));
        tabNamingSpring.add(this.mcTabNameField);
        tabNamingSpring.add(this.mcTabMnemonicField);
        tabNamingSpring.add(new JLabel("House Channel:", 11));
        tabNamingSpring.add(this.hmTabNameField);
        tabNamingSpring.add(this.hmTabMnemonicField);
        tabNamingSpring.add(new JLabel("Private Channel:", 11));
        tabNamingSpring.add(this.pmTabNameField);
        tabNamingSpring.add(this.pmTabMnemonicField);
        tabNamingSpring.add(new JLabel("Personal Log:", 11));
        tabNamingSpring.add(this.pLogTabNameField);
        tabNamingSpring.add(this.pLogTabMnemonicField);
        tabNamingSpring.add(new JLabel("System Log:", 11));
        tabNamingSpring.add(this.sysLogTabNameField);
        tabNamingSpring.add(this.sysLogTabMnemonicField);
        tabNamingSpring.add(new JLabel("Miscellaneous:", 11));
        tabNamingSpring.add(this.miscTabNameField);
        tabNamingSpring.add(this.miscTabMnemonicField);
        SpringLayoutHelper.setupSpringGrid(tabNamingSpring, 12, 3);
        keyBindPanel.setLayout(new BoxLayout(keyBindPanel, 1));
        JPanel keySpringPanel = new JPanel(new SpringLayout());
        JLabel keyBindHeader1 = new JLabel("Function keys can be configured to run");
        JLabel keyBindHeader2 = new JLabel("commands. /c is prepended to the strings.");
        keyBindHeader1.setAlignmentX(0.5f);
        keyBindHeader2.setAlignmentX(0.5f);
        keySpringPanel.add(new JLabel("F1:", 11));
        this.f1Field.setMaximumSize(newDim);
        keySpringPanel.add(this.f1Field);
        keySpringPanel.add(new JLabel("F2:", 11));
        this.f2Field.setMaximumSize(newDim);
        keySpringPanel.add(this.f2Field);
        keySpringPanel.add(new JLabel("F3:", 11));
        this.f3Field.setMaximumSize(newDim);
        keySpringPanel.add(this.f3Field);
        keySpringPanel.add(new JLabel("F4:", 11));
        this.f4Field.setMaximumSize(newDim);
        keySpringPanel.add(this.f4Field);
        keySpringPanel.add(new JLabel("F5:", 11));
        this.f5Field.setMaximumSize(newDim);
        keySpringPanel.add(this.f5Field);
        SpringLayoutHelper.setupSpringGrid(keySpringPanel, 5, 2);
        keyBindPanel.add(keyBindHeader1);
        keyBindPanel.add(keyBindHeader2);
        keyBindPanel.add(keySpringPanel);
        JPanel tabVisWrapper = new JPanel();
        tabVisWrapper.add(tabVisibilityPanel);
        this.ConfigPane.addTab("User", null, playerPanel, "Player and Formatting options");
        this.ConfigPane.addTab("Chat", null, chatPanel, "Chat and Messaging options");
        this.ConfigPane.addTab("Sounds", null, soundPanel, "Sound options");
        this.ConfigPane.addTab("Tab Layout", null, tabVisWrapper, "Tab visibility configuration");
        this.ConfigPane.addTab("Tab Naming", null, tabNamingPanel, "Tab name configuration");
        this.ConfigPane.addTab("FKeys", null, keyBindPanel, "Function Key configuration");
        this.ConfigPane.addTab("Host Setup", null, dedicatedHostPanel, "Host Configuration");
        JPanel mainConfigPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, this.uNameField);
        this.dialog = this.pane.createDialog(mainConfigPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.showHexinHQBox.setSelected(this.mwclient.getConfig().isParam("UNITHEX"));
        this.darkenMapBox.setSelected(this.mwclient.getConfig().isParam("DARKERMAP"));
        this.bmPreviewImageBox.setSelected(this.mwclient.getConfig().isParam("BMPREVIEWIMAGE"));
        this.useStatusForIconBox.setSelected(this.mwclient.getConfig().isParam("STATUSINTRAYICON"));
        this.hqColumnsField.setText(this.mwclient.getConfig().getParam("UNITAMOUNT"));
        this.defaultArmyNameField.setText(this.mwclient.getConfig().getParam("DEFAULTARMYNAME"));
        this.uNameField.setText(this.mwclient.getConfig().getName());
        this.passwordField.setText(this.mwclient.getConfig().getPassword());
        this.ignorePrivateField.setText(this.mwclient.getConfig().getParam("IGNOREPRIVATE"));
        this.ignoreHouseField.setText(this.mwclient.getConfig().getParam("IGNOREHOUSE"));
        this.ignorePublicField.setText(this.mwclient.getConfig().getParam("IGNOREPUBLIC"));
        this.challengeStringField.setText(this.mwclient.getConfig().getParam("CHALLENGESTRING"));
        this.timeStampBox.setSelected(this.mwclient.getConfig().isParam("TIMESTAMP"));
        this.autoJoinGameBox.setSelected(this.mwclient.getConfig().isParam("AUTOJOINGAME"));
        this.autoConnectBox.setSelected(this.mwclient.getConfig().isParam("AUTOCONNECT"));
        this.soundOnCallField.setText(this.mwclient.getConfig().getParam("SOUNDONCALL"));
        this.soundOnKeywordField.setText(this.mwclient.getConfig().getParam("SOUNDONKEYWORD"));
        this.soundOnMessageField.setText(this.mwclient.getConfig().getParam("SOUNDONMESSAGE"));
        this.soundOnAttackField.setText(this.mwclient.getConfig().getParam("SOUNDONATTACK"));
        this.soundOnBMWinField.setText(this.mwclient.getConfig().getParam("SOUNDONBMWIN"));
        this.keywordsField.setText(this.mwclient.getConfig().getParam("KEYWORDS"));
        String scheme = this.mwclient.getConfigParam("HQCOLORSCHEME").toLowerCase();
        if (scheme.equals("tan")) {
            this.schemeComboBox.setSelectedIndex(1);
        } else if (scheme.equals("grey")) {
            this.schemeComboBox.setSelectedIndex(0);
        } else {
            this.schemeComboBox.setSelectedIndex(2);
        }
        String sysColor = this.mwclient.getConfigParam("SYSMESSAGECOLOR");
        if (sysColor.equals("#006400")) {
            this.sysMessageColorComboBox.setSelectedIndex(0);
        } else if (sysColor.equals("#FFD700")) {
            this.sysMessageColorComboBox.setSelectedIndex(1);
        } else if (sysColor.equals("#4B0082")) {
            this.sysMessageColorComboBox.setSelectedIndex(2);
        } else if (sysColor.equals("navy")) {
            this.sysMessageColorComboBox.setSelectedIndex(3);
        } else if (sysColor.equals("#FFA500")) {
            this.sysMessageColorComboBox.setSelectedIndex(4);
        } else if (sysColor.equals("teal")) {
            this.sysMessageColorComboBox.setSelectedIndex(6);
        } else {
            this.sysMessageColorComboBox.setSelectedIndex(5);
        }
        String skin = this.mwclient.getConfigParam("LOOKANDFEEL").toLowerCase();
        if (skin.equals("motif")) {
            this.lookandfeelComboBox.setSelectedIndex(1);
        } else if (skin.equals("metal")) {
            this.lookandfeelComboBox.setSelectedIndex(2);
        } else if (skin.equals("liquid")) {
            this.lookandfeelComboBox.setSelectedIndex(3);
        } else if (skin.equals("metouia")) {
            this.lookandfeelComboBox.setSelectedIndex(4);
        } else if (skin.equals("plastic")) {
            this.lookandfeelComboBox.setSelectedIndex(5);
        } else if (skin.equals("plastic3d")) {
            this.lookandfeelComboBox.setSelectedIndex(6);
        } else if (skin.equals("plasticxp")) {
            this.lookandfeelComboBox.setSelectedIndex(7);
        } else if (skin.equals("steel")) {
            this.lookandfeelComboBox.setSelectedIndex(8);
        } else if (skin.equals("jwindows")) {
            this.lookandfeelComboBox.setSelectedIndex(9);
        } else {
            this.lookandfeelComboBox.setSelectedIndex(0);
        }
        String chatNameColorMode = this.mwclient.getConfigParam("PLAYERCHATCOLORMODE").toLowerCase();
        if (chatNameColorMode.equals("factionname")) {
            this.playerChatColorComboBox.setSelectedIndex(3);
        } else if (chatNameColorMode.equals("factionadd")) {
            this.playerChatColorComboBox.setSelectedIndex(2);
        } else if (chatNameColorMode.equals("factionall")) {
            this.playerChatColorComboBox.setSelectedIndex(1);
        } else {
            this.playerChatColorComboBox.setSelectedIndex(0);
        }
        this.enableSoundOnCall.setSelected(this.mwclient.getConfig().isParam("ENABLECALLSOUND"));
        this.enableSoundOnMessage.setSelected(this.mwclient.getConfig().isParam("ENABLEMESSAGESOUND"));
        this.enableSoundOnAttack.setSelected(this.mwclient.getConfig().isParam("ENABLEATTACKSOUND"));
        this.enableSoundOnKeyword.setSelected(this.mwclient.getConfig().isParam("ENABLEKEYWORDSOUND"));
        this.enableSoundOnBMWin.setSelected(this.mwclient.getConfig().isParam("ENABLEBMSOUND"));
        this.systemMessageKeyword.setSelected(this.mwclient.getConfig().isParam("SOUNDSFROMSYSMESSAGES"));
        this.colorEmotesBox.setSelected(this.mwclient.getConfig().isParam("COLOREDEMOTES"));
        this.showEnterExitBox.setSelected(this.mwclient.getConfig().isParam("SHOWENTERANDEXIT"));
        this.blockImagesBox.setSelected(this.mwclient.getConfig().isParam("NOIMGINCHAT"));
        this.maxPlayersField.setText(this.mwclient.getConfig().getParam("MAXPLAYERS"));
        this.hostCommentsField.setText(this.mwclient.getConfig().getParam("COMMENT"));
        this.hqTabNameField.setText(this.mwclient.getConfig().getParam("HQTABNAME"));
        this.hqTabMnemonicField.setText(this.mwclient.getConfig().getParam("HQMNEMONIC"));
        this.hqTabonTopBox.setSelected(this.mwclient.getConfig().isParam("HQINTOPROW"));
        this.hqTabVisBox.setSelected(this.mwclient.getConfig().isParam("HQTABVISIBLE"));
        this.hsTabNameField.setText(this.mwclient.getConfig().getParam("HSTATUSTABNAME"));
        this.hsTabMnemonicField.setText(this.mwclient.getConfig().getParam("HSTATUSMNEMONIC"));
        this.hsTabonTopBox.setSelected(this.mwclient.getConfig().isParam("HSTATUSINTOPROW"));
        this.hsTabVisBox.setSelected(this.mwclient.getConfig().isParam("HSTATUSTABVISIBLE"));
        this.batTabNameField.setText(this.mwclient.getConfig().getParam("BATTLETABNAME"));
        this.batTabMnemonicField.setText(this.mwclient.getConfig().getParam("BATTLEMNEMONIC"));
        this.batTabonTopBox.setSelected(this.mwclient.getConfig().isParam("BATTLEINTOPROW"));
        this.batTabVisBox.setSelected(this.mwclient.getConfig().isParam("BATTLETABVISIBLE"));
        this.bmTabNameField.setText(this.mwclient.getConfig().getParam("BMTABNAME"));
        this.bmTabMnemonicField.setText(this.mwclient.getConfig().getParam("BMMNEMONIC"));
        this.bmTabonTopBox.setSelected(this.mwclient.getConfig().isParam("BMINTOPROW"));
        this.bmTabVisBox.setSelected(this.mwclient.getConfig().isParam("BMTABVISIBLE"));
        this.mapTabNameField.setText(this.mwclient.getConfig().getParam("MAPTABNAME"));
        this.mapTabMnemonicField.setText(this.mwclient.getConfig().getParam("MAPMNEMONIC"));
        this.mapTabonTopBox.setSelected(this.mwclient.getConfig().isParam("MAPINTOPROW"));
        this.mapTabVisBox.setSelected(this.mwclient.getConfig().isParam("MAPTABVISIBLE"));
        this.mcTabNameField.setText(this.mwclient.getConfig().getParam("MAINCHANNELTABNAME"));
        this.mcTabMnemonicField.setText(this.mwclient.getConfig().getParam("MAINCHANNELMNEMONIC"));
        this.hmTabNameField.setText(this.mwclient.getConfig().getParam("HOUSEMAILTABNAME"));
        this.hmTabVisBox.setSelected(this.mwclient.getConfig().isParam("HOUSEMAILVISIBLE"));
        this.hmTabMnemonicField.setText(this.mwclient.getConfig().getParam("HOUSEMAILMNEMONIC"));
        this.pmTabNameField.setText(this.mwclient.getConfig().getParam("PRIVATEMAILTABNAME"));
        this.pmTabVisBox.setSelected(this.mwclient.getConfig().isParam("PRIVATEMAILVISIBLE"));
        this.pmTabMnemonicField.setText(this.mwclient.getConfig().getParam("PRIVATEMAILMNEMONIC"));
        this.pLogTabNameField.setText(this.mwclient.getConfig().getParam("PERSONALLOGTABNAME"));
        this.pLogTabVisBox.setSelected(this.mwclient.getConfig().isParam("PERSONALLOGVISIBLE"));
        this.pLogTabMnemonicField.setText(this.mwclient.getConfig().getParam("PRIVATEMAILMNEMONIC"));
        this.sysLogTabNameField.setText(this.mwclient.getConfig().getParam("SYSTEMLOGTABNAME"));
        this.sysLogTabVisBox.setSelected(this.mwclient.getConfig().isParam("SYSTEMLOGVISIBLE"));
        this.sysLogTabMnemonicField.setText(this.mwclient.getConfig().getParam("SYSTEMLOGMNEMONIC"));
        this.miscTabNameField.setText(this.mwclient.getConfig().getParam("MISCELLANEOUSTABNAME"));
        this.miscTabVisBox.setSelected(this.mwclient.getConfig().isParam("MISCELLANEOUSVISIBLE"));
        this.miscTabMnemonicField.setText(this.mwclient.getConfig().getParam("MISCELLANEOUSMNEMONIC"));
        this.hmInMainBox.setSelected(this.mwclient.getConfig().isParam("MAINCHANNELHM"));
        this.pmInMainBox.setSelected(this.mwclient.getConfig().isParam("MAINCHANNELPM"));
        this.sysLogInMainBox.setSelected(this.mwclient.getConfig().isParam("MAINCHANNELSM"));
        this.miscInMainBox.setSelected(this.mwclient.getConfig().isParam("MAINCHANNELMISC"));
        this.pmReplyToSender.setSelected(this.mwclient.getConfig().isParam("REPLYTOSENDER"));
        this.pmReplyToReciever.setSelected(this.mwclient.getConfig().isParam("REPLYTORECEIVER"));
        this.chatNameColorField.setText(this.mwclient.getConfig().getParam("COLOR"));
        this.f1Field.setText(this.mwclient.getConfig().getParam("F1BIND"));
        this.f2Field.setText(this.mwclient.getConfig().getParam("F2BIND"));
        this.f3Field.setText(this.mwclient.getConfig().getParam("F3BIND"));
        this.f4Field.setText(this.mwclient.getConfig().getParam("F4BIND"));
        this.f5Field.setText(this.mwclient.getConfig().getParam("F5BIND"));
        this.enableDedicatedServerCB.setSelected(this.mwclient.getConfig().isParam("DEDICATED"));
        this.portField.setText(this.mwclient.getConfig().getParam("PORT").trim());
        this.nameField.setText(this.mwclient.getConfig().getParam("NAME").trim());
        this.prefixField.setText(this.mwclient.getConfig().getParam("DEDICATEDCOMMANDPREFIX").trim());
        this.ownersField.setText(this.mwclient.getConfig().getParam("DEDICATEDOWNERNAME").trim());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() == this.okayButton) {
            int currColumns;
            this.mwclient.getConfig().setParam("UNITHEX", Boolean.toString(this.showHexinHQBox.isSelected()));
            this.mwclient.getConfig().setParam("STATUSINTRAYICON", Boolean.toString(this.useStatusForIconBox.isSelected()));
            this.mwclient.getConfig().setParam("DARKERMAP", Boolean.toString(this.darkenMapBox.isSelected()));
            this.mwclient.getConfig().setParam("BMPREVIEWIMAGE", Boolean.toString(this.bmPreviewImageBox.isSelected()));
            if (Integer.parseInt(this.hqColumnsField.getText()) < 1) {
                this.hqColumnsField.setText(this.mwclient.getConfig().getDefaultParam("UNITAMOUNT"));
            }
            this.mwclient.getConfig().setParam("UNITAMOUNT", this.hqColumnsField.getText());
            this.mwclient.getConfig().setParam("DEFAULTARMYNAME", this.defaultArmyNameField.getText());
            this.mwclient.getConfig().setName(this.uNameField.getText());
            this.mwclient.getConfig().setPassword(new String(this.passwordField.getPassword()));
            this.mwclient.setUsername(this.uNameField.getText());
            this.mwclient.setPassword(new String(this.passwordField.getPassword()));
            this.mwclient.getConfig().setParam("IGNOREPRIVATE", this.ignorePrivateField.getText());
            this.mwclient.getConfig().setParam("IGNOREHOUSE", this.ignoreHouseField.getText());
            this.mwclient.getConfig().setParam("IGNOREPUBLIC", this.ignorePublicField.getText());
            this.mwclient.getConfig().setParam("CHALLENGESTRING", this.challengeStringField.getText());
            this.mwclient.getConfig().setParam("TIMESTAMP", Boolean.toString(this.timeStampBox.isSelected()));
            this.mwclient.getConfig().setParam("AUTOJOINGAME", Boolean.toString(this.autoJoinGameBox.isSelected()));
            this.mwclient.getConfig().setParam("AUTOCONNECT", Boolean.toString(this.autoConnectBox.isSelected()));
            this.mwclient.getConfig().setParam("SOUNDONCALL", this.soundOnCallField.getText());
            this.mwclient.getConfig().setParam("SOUNDONKEYWORD", this.soundOnKeywordField.getText());
            this.mwclient.getConfig().setParam("SOUNDONMESSAGE", this.soundOnMessageField.getText());
            this.mwclient.getConfig().setParam("SOUNDONATTACK", this.soundOnAttackField.getText());
            this.mwclient.getConfig().setParam("SOUNDONBMWIN", this.soundOnBMWinField.getText());
            this.mwclient.getConfig().setParam("MAXPLAYERS", this.maxPlayersField.getText());
            this.mwclient.getConfig().setParam("COMMENT", this.hostCommentsField.getText());
            this.mwclient.getConfig().setParam("KEYWORDS", this.keywordsField.getText());
            if (this.schemeComboBox.getSelectedIndex() == 1) {
                this.mwclient.getConfig().setParam("HQCOLORSCHEME", "tan");
            } else if (this.schemeComboBox.getSelectedIndex() == 0) {
                this.mwclient.getConfig().setParam("HQCOLORSCHEME", "grey");
            } else {
                this.mwclient.getConfig().setParam("HQCOLORSCHEME", "classic");
            }
            if (this.lookandfeelComboBox.getSelectedIndex() == 1) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "motif");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 2) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "metal");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 3) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "liquid");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 4) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "metouia");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 5) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "plastic");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 6) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "plastic3d");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 7) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "plasticxp");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 8) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "steel");
            } else if (this.lookandfeelComboBox.getSelectedIndex() == 9) {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "jwindows");
            } else {
                this.mwclient.getConfig().setParam("LOOKANDFEEL", "system");
            }
            if (this.sysMessageColorComboBox.getSelectedIndex() == 0) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "#006400");
            } else if (this.sysMessageColorComboBox.getSelectedIndex() == 1) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "#FFD700");
            } else if (this.sysMessageColorComboBox.getSelectedIndex() == 2) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "#4B0082");
            } else if (this.sysMessageColorComboBox.getSelectedIndex() == 3) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "navy");
            } else if (this.sysMessageColorComboBox.getSelectedIndex() == 4) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "#FFA500");
            } else if (this.sysMessageColorComboBox.getSelectedIndex() == 6) {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "teal");
            } else {
                this.mwclient.getConfig().setParam("SYSMESSAGECOLOR", "red");
            }
            if (this.playerChatColorComboBox.getSelectedIndex() == 2) {
                this.mwclient.getConfig().setParam("PLAYERCHATCOLORMODE", "factionadd");
            } else if (this.playerChatColorComboBox.getSelectedIndex() == 1) {
                this.mwclient.getConfig().setParam("PLAYERCHATCOLORMODE", "factionall");
            } else if (this.playerChatColorComboBox.getSelectedIndex() == 3) {
                this.mwclient.getConfig().setParam("PLAYERCHATCOLORMODE", "factionname");
            } else {
                this.mwclient.getConfig().setParam("PLAYERCHATCOLORMODE", "playercolors");
            }
            this.mwclient.getConfig().setParam("ENABLECALLSOUND", Boolean.toString(this.enableSoundOnCall.isSelected()));
            this.mwclient.getConfig().setParam("ENABLEMESSAGESOUND", Boolean.toString(this.enableSoundOnMessage.isSelected()));
            this.mwclient.getConfig().setParam("ENABLEATTACKSOUND", Boolean.toString(this.enableSoundOnAttack.isSelected()));
            this.mwclient.getConfig().setParam("ENABLEKEYWORDSOUND", Boolean.toString(this.enableSoundOnKeyword.isSelected()));
            this.mwclient.getConfig().setParam("ENABLEBMSOUND", Boolean.toString(this.enableSoundOnBMWin.isSelected()));
            this.mwclient.getConfig().setParam("SOUNDSFROMSYSMESSAGES", Boolean.toString(this.systemMessageKeyword.isSelected()));
            this.mwclient.getConfig().setParam("COLOREDEMOTES", Boolean.toString(this.colorEmotesBox.isSelected()));
            this.mwclient.getConfig().setParam("SHOWENTERANDEXIT", Boolean.toString(this.showEnterExitBox.isSelected()));
            this.mwclient.getConfig().setParam("NOIMGINCHAT", Boolean.toString(this.blockImagesBox.isSelected()));
            this.mwclient.getConfig().setParam("HQTABNAME", this.hqTabNameField.getText());
            this.mwclient.getConfig().setParam("HQMNEMONIC", this.hqTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("HQINTOPROW", Boolean.toString(this.hqTabonTopBox.isSelected()));
            this.mwclient.getConfig().setParam("HQTABVISIBLE", Boolean.toString(this.hqTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("BMTABNAME", this.bmTabNameField.getText());
            this.mwclient.getConfig().setParam("BMMNEMONIC", this.bmTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("BMINTOPROW", Boolean.toString(this.bmTabonTopBox.isSelected()));
            this.mwclient.getConfig().setParam("BMTABVISIBLE", Boolean.toString(this.bmTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("HSTATUSTABNAME", this.hsTabNameField.getText());
            this.mwclient.getConfig().setParam("HSTATUSMNEMONIC", this.hsTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("HSTATUSINTOPROW", Boolean.toString(this.hsTabonTopBox.isSelected()));
            this.mwclient.getConfig().setParam("HSTATUSTABVISIBLE", Boolean.toString(this.hsTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("BATTLETABNAME", this.batTabNameField.getText());
            this.mwclient.getConfig().setParam("BATTLEMNEMONIC", this.batTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("BATTLEINTOPROW", Boolean.toString(this.batTabonTopBox.isSelected()));
            this.mwclient.getConfig().setParam("BATTLETABVISIBLE", Boolean.toString(this.batTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("MAPTABNAME", this.mapTabNameField.getText());
            this.mwclient.getConfig().setParam("MAPMNEMONIC", this.mapTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("MAPINTOPROW", Boolean.toString(this.mapTabonTopBox.isSelected()));
            this.mwclient.getConfig().setParam("MAPTABVISIBLE", Boolean.toString(this.mapTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("MAINCHANNELTABNAME", this.mcTabNameField.getText());
            this.mwclient.getConfig().setParam("MAINCHANNELMNEMONIC", this.mcTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("HOUSEMAILTABNAME", this.hmTabNameField.getText());
            this.mwclient.getConfig().setParam("HOUSEMAILMNEMONIC", this.hmTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("HOUSEMAILVISIBLE", Boolean.toString(this.hmTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("PRIVATEMAILTABNAME", this.pmTabNameField.getText());
            this.mwclient.getConfig().setParam("PRIVATEMAILMNEMONIC", this.pmTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("PRIVATEMAILVISIBLE", Boolean.toString(this.pmTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("PERSONALLOGTABNAME", this.pLogTabNameField.getText());
            this.mwclient.getConfig().setParam("PERSONALLOGMNEMONIC", this.pLogTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("PERSONALLOGVISIBLE", Boolean.toString(this.pLogTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("SYSTEMLOGTABNAME", this.sysLogTabNameField.getText());
            this.mwclient.getConfig().setParam("SYSTEMLOGMNEMONIC", this.sysLogTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("SYSTEMLOGVISIBLE", Boolean.toString(this.sysLogTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("MISCELLANEOUSTABNAME", this.miscTabNameField.getText());
            this.mwclient.getConfig().setParam("MISCELLANEOUSMNEMONIC", this.miscTabMnemonicField.getText());
            this.mwclient.getConfig().setParam("MISCELLANEOUSVISIBLE", Boolean.toString(this.miscTabVisBox.isSelected()));
            this.mwclient.getConfig().setParam("MAINCHANNELHM", Boolean.toString(this.hmInMainBox.isSelected()));
            this.mwclient.getConfig().setParam("MAINCHANNELPM", Boolean.toString(this.pmInMainBox.isSelected()));
            this.mwclient.getConfig().setParam("MAINCHANNELSM", Boolean.toString(this.sysLogInMainBox.isSelected()));
            this.mwclient.getConfig().setParam("MAINCHANNELMISC", Boolean.toString(this.miscInMainBox.isSelected()));
            this.mwclient.getConfig().setParam("REPLYTOSENDER", Boolean.toString(this.pmReplyToSender.isSelected()));
            this.mwclient.getConfig().setParam("REPLYTORECEIVER", Boolean.toString(this.pmReplyToReciever.isSelected()));
            this.mwclient.getConfig().setParam("COLOR", this.chatNameColorField.getText());
            this.mwclient.getConfig().setParam("F1BIND", this.f1Field.getText());
            this.mwclient.getConfig().setParam("F2BIND", this.f2Field.getText());
            this.mwclient.getConfig().setParam("F3BIND", this.f3Field.getText());
            this.mwclient.getConfig().setParam("F4BIND", this.f4Field.getText());
            this.mwclient.getConfig().setParam("F5BIND", this.f5Field.getText());
            this.mwclient.getConfig().setParam("OLDSTYLETABS", "NO");
            this.mwclient.getConfig().setParam("DEDICATED", Boolean.toString(this.enableDedicatedServerCB.isSelected()));
            this.mwclient.getConfig().setParam("PORT", this.portField.getText().trim());
            if (this.enableDedicatedServerCB.isSelected()) {
                this.mwclient.getConfig().setParam("NAME", this.nameField.getText().trim());
            }
            this.mwclient.getConfig().setParam("DEDICATEDCOMMANDPREFIX", this.prefixField.getText().trim());
            this.mwclient.getConfig().setParam("DEDICATEDOWNERNAME", this.ownersField.getText().trim());
            this.mwclient.setIgnoreHouse();
            this.mwclient.setIgnorePrivate();
            this.mwclient.setIgnorePublic();
            this.mwclient.getConfig().saveConfig();
            this.mwclient.setConfig();
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "color " + this.chatNameColorField.getText());
            boolean columnsChanged = false;
            boolean schemeChanged = false;
            boolean unitHexChanged = false;
            boolean mapBrightnessChanged = false;
            if (!this.mwclient.getConfigParam("LOOKANDFEEL").equalsIgnoreCase(originalSkin)) {
                this.mwclient.setLookAndFeel(true);
            }
            if (!this.mwclient.getConfigParam("UNITHEX").equals(originalUnitHex)) {
                unitHexChanged = true;
            }
            if (!this.mwclient.getConfigParam("HQCOLORSCHEME").equalsIgnoreCase(originalScheme)) {
                schemeChanged = true;
            }
            if (!this.mwclient.getConfigParam("DARKERMAP").equalsIgnoreCase(originalScheme)) {
                mapBrightnessChanged = true;
            }
            if ((currColumns = Integer.parseInt(this.mwclient.getConfigParam("UNITAMOUNT"))) != originalColumns) {
                columnsChanged = true;
            }
            if (columnsChanged || schemeChanged || unitHexChanged) {
                this.mwclient.getMainFrame().getMainPanel().selectFirstTab();
                this.mwclient.getMainFrame().getMainPanel().getCommPanel().selectFirstTab();
                this.mwclient.getMainFrame().getMainPanel().getHQPanel().reinitialize();
            }
            if (mapBrightnessChanged) {
                this.mwclient.getMainFrame().getMainPanel().getMapPanel().repaint();
            }
            if (!this.mwclient.getConfigParam("BMPREVIEWIMAGE").equalsIgnoreCase(originalBMPreview)) {
                this.mwclient.getMainFrame().getMainPanel().getBMPanel().resetButtonBar();
            }
        } else {
            this.dialog.dispose();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else if (command.equals(camoCommand)) {
            CamoSelectionDialog camoDialog = new CamoSelectionDialog(new JFrame(), this.mwclient);
            camoDialog.setVisible(true);
        }
    }
}

