/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.CMainFrame;
import client.gui.SpringLayoutHelper;
import common.House;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import megamek.client.Client;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

public class CustomUnitDialog
extends JDialog
implements ActionListener {
    private JLabel labAutoEject = new JLabel("Disable Autoeject", 11);
    private JCheckBox chAutoEject = new JCheckBox();
    private JCheckBox chSearchLight = new JCheckBox();
    private JCheckBox chSearchLightSetting = new JCheckBox();
    private JLabel labOffBoard = new JLabel("Deploy Offboard", 11);
    private JCheckBox chOffBoard = new JCheckBox();
    private JLabel labOffBoardDistance = new JLabel("Offboard Distance (Maps):", 11);
    private JTextField fldOffBoardDistance = new JTextField(4);
    private JPanel boxPanel;
    private JScrollPane scrollPane;
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton("Okay");
    private JButton butCancel = new JButton("Cancel");
    private Vector m_vMunitions = new Vector();
    private JPanel panMunitions = new JPanel();
    private Vector m_vMachineGuns = new Vector();
    private JPanel panMachineGuns = new JPanel();
    private JLabel labTargSys = new JLabel("Targeting System", 11);
    private Choice choTargSys = new Choice();
    private Entity entity;
    private boolean okay = false;
    private MWClient mwclient;
    private CMainFrame clientgui;
    private Vector optionComps = new Vector();
    private JPanel panOptions = new JPanel();
    private boolean editable;
    private boolean canDump = false;
    private Client mmClient = new Client("temp", "None", 0);

    public CustomUnitDialog(CMainFrame clientgui, MWClient mwclient, Entity entity, boolean editable) {
        this.entity = entity;
        this.mwclient = mwclient;
        this.editable = editable;
        this.clientgui = clientgui;
        this.mmClient.game.getOptions().loadOptions("");
        if (Integer.parseInt(mwclient.getserverConfigs("AmmoCharge")) > 0) {
            this.setTitle("Customize Unit (Ammo: " + mwclient.moneyOrFluMessage(true, true, Integer.parseInt(mwclient.getserverConfigs("AmmoCharge"))) + "/Ton)");
        } else {
            this.setTitle("Customize Unit");
        }
        this.loadBannedAmmo();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 1));
        this.scrollPane = new JScrollPane(scrollPanel);
        this.getContentPane().add(this.scrollPane);
        this.getContentPane().add(this.panButtons);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butOkay);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        int boxRows = 0;
        this.boxPanel = new JPanel(new SpringLayout());
        if (entity instanceof Mech) {
            Mech mech = (Mech)entity;
            this.chAutoEject.setSelected(!mech.isAutoEject());
            this.boxPanel.add(this.labAutoEject);
            this.boxPanel.add(this.chAutoEject);
            ++boxRows;
        }
        this.chSearchLight.setText("Add Spotlight?");
        this.boxPanel.add(this.chSearchLight);
        this.chSearchLightSetting.setText("Default On?");
        this.boxPanel.add(this.chSearchLightSetting);
        this.chSearchLightSetting.setSelected(entity.isUsingSpotlight());
        this.chSearchLight.setSelected(entity.hasSpotlight());
        ++boxRows;
        if (!entity.hasTargComp() && this.mmClient.game.getOptions().booleanOption("allow_level_3_targsys") && entity instanceof Mech && !entity.hasC3M() && !entity.hasC3MM()) {
            this.boxPanel.add(this.labTargSys);
            this.choTargSys.add(MiscType.getTargetSysName(0));
            this.choTargSys.add(MiscType.getTargetSysName(2));
            this.choTargSys.add(MiscType.getTargetSysName(3));
            this.choTargSys.add(MiscType.getTargetSysName(5));
            this.boxPanel.add(this.choTargSys);
            this.choTargSys.select(MiscType.getTargetSysName(entity.getTargSysType()));
            ++boxRows;
        }
        boolean eligibleForOffBoard = false;
        Enumeration i = entity.getWeapons();
        while (i.hasMoreElements()) {
            Mounted mounted = (Mounted)i.nextElement();
            WeaponType wtype = (WeaponType)mounted.getType();
            if (!wtype.hasFlag(65536)) continue;
            eligibleForOffBoard = true;
        }
        if (eligibleForOffBoard) {
            this.boxPanel.add(this.labOffBoard);
            this.boxPanel.add(this.chOffBoard);
            this.chOffBoard.setSelected(entity.isOffBoard());
            this.boxPanel.add(this.labOffBoardDistance);
            this.fldOffBoardDistance.setText(Integer.toString(entity.getOffBoardDistance()));
            this.boxPanel.add(this.fldOffBoardDistance);
            boxRows += 2;
        }
        SpringLayoutHelper.setupSpringGrid(this.boxPanel, boxRows, 2);
        scrollPanel.add(this.boxPanel);
        if (!(entity instanceof Infantry)) {
            this.setupMunitions();
            JPanel centeringPanel = new JPanel();
            centeringPanel.setLayout(new BoxLayout(centeringPanel, 1));
            centeringPanel.add(this.panMunitions);
            scrollPanel.add(centeringPanel);
            if (this.panMunitions.getComponentCount() == 0) {
                this.setTitle("Customize Unit");
            }
        }
        if (this.mmClient.game.getOptions().booleanOption("maxtech_burst") && (entity instanceof Mech || entity instanceof Tank)) {
            this.setupMachineGuns();
            scrollPanel.add(this.panMachineGuns);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CustomUnitDialog.this.setVisible(false);
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(150, 150));
        this.scrollPane.setMaximumSize(new Dimension(780, 580));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void setupMunitions() {
        int munitionsRows = 0;
        this.panMunitions.setLayout(new SpringLayout());
        MunitionChoicePanel mcp = null;
        boolean row = false;
        int location = -1;
        Enumeration e = this.entity.getAmmo();
        while (e.hasMoreElements()) {
            int loc;
            Mounted m = (Mounted)e.nextElement();
            AmmoType at = (AmmoType)m.getType();
            Vector<AmmoType> vTypes = new Vector<AmmoType>();
            Vector vAllTypes = AmmoType.getMunitionsFor(at.getAmmoType());
            ++location;
            this.canDump = this.mmClient.game.getOptions().booleanOption("lobby_ammo_dump");
            if (vAllTypes == null || vAllTypes.size() < 2 && !this.canDump) continue;
            int n = vAllTypes.size();
            for (int x = 0; x < n; ++x) {
                AmmoType atCheck = (AmmoType)vAllTypes.elementAt(x);
                boolean bTechMatch = TechConstants.isLegal(this.entity.getTechLevel(), atCheck.getTechLevel());
                String munition = Long.toString(atCheck.getMunitionType());
                House faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse());
                if (this.mwclient.getData().getServerBannedAmmo().get(munition) != null || faction.getBannedAmmo().get(munition) != null) continue;
                if (!bTechMatch && this.entity.getTechLevel() == 1 && atCheck.getTechLevel() == 0) {
                    bTechMatch = true;
                }
                if (!this.mmClient.game.getOptions().booleanOption("is_eq_limits") && this.entity.getTechLevel() == 0 && atCheck.getTechLevel() == 1) {
                    bTechMatch = true;
                }
                if (this.mmClient.game.getOptions().booleanOption("allow_level_3_ammo")) {
                    if (!this.mmClient.game.getOptions().booleanOption("is_eq_limits")) {
                        if (this.entity.getTechLevel() == 2 && atCheck.getTechLevel() == 6) {
                            bTechMatch = true;
                        }
                        if ((this.entity.getTechLevel() == 0 || this.entity.getTechLevel() == 1) && atCheck.getTechLevel() == 5) {
                            bTechMatch = true;
                        }
                    }
                } else if (atCheck.getTechLevel() == 5 || atCheck.getTechLevel() == 6) {
                    bTechMatch = false;
                }
                if (this.entity.isMixedTech()) {
                    bTechMatch = true;
                }
                long muniType = atCheck.getMunitionType();
                if (!this.mmClient.game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((muniType &= 0xFFFFFFFFFFFFEFFFL) == 16384L || muniType == 262144L || muniType == 524288L || muniType == 0x100000L || muniType == 0x200000L || muniType == 0x80000000L || muniType == 0x100000000L)) {
                    bTechMatch = false;
                }
                if (!this.mmClient.game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(atCheck) || atCheck.hasFlag(64) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && atCheck.hasFlag(1) && !atCheck.hasFlag(64) || !bTechMatch || atCheck.getRackSize() != at.getRackSize() || atCheck.hasFlag(4096) || atCheck.getTonnage(this.entity) != at.getTonnage(this.entity)) continue;
                vTypes.addElement(atCheck);
            }
            mcp = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(m, vTypes, location) : new MunitionChoicePanel(m, vTypes, location);
            if (m.getLocation() == -1) {
                Mounted linkedBy = m.getLinkedBy();
                loc = linkedBy.getLocation();
            } else {
                loc = m.getLocation();
            }
            this.panMunitions.add(new JLabel(this.entity.getLocationAbbr(loc) + ":", 11));
            this.panMunitions.add(mcp);
            this.m_vMunitions.addElement(mcp);
            ++munitionsRows;
        }
        if (munitionsRows >= 7) {
            if (munitionsRows % 2 != 0) {
                ++munitionsRows;
                this.panMunitions.add(new JLabel(""));
                this.panMunitions.add(new JLabel(""));
            }
            SpringLayoutHelper.setupSpringGrid(this.panMunitions, munitionsRows / 2, 4);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.panMunitions, munitionsRows, 2);
        }
    }

    private void setupMachineGuns() {
        int mgRows = 0;
        this.panMachineGuns.setLayout(new SpringLayout());
        boolean row = false;
        int location = -1;
        Enumeration e = this.entity.getWeapons();
        while (e.hasMoreElements()) {
            Mounted m = (Mounted)e.nextElement();
            WeaponType wt = (WeaponType)m.getType();
            ++location;
            if (!wt.hasFlag(512)) continue;
            MachineGunChoicePanel mgcp = new MachineGunChoicePanel(m, location);
            this.panMachineGuns.add(mgcp);
            this.m_vMachineGuns.addElement(mgcp);
            ++mgRows;
        }
        if (mgRows >= 6) {
            if (mgRows % 2 != 0) {
                ++mgRows;
                this.panMachineGuns.add(new JLabel(""));
                this.panMachineGuns.add(new JLabel(""));
            }
            SpringLayoutHelper.setupSpringGrid(this.panMachineGuns, mgRows / 2, 2);
        } else {
            SpringLayoutHelper.setupSpringGrid(this.panMachineGuns, mgRows, 1);
        }
    }

    public boolean isOkay() {
        return this.okay;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.butCancel) {
            boolean autoEject = this.chAutoEject.isSelected();
            boolean searchLight = this.chSearchLight.isSelected();
            boolean searchLightSetting = this.chSearchLightSetting.isSelected();
            if (this.chOffBoard.isSelected()) {
                int offBoardDistance;
                try {
                    offBoardDistance = Integer.parseInt(this.fldOffBoardDistance.getText());
                }
                catch (NumberFormatException e) {
                    this.mwclient.showInfoWindow("Please enter valid numbers for skill values.");
                    return;
                }
                if (offBoardDistance < 17) {
                    this.mwclient.showInfoWindow("Offboard units need to be at least one mapsheet (17 hexes) away.");
                    return;
                }
                this.entity.setOffBoard(offBoardDistance, 0);
            } else {
                this.entity.setOffBoard(0, -1);
            }
            if (this.entity instanceof Mech) {
                Mech mech = (Mech)this.entity;
                if (mech.isAutoEject() == autoEject) {
                    mech.setAutoEject(!autoEject);
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setautoeject#" + mech.getExternalId() + "#" + !autoEject);
                }
                if (!this.entity.hasTargComp() && this.mmClient.game.getOptions().booleanOption("allow_level_3_targsys")) {
                    int targSysIndex = 0;
                    if (this.choTargSys.getSelectedItem() != null) {
                        targSysIndex = MiscType.getTargetSysType(this.choTargSys.getSelectedItem());
                    }
                    if (this.entity.getTargSysType() != targSysIndex) {
                        if (targSysIndex >= 0) {
                            this.entity.setTargSysType(targSysIndex);
                        } else {
                            System.err.println("Illegal targetting system index: " + targSysIndex);
                            this.entity.setTargSysType(0);
                        }
                        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c settargetsystemtype#" + mech.getExternalId() + "#" + this.entity.getTargSysType());
                    }
                }
            }
            if (this.entity.hasSpotlight() != searchLight || this.entity.isUsingSpotlight() != searchLightSetting) {
                this.entity.setSpotlight(searchLight);
                this.entity.setSpotlightState(searchLightSetting);
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setsearchlight#" + this.entity.getExternalId() + "#" + searchLight + "#" + searchLightSetting);
            }
            this.okay = true;
            Enumeration e = this.m_vMunitions.elements();
            while (e.hasMoreElements()) {
                ((MunitionChoicePanel)e.nextElement()).applyChoice();
            }
            e = this.m_vMachineGuns.elements();
            while (e.hasMoreElements()) {
                ((MachineGunChoicePanel)e.nextElement()).applyChoice();
            }
        }
        this.setVisible(false);
    }

    private void loadBannedAmmo() {
        this.mwclient.loadServerBannedAmmo();
        this.mwclient.loadHouseBannedAmmo();
    }

    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        public ProtomechMunitionChoicePanel(Mounted m, Vector vTypes, int row) {
            super(m, vTypes, row);
            this.m_origAmmo = (AmmoType)m.getType();
            this.m_origShotsLeft = m.getShotsLeft();
        }

        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.isSelected()) {
                this.setShotsLeft(0);
            }
        }
    }

    class MachineGunChoicePanel
    extends JPanel {
        private Mounted m_mounted;
        private int location = 0;
        protected JCheckBox chBurst = new JCheckBox();

        public MachineGunChoicePanel(Mounted m, int location) {
            this.m_mounted = m;
            this.location = location;
            int loc = m.getLocation();
            this.chBurst.setSelected(this.m_mounted.isRapidfire());
            this.chBurst.setText("Rapid Fire MG (" + CustomUnitDialog.this.entity.getLocationAbbr(loc) + ")");
            this.add(this.chBurst);
        }

        public void applyChoice() {
            if (this.m_mounted.isRapidfire() != this.chBurst.isSelected()) {
                CustomUnitDialog.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setunitburst#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + this.chBurst.isSelected());
            }
        }

        public void setEnabled(boolean enabled) {
            this.chBurst.setEnabled(enabled);
        }
    }

    class MunitionChoicePanel
    extends JPanel {
        private Vector m_vTypes;
        private JComboBox m_choice;
        private Mounted m_mounted;
        private int location = 0;
        protected JCheckBox chDump = new JCheckBox();

        public MunitionChoicePanel(Mounted m, Vector vTypes, int location) {
            this.m_vTypes = vTypes;
            this.m_mounted = m;
            this.location = location;
            AmmoType curType = (AmmoType)m.getType();
            this.m_choice = new JComboBox();
            Enumeration e = this.m_vTypes.elements();
            int x = 0;
            while (e.hasMoreElements()) {
                AmmoType at = (AmmoType)e.nextElement();
                this.m_choice.addItem(at.getName());
                if (at.getInternalName().equalsIgnoreCase(curType.getInternalName())) {
                    this.m_choice.setSelectedIndex(x);
                }
                ++x;
            }
            this.add(this.m_choice);
            if (CustomUnitDialog.this.canDump) {
                if (m.getShotsLeft() == 0) {
                    this.chDump.setSelected(true);
                }
                this.chDump.setText("Dump");
                this.add(this.chDump);
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            AmmoType at = (AmmoType)this.m_vTypes.elementAt(n);
            if (this.chDump.isSelected()) {
                this.m_mounted.setShotsLeft(0);
                CustomUnitDialog.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setunitammo#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + at.getAmmoType() + "#" + at.getInternalName() + "#0");
            } else {
                CustomUnitDialog.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setunitammo#" + CustomUnitDialog.this.entity.getExternalId() + "#" + this.location + "#" + at.getAmmoType() + "#" + at.getInternalName() + "#" + at.getShots());
            }
        }

        public void setEnabled(boolean enabled) {
            this.m_choice.setEnabled(enabled);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int shots) {
            this.m_mounted.setShotsLeft(shots);
        }
    }
}

