/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.House;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class HouseNameDialog
extends JDialog
implements ActionListener {
    private final Collection factions;
    private final TreeSet factionNames;
    private JList matchingHousesList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private String factionName = null;
    private boolean addblank = false;

    public HouseNameDialog(MWClient mwclient, String boxText, boolean addblank) {
        super(new JFrame(), boxText, true);
        this.factions = mwclient.getData().getAllHouses();
        this.addblank = addblank;
        this.factionNames = new TreeSet();
        Iterator it = this.factions.iterator();
        while (it.hasNext()) {
            this.factionNames.add(((House)it.next()).getName());
        }
        final Object[] allHouseNames = this.factionNames.toArray();
        this.matchingHousesList = new JList<Object>(allHouseNames);
        this.matchingHousesList.setVisibleRowCount(10);
        this.matchingHousesList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = HouseNameDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            HouseNameDialog.this.matchingHousesList.setListData(allHouseNames);
                            return;
                        }
                        ArrayList<String> possibleHouses = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curHouse : HouseNameDialog.this.factionNames) {
                            if (curHouse.toLowerCase().indexOf(text) == -1) continue;
                            possibleHouses.add(curHouse);
                        }
                        HouseNameDialog.this.matchingHousesList.setListData(possibleHouses.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = possibleHouses.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                HouseNameDialog.this.matchingHousesList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            HouseNameDialog.this.matchingHousesList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingHousesList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedHouse = (String)this.matchingHousesList.getSelectedValue();
            if (selectedHouse == null) {
                selectedHouse = this.nameField.getText();
            }
            if (!this.addblank && (selectedHouse == null || selectedHouse.equals(""))) {
                return;
            }
            if (this.matchingHousesList.getModel().getSize() == 1) {
                selectedHouse = (String)this.matchingHousesList.getModel().getElementAt(0);
            }
            for (House faction : this.factions) {
                if (!selectedHouse.equals(faction.getName())) continue;
                this.setHouseName(faction.getName());
                this.setVisible(false);
                return;
            }
            JOptionPane.showMessageDialog(null, "Unknown House");
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setHouseName(String name) {
        this.factionName = name;
    }

    public String getHouseName() {
        return this.factionName;
    }
}

