/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import common.House;
import common.Planet;
import common.UnitFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class RewardPointsDialog
implements ActionListener,
KeyListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Okay";
    private static final String cancelCommand = "Cancel";
    private static final String unitCommand = "Units";
    private static final String weightCommand = "Weight";
    private static final String rewardCommand = "Reward";
    private static final String factionCommand = "House";
    private static final String repodCommand = "Repod";
    private static final String refreshCommand = "Refresh";
    private static final String windowName = "Reward Points";
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JLabel costLabel = new JLabel();
    private final JLabel currentRPLabel = new JLabel();
    private final JLabel rewardLabel = new JLabel("Reward Type:", 11);
    private final JLabel factionLabel = new JLabel("House Table:", 11);
    private final JLabel unitLabel = new JLabel("Unit Type:", 11);
    private final JLabel weightLabel = new JLabel("Weight Class:", 11);
    private final JLabel repodLabel = new JLabel("Repod Selection:", 11);
    private final JLabel pUnitsLabel = new JLabel("Unit:", 11);
    private final JLabel refreshLabel = new JLabel("Refresh:", 11);
    private final String[] unitChoices = new String[]{"Mek", "Vehicle", "Infantry", "ProtoMek", "BattleArmor"};
    private final JComboBox unitComboBox = new JComboBox<String>(this.unitChoices);
    private final String[] weightChoices = new String[]{"Light", "Medium", "Heavy", "Assault"};
    private final JComboBox weightComboBox = new JComboBox<String>(this.weightChoices);
    private JComboBox rewardsComboBox = new JComboBox();
    private JComboBox factionComboBox = new JComboBox();
    private JComboBox repodComboBox = new JComboBox();
    private JComboBox pUnitsComboBox = new JComboBox();
    private JComboBox refreshComboBox = new JComboBox();
    private final JTextField amountText = new JTextField(5);
    private final JLabel amountLabel = new JLabel("RP to use:", 11);
    int cost = 0;
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public RewardPointsDialog(MWClient c) {
        this.mwclient = c;
        TreeSet<String> names = new TreeSet<String>();
        names.add("Common");
        Iterator<House> factions = this.mwclient.getData().getAllHouses().iterator();
        while (factions.hasNext()) {
            names.add(factions.next().getName());
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowRareUnitsForRewards")).booleanValue()) {
            names.add("Rare");
        }
        this.factionComboBox = new JComboBox<Object>(names.toArray());
        names = new TreeSet();
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowTechsForRewards")).booleanValue()) {
            names.add("Techs");
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowInfluenceForRewards")).booleanValue()) {
            names.add(this.mwclient.getserverConfigs("FluLongName"));
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowUnitsForRewards")).booleanValue()) {
            names.add(unitCommand);
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("GlobalRepodAllowed")).booleanValue()) {
            names.add(repodCommand);
            TreeSet<String> repodOptions = new TreeSet<String>();
            if (Boolean.valueOf(this.mwclient.getserverConfigs("RandomRepodOnly")).booleanValue()) {
                repodOptions.add("Random");
            } else {
                if (Boolean.valueOf(this.mwclient.getserverConfigs("RandomRepodAllowed")).booleanValue()) {
                    repodOptions.add("Random");
                }
                repodOptions.add("Select");
            }
            this.repodComboBox = new JComboBox<Object>(repodOptions.toArray());
            repodOptions.clear();
            for (CUnit unit : c.getPlayer().getHangar()) {
                if (!unit.isOmni()) continue;
                repodOptions.add("#" + unit.getId() + " " + unit.getModelName());
            }
            this.pUnitsComboBox = new JComboBox<Object>(repodOptions.toArray());
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowFactoryRefreshForRewards")).booleanValue()) {
            TreeSet<String> factories = new TreeSet<String>();
            House faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse());
            Iterator planets = this.mwclient.getData().getAllPlanets().iterator();
            names.add(refreshCommand);
            while (planets.hasNext()) {
                Planet planet = (Planet)planets.next();
                if (!planet.isOwner(faction.getId())) continue;
                for (UnitFactory factory : planet.getUnitFactories()) {
                    if (factory.getTicksUntilRefresh() <= 0) continue;
                    factories.add(planet.getName() + ": " + factory.getName() + "(" + factory.getTicksUntilRefresh() + ")");
                }
            }
            this.refreshComboBox = new JComboBox<Object>(factories.toArray());
        }
        this.rewardsComboBox = new JComboBox<Object>(names.toArray());
        this.cost = 0;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.factionComboBox.setActionCommand(factionCommand);
        this.rewardsComboBox.setActionCommand(rewardCommand);
        this.unitComboBox.setActionCommand(unitCommand);
        this.weightComboBox.setActionCommand(weightCommand);
        this.repodComboBox.setActionCommand(repodCommand);
        this.refreshComboBox.setActionCommand(refreshCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.factionComboBox.addActionListener(this);
        this.rewardsComboBox.addActionListener(this);
        this.unitComboBox.addActionListener(this);
        this.weightComboBox.addActionListener(this);
        this.repodComboBox.addActionListener(this);
        this.pUnitsComboBox.addActionListener(this);
        this.refreshComboBox.addActionListener(this);
        this.amountText.addKeyListener(this);
        JPanel rewardPanel = new JPanel();
        rewardPanel.setLayout(new BoxLayout(rewardPanel, 1));
        JPanel comboPanel = new JPanel(new SpringLayout());
        JPanel costPanel = new JPanel();
        comboPanel.add(this.rewardLabel);
        this.rewardsComboBox.setToolTipText("Select your Reward Type");
        comboPanel.add(this.rewardsComboBox);
        comboPanel.add(this.factionLabel);
        this.factionComboBox.setToolTipText("Select the faction build table you wish to use");
        comboPanel.add(this.factionComboBox);
        comboPanel.add(this.unitLabel);
        this.unitComboBox.setToolTipText("Select the Unit Type");
        comboPanel.add(this.unitComboBox);
        comboPanel.add(this.weightLabel);
        this.weightComboBox.setToolTipText("Unit Weight Class");
        comboPanel.add(this.weightComboBox);
        comboPanel.add(this.pUnitsLabel);
        this.pUnitsComboBox.setToolTipText("Unit");
        comboPanel.add(this.pUnitsComboBox);
        comboPanel.add(this.repodLabel);
        this.repodComboBox.setToolTipText("Repod Selection Type");
        comboPanel.add(this.repodComboBox);
        comboPanel.add(this.refreshLabel);
        this.refreshComboBox.setToolTipText("Refresh Factory");
        comboPanel.add(this.refreshComboBox);
        comboPanel.add(this.amountLabel);
        comboPanel.add(this.amountText);
        comboPanel.add(new JLabel("", 11));
        comboPanel.add(new JLabel("", 11));
        SpringLayoutHelper.setupSpringGrid(comboPanel, 8, 2);
        rewardPanel.add(comboPanel);
        costPanel.add(this.costLabel);
        rewardPanel.add(costPanel);
        this.costLabel.setText("Result: no expenditure");
        this.weightComboBox.setSelectedIndex(0);
        this.unitComboBox.setSelectedIndex(0);
        this.factionComboBox.setSelectedIndex(0);
        if (Boolean.valueOf(this.mwclient.getserverConfigs("AllowUnitsForRewards")).booleanValue()) {
            this.rewardsComboBox.setSelectedItem(unitCommand);
            this.cost = this.getUnitRPCost();
            this.costLabel.setText("RP Required: " + this.cost + " RP");
        } else {
            this.rewardsComboBox.setSelectedIndex(0);
        }
        if (((String)this.rewardsComboBox.getSelectedItem()).equals(unitCommand)) {
            this.makeVisible(true, false, false);
        } else {
            this.makeVisible(false, false, false);
        }
        JPanel mainPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(rewardPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() != this.okayButton) {
            this.dialog.dispose();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        String selection = (String)this.rewardsComboBox.getSelectedItem();
        this.cost = Integer.parseInt(this.amountText.getText());
        if (!selection.equals(unitCommand)) {
            if (selection.equals("Techs")) {
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("TechsForARewardPoint"));
                this.costLabel.setText("Result: Hire " + total + " Techs");
            } else if (selection.equals(repodCommand)) {
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    this.cost /= 2;
                }
                this.costLabel.setText("RP Required: " + this.cost + " RP");
            } else if (selection.equals(refreshCommand)) {
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointToRefreshFactory"));
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.dialog.repaint();
            } else {
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("InfluenceForARewardPoint"));
                this.costLabel.setText("Result: Gain " + this.mwclient.moneyOrFluMessage(false, true, total));
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            String selection = (String)this.rewardsComboBox.getSelectedItem();
            if (selection.equals(unitCommand)) {
                String type = (String)this.unitComboBox.getSelectedItem();
                String weight = (String)this.weightComboBox.getSelectedItem();
                String faction = (String)this.factionComboBox.getSelectedItem();
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c userewardpoints#2#" + type + "#" + weight + "#" + faction);
            } else if (selection.equals("Techs")) {
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c userewardpoints#0#" + this.amountText.getText());
            } else if (selection.equals(repodCommand)) {
                if (this.pUnitsComboBox.getComponentCount() < 1) {
                    this.dialog.dispose();
                }
                String options = "#GLOBAL";
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    options = options + "#RANDOM";
                }
                StringTokenizer unitid = new StringTokenizer((String)this.pUnitsComboBox.getSelectedItem(), " ");
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c repod" + unitid.nextToken() + options);
            } else if (selection.equals(refreshCommand)) {
                if (this.refreshComboBox.getComponentCount() < 1) {
                    this.dialog.dispose();
                }
                String factoryInfo = (String)this.refreshComboBox.getSelectedItem();
                String planet = factoryInfo.substring(0, factoryInfo.indexOf(":")).trim();
                String factory = factoryInfo.substring(planet.length() + 2, factoryInfo.indexOf("(")).trim();
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c refreshFactory#" + planet + "#" + factory);
            } else {
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c userewardpoints#1#" + this.amountText.getText());
            }
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else if (command.equals(rewardCommand)) {
            String selection = (String)this.rewardsComboBox.getSelectedItem();
            if (selection.equals(unitCommand)) {
                this.makeVisible(true, false, false);
                this.unitComboBox.setSelectedIndex(0);
                this.weightComboBox.setSelectedIndex(0);
                this.factionComboBox.setSelectedIndex(0);
                this.cost = this.getUnitRPCost();
                this.costLabel.setText("RP Required: " + this.cost + " RP");
            } else if (selection.equals("Techs")) {
                this.makeVisible(false, false, false);
                this.amountText.setText("0");
                this.cost = Integer.parseInt(this.amountText.getText());
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("TechsForARewardPoint"));
                this.costLabel.setText("Result: Hire " + total + " Techs");
                this.costLabel.repaint();
            } else if (selection.equals(repodCommand)) {
                if (this.pUnitsComboBox.getComponentCount() >= 1) {
                    this.pUnitsComboBox.setSelectedIndex(0);
                }
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    this.cost /= 2;
                }
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.makeVisible(false, true, false);
            } else if (selection.equals(refreshCommand)) {
                if (this.refreshComboBox.getComponentCount() >= 1) {
                    this.refreshComboBox.setSelectedIndex(0);
                }
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointToRefreshFactory"));
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.makeVisible(false, false, true);
            } else {
                this.amountText.setText("0");
                this.cost = Integer.parseInt(this.amountText.getText());
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("InfluenceForARewardPoint"));
                this.costLabel.setText("Result: Gain " + this.mwclient.moneyOrFluMessage(false, true, total));
                this.makeVisible(false, false, false);
            }
        } else if (command.equals(repodCommand)) {
            this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
            if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                this.cost /= 2;
            }
            this.costLabel.setText("RP Required: " + this.cost + " RP");
        } else if (command.equals(weightCommand) || command.equals(unitCommand) || command.equals(factionCommand)) {
            this.cost = this.getUnitRPCost();
            this.costLabel.setText("RP Required: " + this.cost + " RP");
        }
    }

    private void makeVisible(boolean visible, boolean repod, boolean refresh) {
        this.unitComboBox.setVisible(visible);
        this.weightComboBox.setVisible(visible);
        this.factionComboBox.setVisible(visible);
        this.unitLabel.setVisible(visible);
        this.weightLabel.setVisible(visible);
        this.factionLabel.setVisible(visible);
        this.repodComboBox.setVisible(repod);
        this.repodLabel.setVisible(repod);
        this.pUnitsComboBox.setVisible(repod);
        this.pUnitsLabel.setVisible(repod);
        this.refreshComboBox.setVisible(refresh);
        this.refreshLabel.setVisible(refresh);
        if (repod || refresh) {
            this.amountLabel.setVisible(false);
            this.amountText.setVisible(false);
        } else {
            this.amountLabel.setVisible(!visible);
            this.amountText.setVisible(!visible);
        }
    }

    private int getUnitRPCost() {
        int type = CUnit.getTypeIDForName((String)this.unitComboBox.getSelectedItem());
        int weight = CUnit.getWeightIDForName((String)this.weightComboBox.getSelectedItem());
        String House2 = (String)this.factionComboBox.getSelectedItem();
        int cost = 0;
        cost = type == 0 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAMek")) : (type == 1 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAVeh")) : (type == 2 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForInf")) : (type == 3 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForProto")) : Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForBA")))));
        if (weight == 0) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForALight"));
        } else if (weight == 1) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAMed"));
        } else if (weight == 2) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAHeavy"));
        } else if (weight == 3) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAnAssault"));
        }
        if (House2.equals("Rare")) {
            cost = (int)((double)cost * Double.parseDouble(this.mwclient.getserverConfigs("RewardPointMultiplierForRare")));
        } else if (!House2.equals("Common") && !House2.equals(this.mwclient.getPlayer().getHouse())) {
            cost = (int)((double)cost * Double.parseDouble(this.mwclient.getserverConfigs("RewardPointNonHouseMultiplier")));
        }
        return cost;
    }
}

