/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class SignonDialog
implements ActionListener {
    private static final String usernameCommand = "user";
    private static final String passwordCommand = "password";
    private static final String okayCommand = "okay";
    private static final String cancelCommand = "cancel";
    private static final String windowName = "MekWars Login";
    private static final String ipaddressCommand = "ip address";
    private static final String hostportCommand = "port";
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private final JTextField ipaddressField = new JTextField();
    private final JTextField portField = new JTextField();
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private JDialog dialog;
    private JOptionPane pane;

    public SignonDialog(MWClient mwclient, boolean SwitchLogin) {
        JLabel usernameLabel = new JLabel("Username: ", 2);
        JLabel passwordLabel = new JLabel("Password (none if unregistered): ", 2);
        JLabel ipaddressLabel = new JLabel("IP Address: ", 2);
        JLabel portLabel = new JLabel("Port: ", 2);
        this.usernameField.setActionCommand(usernameCommand);
        this.passwordField.setActionCommand(passwordCommand);
        this.portField.setActionCommand(hostportCommand);
        this.ipaddressField.setActionCommand(ipaddressCommand);
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.usernameField.addActionListener(this);
        this.passwordField.addActionListener(this);
        this.ipaddressField.addActionListener(this);
        this.portField.addActionListener(this);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        usernameLabel.setToolTipText("Username for remote systems");
        passwordLabel.setToolTipText("Password for remote systems");
        ipaddressLabel.setToolTipText("IP address for remote systems");
        portLabel.setToolTipText("Port for remote systems");
        this.okayButton.setToolTipText("Use this username and password");
        this.cancelButton.setToolTipText("Quit MekWars");
        this.ipaddressField.setToolTipText("IP address for remote systems");
        JPanel textPanel = new JPanel(new GridLayout(4, 4), false);
        textPanel.add(usernameLabel);
        textPanel.add(this.usernameField);
        textPanel.add(passwordLabel);
        textPanel.add(this.passwordField);
        textPanel.add(ipaddressLabel);
        textPanel.add(this.ipaddressField);
        textPanel.add(portLabel);
        textPanel.add(this.portField);
        JPanel mainPanel = new JPanel(false);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(textPanel, -1, -1, null, options, this.usernameField);
        this.dialog = this.pane.createDialog(mainPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.usernameField.setText(mwclient.getConfig().getName());
        this.passwordField.setText(mwclient.getConfig().getPassword());
        this.ipaddressField.setText(mwclient.getConfig().getServerIP());
        this.portField.setText(mwclient.getConfig().getServerPort());
        this.dialog.setVisible(true);
        this.dialog.requestFocus();
        this.usernameField.requestFocus();
        if (this.pane.getValue() == this.okayButton) {
            mwclient.getConfig().setName(this.usernameField.getText());
            mwclient.setUsername(this.usernameField.getText());
            mwclient.setPassword(new String(this.passwordField.getPassword()));
            mwclient.getConfig().setServerPort(this.portField.getText());
            mwclient.getConfig().setServerIP(this.ipaddressField.getText());
        } else if (SwitchLogin) {
            this.dialog.dispose();
        } else {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(usernameCommand)) {
            this.passwordField.requestFocus();
        } else if (command.equals(passwordCommand)) {
            this.ipaddressField.requestFocus();
        } else if (command.equals(ipaddressCommand)) {
            this.portField.requestFocus();
        } else if (command.equals(hostportCommand)) {
            this.okayButton.doClick(200);
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(okayCommand)) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        }
    }
}

