/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.CMainFrame;
import client.gui.MechInfo;
import client.gui.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.AWT.MechView;
import megamek.client.ui.AWT.UnitFailureDialog;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.TechConstants;
import megamek.common.loaders.EntityLoadingException;

public class UnitViewerDialog
extends JFrame
implements ActionListener,
KeyListener,
ListSelectionListener,
Runnable,
WindowListener,
ItemListener {
    private static final int KEY_TIMEOUT = 1000;
    public static final int UNIT_VIEWER = 0;
    public static final int OMNI_VARIANT_SELECTOR = 1;
    public static final int UNIT_SELECTOR = 2;
    private String[] saSorts = new String[]{"Name", "Ref", "Weight", "BV"};
    private CMainFrame clientgui;
    private MechSummary[] mechsCurrent;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuffer m_sbSearch = new StringBuffer();
    private long m_nLastSearch = 0L;
    private JLabel labelType = new JLabel("Tech: ", 4);
    private JComboBox chType = new JComboBox();
    private JLabel labelUnitType = new JLabel("Type: ", 4);
    private JComboBox chUnitType = new JComboBox();
    private JLabel labelWeightClass = new JLabel("Class: ", 4);
    private JComboBox chWeightClass = new JComboBox();
    private JLabel labelSort = new JLabel("Sort: ", 4);
    private JComboBox chSort = new JComboBox();
    private JPanel pParams = new JPanel();
    DefaultListModel defaultModel = null;
    ListSelectionModel listSelectionModel = null;
    JList mechList = null;
    JScrollPane listScrollPane = null;
    JScrollPane leftScrollPane = null;
    JScrollPane rightScrollPane = null;
    private JButton bCancel = new JButton("Close");
    private JButton bSelect = new JButton("Select");
    private JTextArea mechViewLeft = null;
    private JTextArea mechViewRight = null;
    private JPanel pUpper = new JPanel();
    private JPanel pPreview = new JPanel();
    private MWClient mwclient = null;
    private String selectedUnit = null;
    private int viewerType = 0;
    private static final String SPACES = "                        ";

    public UnitViewerDialog(CMainFrame cl, UnitLoadingDialog uld, MWClient mwclient, int viewer) {
        super("Unit Viewer");
        this.viewerType = viewer;
        if (this.viewerType == 1) {
            this.setTitle("Omni Variant Selector");
        } else if (this.viewerType == 2) {
            this.setTitle("Unit Selector");
        }
        this.clientgui = cl;
        this.unitLoadingDialog = uld;
        this.mwclient = mwclient;
        this.mechViewLeft = new JTextArea(22, 29);
        this.mechViewRight = new JTextArea(22, 34);
        this.defaultModel = new DefaultListModel();
        this.mechList = new JList(this.defaultModel);
        this.listSelectionModel = this.mechList.getSelectionModel();
        this.mechList.setVisibleRowCount(22);
        this.listSelectionModel.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.mechList);
        this.leftScrollPane = new JScrollPane(this.mechViewLeft);
        this.rightScrollPane = new JScrollPane(this.mechViewRight);
        this.listScrollPane.setAlignmentX(0.0f);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.leftScrollPane.setAlignmentX(0.0f);
        this.leftScrollPane.setHorizontalScrollBarPolicy(31);
        this.rightScrollPane.setAlignmentX(0.0f);
        this.rightScrollPane.setHorizontalScrollBarPolicy(31);
        this.mechList.setSelectionMode(0);
        this.mechViewLeft.setFont(new Font("Monospaced", 0, 11));
        this.mechViewRight.setFont(new Font("Monospaced", 0, 11));
        this.mechList.setFont(new Font("Monospaced", 0, 11));
        for (int x = 0; x < this.saSorts.length; ++x) {
            this.chSort.addItem(this.saSorts[x]);
        }
        String sort = mwclient.getConfigParam("UNITVIEWERSORT");
        this.chSort.setSelectedItem(sort);
        this.pPreview = new MechInfo(mwclient);
        this.pPreview.setVisible(false);
        this.pPreview.setMinimumSize(new Dimension(86, 74));
        this.pPreview.setMaximumSize(new Dimension(86, 74));
        this.pUpper.setLayout(new FlowLayout(1));
        this.pUpper.add(this.pParams);
        this.pUpper.add(this.pPreview);
        this.pParams.setLayout(new GridLayout(4, 2));
        this.pParams.add(this.labelWeightClass);
        this.pParams.add(this.chWeightClass);
        this.pParams.add(this.labelType);
        this.pParams.add(this.chType);
        this.pParams.add(this.labelUnitType);
        this.pParams.add(this.chUnitType);
        this.pParams.add(this.labelSort);
        this.pParams.add(this.chSort);
        this.pParams.doLayout();
        this.populateJComboBoxs();
        JPanel textBoxSpring = new JPanel(new SpringLayout());
        textBoxSpring.add(this.listScrollPane);
        textBoxSpring.add(this.leftScrollPane);
        textBoxSpring.add(this.rightScrollPane);
        SpringLayoutHelper.setupSpringGrid(textBoxSpring, 1, 3);
        JPanel buttonHolder = new JPanel();
        if (this.viewerType != 0) {
            buttonHolder.add(this.bSelect);
        }
        buttonHolder.add(this.bCancel);
        JPanel springHolder = new JPanel(new SpringLayout());
        springHolder.add(this.pUpper);
        springHolder.add(textBoxSpring);
        springHolder.add(buttonHolder);
        SpringLayoutHelper.setupSpringGrid(springHolder, 3, 1);
        this.getContentPane().add(springHolder);
        this.clearMechPreview();
        this.setSize(785, 560);
        this.setResizable(false);
        this.chWeightClass.addItemListener(this);
        this.chType.addItemListener(this);
        this.chUnitType.addItemListener(this);
        this.chSort.addItemListener(this);
        this.mechList.addListSelectionListener(this);
        this.mechList.addKeyListener(this);
        this.bCancel.addActionListener(this);
        this.bSelect.addActionListener(this);
        this.addWindowListener(this);
    }

    public void run() {
        this.filterMechs();
        this.unitLoadingDialog.setVisible(false);
        Hashtable hFailedFiles = MechSummaryCache.getInstance().getFailedFiles();
        if (hFailedFiles != null && hFailedFiles.size() > 0) {
            new UnitFailureDialog((Frame)this.clientgui, hFailedFiles);
        }
        try {
            String previousIndex = this.mwclient.getConfigParam("UNITVIEWERUNIT");
            this.mechList.setSelectedValue(previousIndex, true);
        }
        catch (Exception e) {
            this.mechList.setSelectedIndex(-1);
        }
        this.pPreview.setVisible(true);
        this.setVisible(true);
        this.mechList.requestFocus();
    }

    private void populateJComboBoxs() {
        this.chWeightClass.addItem("Light");
        this.chWeightClass.addItem("Medium");
        this.chWeightClass.addItem("Heavy");
        this.chWeightClass.addItem("Assault");
        this.chWeightClass.addItem("All");
        String weight = this.mwclient.getConfigParam("UNITVIEWERWEIGHT");
        this.chWeightClass.setSelectedItem(weight);
        this.chType.addItem("IS L1");
        this.chType.addItem("IS L2");
        this.chType.addItem("IS L3");
        this.chType.addItem("IS All");
        this.chType.addItem("Clan");
        this.chType.addItem("Clan L2");
        this.chType.addItem("Clan All");
        this.chType.addItem("All");
        String tech = this.mwclient.getConfigParam("UNITVIEWERTECH");
        this.chType.setSelectedItem(tech);
        this.chUnitType.addItem("Mek");
        this.chUnitType.addItem("Tank");
        this.chUnitType.addItem("VTOL");
        this.chUnitType.addItem("Naval");
        this.chUnitType.addItem("Infantry");
        this.chUnitType.addItem("ProtoMek");
        this.chUnitType.addItem("All");
        String type = this.mwclient.getConfigParam("UNITVIEWERTYPE");
        this.chUnitType.setSelectedItem(type);
    }

    private void saveComboBoxSettings() {
        this.mwclient.getConfig().setParam("UNITVIEWERWEIGHT", (String)this.chWeightClass.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERTECH", (String)this.chType.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERTYPE", (String)this.chUnitType.getSelectedItem());
        this.mwclient.getConfig().setParam("UNITVIEWERSORT", (String)this.chSort.getSelectedItem());
        if (this.mechList.getSelectedValue() != null) {
            this.mwclient.getConfig().setParam("UNITVIEWERUNIT", this.mechList.getSelectedValue().toString());
        }
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
    }

    private void filterMechs() {
        int x;
        Vector<MechSummary> vMechs = new Vector<MechSummary>();
        String sClass = (String)this.chWeightClass.getSelectedItem();
        int nWeight = 0;
        if (sClass.equals("Light")) {
            nWeight = 0;
        } else if (sClass.equals("Medium")) {
            nWeight = 1;
        } else if (sClass.equals("Heavy")) {
            nWeight = 2;
        } else if (sClass.equals("Assault")) {
            nWeight = 3;
        }
        String sType = (String)this.chType.getSelectedItem();
        String sUnitType = (String)this.chUnitType.getSelectedItem();
        MechSummary[] mechs = MechSummaryCache.getInstance().getAllMechs();
        if (mechs == null) {
            System.err.println("No units to filter!");
            return;
        }
        try {
            for (x = 0; x < mechs.length; ++x) {
                if (mechs[x].getName().startsWith("Error") || !sClass.equals("All") && mechs[x].getWeightClass() != nWeight || !(sType.equals("All") || sType.equals("IS L1") && mechs[x].getType() == 0 || sType.equals("IS L2") && mechs[x].getType() == 1 || sType.equals("IS L3") && mechs[x].getType() == 5 || sType.equals("IS All") && (mechs[x].getType() == 0 || mechs[x].getType() == 1 || mechs[x].getType() == 5) || sType.equals("Clan") && mechs[x].getType() == 2 || sType.equals("Clan L3") && mechs[x].getType() == 6 || sType.equals("Clan All") && (mechs[x].getType() == 2 || mechs[x].getType() == 6)) && !TechConstants.T_NAMES[mechs[x].getType()].equals(sType) || !sUnitType.equals("All") && !mechs[x].getUnitType().equals(sUnitType)) continue;
                vMechs.addElement(mechs[x]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("mechs size: " + mechs.length + " x: " + x);
            System.err.println("sUnitType: " + sUnitType);
            System.err.println("sType: " + sType);
            System.err.println("sClass: " + sClass);
        }
        this.mechsCurrent = new MechSummary[vMechs.size()];
        vMechs.copyInto(this.mechsCurrent);
        this.sortMechs();
    }

    private void sortMechs() {
        Arrays.sort(this.mechsCurrent, new MechSummaryComparator(this.chSort.getSelectedIndex()));
        this.defaultModel.clear();
        for (int x = 0; x < this.mechsCurrent.length; ++x) {
            this.defaultModel.add(x, this.formatMech(this.mechsCurrent[x]));
        }
        this.repaint();
    }

    private void searchFor(String search) {
        for (int i = 0; i < this.mechsCurrent.length; ++i) {
            if (!this.mechsCurrent[i].getName().toLowerCase().startsWith(search)) continue;
            this.mechList.setSelectedIndex(i);
            this.mechList.ensureIndexIsVisible(i);
            break;
        }
    }

    public void setVisible(boolean show) {
        this.setLocationRelativeTo(null);
        super.setVisible(show);
        this.pack();
    }

    private String formatMech(MechSummary ms) {
        String result = "";
        result = this.makeLength(ms.getModel(), 12) + " " + this.makeLength(ms.getChassis(), 10) + " " + this.makeLength(Integer.toString(ms.getTons()), 3) + " " + this.makeLength(Integer.toString(ms.getBV()), 5);
        if (Boolean.valueOf(this.mwclient.getserverConfigs("UseCalculatedCosts")).booleanValue()) {
            result = result + this.makeLength(NumberFormat.getInstance().format(ms.getCost()), 10);
        }
        return result;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.saveComboBoxSettings();
            this.dispose();
        }
        if (ae.getSource() == this.bSelect) {
            this.saveComboBoxSettings();
            if (this.viewerType == 1) {
                try {
                    MechSummary ms = this.mechsCurrent[this.mechList.getSelectedIndex()];
                    String unit = ms.getName();
                    this.setVisible(false);
                    String moneyMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Money Mod for " + unit));
                    if (moneyMod == null || moneyMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String compMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Comp Mod for " + unit));
                    if (compMod == null || compMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String fluMod = JOptionPane.showInputDialog(this.clientgui, (Object)("Flu Mod for " + unit));
                    if (fluMod == null || fluMod.length() == 0) {
                        this.dispose();
                        return;
                    }
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c AddOmniVariantMod#" + unit + "#" + moneyMod + "$" + compMod + "$" + fluMod);
                    this.dispose();
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            } else if (this.viewerType == 2) {
                try {
                    MechSummary ms = this.mechsCurrent[this.mechList.getSelectedIndex()];
                    String unitFile = ms.getEntryName();
                    String unit = ms.getName();
                    this.setVisible(false);
                    String fluff = JOptionPane.showInputDialog(this.clientgui, (Object)("Fuff text for " + unit));
                    if (fluff == null || fluff.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String gunnery = JOptionPane.showInputDialog(this.clientgui, (Object)("Gunnery skill for " + unit));
                    if (gunnery == null || gunnery.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String piloting = JOptionPane.showInputDialog(this.clientgui, (Object)("Piloting Mod for " + unit));
                    if (piloting == null || piloting.length() == 0) {
                        this.dispose();
                        return;
                    }
                    String skills = null;
                    skills = JOptionPane.showInputDialog(this.clientgui, (Object)("Skills Mod for " + unit + " (comma delimited)"));
                    if (skills == null) {
                        this.dispose();
                        return;
                    }
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c createunit#" + unitFile + "#" + fluff + "#" + gunnery + "#" + piloting + "#" + skills);
                    this.dispose();
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            } else {
                this.dispose();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int selected = this.mechList.getSelectedIndex();
        if (selected == -1) {
            this.clearMechPreview();
            return;
        }
        MechSummary ms = this.mechsCurrent[selected];
        try {
            Entity entity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            this.previewMech(entity);
        }
        catch (EntityLoadingException ex) {
            System.out.println("Unable to load mech: " + ms.getSourceFile() + ": " + ms.getEntryName() + ": " + ex.getMessage());
            ex.printStackTrace();
            this.clearMechPreview();
            return;
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object currSelection = this.mechList.getSelectedValue();
        if (ie.getSource() == this.chSort) {
            this.sortMechs();
        } else if (ie.getSource() == this.chWeightClass || ie.getSource() == this.chType || ie.getSource() == this.chUnitType) {
            this.filterMechs();
        }
        this.mechList.setSelectedValue(currSelection, true);
    }

    void clearMechPreview() {
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        this.mechViewLeft.setText("");
        this.mechViewRight.setText("");
        this.previewMech(null);
    }

    void previewMech(Entity entity) {
        Entity currEntity = entity;
        boolean populateTextFields = true;
        if (entity == null) {
            try {
                currEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), "Error OMG-UR-FD.hmp").getEntity();
                populateTextFields = false;
            }
            catch (EntityLoadingException e) {
                // empty catch block
            }
        }
        MechView mechView = null;
        try {
            mechView = new MechView(currEntity);
        }
        catch (Exception e) {
            populateTextFields = false;
        }
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        if (populateTextFields && mechView != null) {
            this.mechViewLeft.setText(mechView.getMechReadoutBasic());
            this.mechViewRight.setText(mechView.getMechReadoutLoadout());
        } else {
            this.mechViewLeft.setText("No unit selected");
            this.mechViewRight.setText("No unit selected");
        }
        this.mechViewLeft.setCaretPosition(0);
        this.mechViewRight.setCaretPosition(0);
        try {
            ((MechInfo)this.pPreview).setUnit(currEntity);
            ((MechInfo)this.pPreview).setImageVisible(true);
            this.pPreview.paint(this.pPreview.getGraphics());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String makeLength(String s, int nLength) {
        if (s.length() == nLength) {
            return s;
        }
        if (s.length() > nLength) {
            return s.substring(0, nLength - 2) + "..";
        }
        return s + SPACES.substring(0, nLength - s.length());
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        long curTime;
        if (ke.getKeyCode() == 10) {
            ActionEvent event = new ActionEvent(this.bCancel, 1001, "");
            this.actionPerformed(event);
        }
        if ((curTime = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuffer();
        }
        this.m_nLastSearch = curTime;
        this.m_sbSearch.append(ke.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.saveComboBoxSettings();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

