/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.House;
import common.MutableSerializable;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Influences
implements MutableSerializable,
MMNetSerializable {
    private HashMap influences = new HashMap();

    public Influences(HashMap influences) {
        this.setInfluence(influences);
    }

    public Influences() {
    }

    public Influences(Influences influences) {
        this.setInfluence(new HashMap(influences.influences));
    }

    public int getInfluence(Integer factionID) {
        Integer i = (Integer)this.influences.get(factionID);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public int getInfluence(int factionID) {
        return this.getInfluence(new Integer(factionID));
    }

    public Integer getOwner() {
        try {
            TreeSet sset = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1 = ((House)o1).getId();
                    return i1 < (i2 = ((House)o2).getId()) ? -1 : (i1 == i2 ? 0 : 1);
                }
            });
            sset.addAll(this.getHouses());
            House[] factions = new House[sset.size()];
            int i = 0;
            Iterator it = sset.iterator();
            while (it.hasNext()) {
                factions[i++] = (House)it.next();
            }
            Arrays.sort(factions, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1 = Influences.this.getInfluence(new Integer(((House)o1).getId()));
                    return i1 > (i2 = Influences.this.getInfluence(new Integer(((House)o2).getId()))) ? -1 : (i1 == i2 ? 0 : 1);
                }
            });
            House faction = factions[0];
            if (faction == null) {
                return null;
            }
            if (factions.length <= 1) {
                return faction.getId();
            }
            House faction2 = factions[1];
            if (faction2 != null && this.getInfluence(new Integer(faction2.getId())) == this.getInfluence(new Integer(faction.getId()))) {
                return null;
            }
            return faction.getId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Error in Influenes.getOwner()");
            return null;
        }
    }

    public void setNeutral(List factions, House gainer) {
        this.influences = new HashMap();
        for (int i = 0; i < factions.size(); ++i) {
            House h = (House)factions.get(i);
            this.influences.put(new Integer(h.getId()), new Integer(100 / factions.size()));
        }
        if (100 % factions.size() != 0) {
            int bonus = 100 % factions.size();
            if (this.influences.containsKey(new Integer(gainer.getId()))) {
                this.influences.put(new Integer(gainer.getId()), new Integer((Integer)this.influences.get(gainer) + bonus));
            } else {
                this.influences.put(new Integer(gainer.getId()), new Integer(bonus));
            }
        }
    }

    public Set getHouses() {
        HashSet<House> result = new HashSet<House>();
        Iterator it = this.influences.keySet().iterator();
        while (it.hasNext()) {
            House faction = CampaignData.cd.getHouse((Integer)it.next());
            result.add(faction);
        }
        return result;
    }

    public int moveInfluence(House winner, House looser, int amount) {
        if (amount == 0) {
            return 0;
        }
        int oldwinnerinfluence = 0;
        int oldlooserinfluence = 0;
        oldwinnerinfluence = this.getInfluence(winner.getId());
        oldlooserinfluence = this.getInfluence(looser.getId());
        if (oldwinnerinfluence + amount >= 100) {
            amount = 100 - oldwinnerinfluence;
        }
        if (oldlooserinfluence < amount) {
            amount = oldlooserinfluence;
        }
        int winnerInfluence = oldwinnerinfluence + amount;
        int looserInfluence = oldlooserinfluence - amount;
        if (winnerInfluence == 0) {
            this.influences.remove(new Integer(winner.getId()));
        } else {
            this.influences.put(new Integer(winner.getId()), new Integer(winnerInfluence));
        }
        if (looserInfluence == 0) {
            this.influences.remove(new Integer(looser.getId()));
        } else {
            this.influences.put(new Integer(looser.getId()), new Integer(looserInfluence));
        }
        return amount;
    }

    public void setInfluence(HashMap influences) {
        this.influences = influences;
    }

    public boolean isHotZone() {
        int maxflu = 0;
        int secondmaxflu = 0;
        Iterator e = this.influences.values().iterator();
        while (e.hasNext()) {
            int flu = (Integer)e.next();
            if (maxflu < flu) {
                secondmaxflu = maxflu;
                maxflu = flu;
                continue;
            }
            if (secondmaxflu >= flu) continue;
            secondmaxflu = flu;
        }
        return maxflu - secondmaxflu < 20;
    }

    public void encodeMutableFields(BinWriter out, CampaignData dataProvider) throws IOException {
        out.println(this.influences.size(), "influences.size");
        for (Integer i : this.influences.keySet()) {
            out.println(i, "id");
            out.println((Integer)this.influences.get(i), "amount");
        }
    }

    public void decodeMutableFields(BinReader in, CampaignData dataProvider) throws IOException {
        int s = in.readInt("influences.size");
        this.influences.clear();
        for (int i = 0; i < s; ++i) {
            int factionID = in.readInt("id");
            int flu = in.readInt("amount");
            this.influences.put(new Integer(factionID), new Integer(flu));
        }
    }

    public void xmlOut(PrintWriter out) {
        Iterator inf = this.getHouses().iterator();
        out.println("\t<influence>");
        while (inf.hasNext()) {
            House h = (House)inf.next();
            out.println("\t\t<inf>");
            out.println("\t\t<faction>" + h.getName() + "</faction>");
            out.println("\t\t<amount>" + this.getInfluence(h.getId()) + "</amount>");
            out.println("\t\t</inf>");
        }
        out.println("\t</influence>");
    }

    public Influences difference(Influences infNew) {
        HashMap<House, Integer> diff = new HashMap<House, Integer>();
        Set other = infNew.getHouses();
        Set thisone = this.getHouses();
        for (House h : thisone) {
            int d = this.getInfluence(h.getId()) - infNew.getInfluence(h.getId());
            if (d == 0) continue;
            diff.put(h, new Integer(d));
        }
        for (House h : other) {
            if (thisone.contains(h)) continue;
            diff.put(h, new Integer(-infNew.getInfluence(h.getId())));
        }
        return new Influences(diff);
    }

    public void add(Influences infNew) {
        for (House h : this.getHouses()) {
            this.influences.put(new Integer(h.getId()), new Integer(this.getInfluence(h.getId()) + infNew.getInfluence(h.getId())));
        }
        for (House h : infNew.getHouses()) {
            if (this.getHouses().contains(h)) continue;
            this.influences.put(new Integer(h.getId()), new Integer(infNew.getInfluence(h.getId())));
        }
        for (House h : this.getHouses()) {
            if (this.getInfluence(h.getId()) != 0) continue;
            this.influences.remove(new Integer(h.getId()));
        }
    }

    public void binOut(BinWriter out) throws IOException {
        Object[] h = this.influences.keySet().toArray();
        Arrays.sort(h, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = (Integer)o1;
                return i1 == (i2 = ((Integer)o2).intValue()) ? 0 : (i1 < i2 ? -1 : 1);
            }
        });
        out.println(h.length, "influence.size");
        for (int i = 0; i < h.length; ++i) {
            out.println((Integer)h[i], "faction");
            out.println(this.getInfluence((int)((Integer)h[i])), "amount");
        }
    }

    public void binIn(BinReader in, Map factions) throws IOException {
        this.influences = new HashMap();
        int size = in.readInt("influence.size");
        for (int i = 0; i < size; ++i) {
            int hid = in.readInt("faction");
            int flu = in.readInt("amount");
            this.influences.put(new Integer(hid), new Integer(flu));
        }
    }

    public void binIn(BinReader in) throws IOException {
        this.influences = new HashMap();
        int size = in.readInt("influence.size");
        for (int i = 0; i < size; ++i) {
            int hid = in.readInt("faction");
            int flu = in.readInt("amount");
            this.influences.put(new Integer(hid), new Integer(flu));
        }
    }

    public void binOut(TreeWriter out) {
        Object[] h = this.influences.keySet().toArray();
        Arrays.sort(h, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = (Integer)o1;
                return i1 == (i2 = ((Integer)o2).intValue()) ? 0 : (i1 < i2 ? -1 : 1);
            }
        });
        out.write(h.length, "size");
        for (int i = 0; i < h.length; ++i) {
            out.write((Integer)h[i], "faction");
            out.write(this.getInfluence((int)((Integer)h[i])), "amount");
        }
    }

    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        this.influences = new HashMap();
        int size = in.readInt("size");
        for (int i = 0; i < size; ++i) {
            int hid = in.readInt("faction");
            int flu = in.readInt("amount");
            this.influences.put(new Integer(hid), new Integer(flu));
        }
    }
}

