/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AdvanceTerrain;
import common.CampaignData;
import common.Continent;
import common.House;
import common.Influences;
import common.MutableSerializable;
import common.PlanetEnvironments;
import common.UnitFactories;
import common.UnitFactory;
import common.dataFiles.PlanetData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.Position;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class Planet
implements Comparable,
MutableSerializable,
MMNetSerializable {
    private PlanetData myData = new PlanetData();

    public int getBaysProvided() {
        return this.getMyData().getBaysProvided();
    }

    public void setBaysProvided(int baysProvided) {
        this.getMyData().setBaysProvided(baysProvided);
    }

    public int getCompProduction() {
        return this.getMyData().getCompProduction();
    }

    public void setCompProduction(int compProduction) {
        this.getMyData().setCompProduction(compProduction);
    }

    public Integer getPlanetOwner() {
        Integer ownerid = this.getInfluence().getOwner();
        return ownerid;
    }

    public boolean isOwner(int factionid) {
        Integer ownerID = this.getPlanetOwner();
        if (ownerID == null) {
            return false;
        }
        return ownerID == factionid;
    }

    public boolean isConquerable() {
        return this.getMyData().isConquerable();
    }

    public void setConquerable(boolean conquerable) {
        this.getMyData().setConquerable(conquerable);
    }

    public String getDescription() {
        return this.getMyData().getDescription();
    }

    public void setDescription(String description) {
        this.getMyData().setDescription(description);
    }

    public int getId() {
        return this.getMyData().getId();
    }

    public String getName() {
        return this.getMyData().getName();
    }

    public String getNameAsLink() {
        String toReturn = "<a href=\"JUMPTOPLANET" + this.getMyData().getName() + "#\">" + this.getMyData().getName() + "</a>";
        return toReturn;
    }

    public void setName(String name) {
        this.getMyData().setName(name);
    }

    public Position getPosition() {
        return this.getMyData().getPosition();
    }

    public void setPosition(Position position) {
        this.getMyData().setPosition(position);
    }

    public UnitFactories getUnitFactories() {
        return this.getMyData().getUnitFactories();
    }

    public void setUnitFactories(UnitFactories unitFactories) {
        this.getMyData().setUnitFactories(unitFactories);
    }

    public PlanetEnvironments getEnvironments() {
        return this.getMyData().getEnvironments();
    }

    public void setEnvironments(PlanetEnvironments environments) {
        this.getMyData().setEnvironments(environments);
    }

    public Influences getInfluence() {
        return this.getMyData().getInfluence();
    }

    public void setInfluence(Influences influence) {
        this.getMyData().setInfluence(influence);
    }

    public Planet(int id, String name, Position position, Influences influence) {
        this.getMyData().setId(new Integer(id));
        this.getMyData().setName(name);
        this.getMyData().setPosition(position);
        this.getMyData().setInfluence(influence);
    }

    public Planet() {
    }

    public int compareTo(Object o) {
        Planet p = (Planet)o;
        return this.getId() < p.getId() ? -1 : (this.getId() == p.getId() ? 0 : 1);
    }

    public void encodeMutableFields(BinWriter out, CampaignData dataProvider) throws IOException {
        out.println(this.getId(), "id");
        this.getInfluence().encodeMutableFields(out, dataProvider);
        this.binOut(out);
    }

    public void decodeMutableFields(BinReader in, CampaignData dataProvider) throws IOException {
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().getInfluence().decodeMutableFields(in, dataProvider);
        this.binIn(in, dataProvider);
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.getMyData().getId(), "id");
        out.println(this.getMyData().getName(), "name");
        out.println(this.getMyData().getPosition().x, "x");
        out.println(this.getMyData().getPosition().y, "y");
        out.println(this.getMyData().getUnitFactories().size(), "unitFactories.size");
        Iterator i = this.getMyData().getUnitFactories().iterator();
        while (i.hasNext()) {
            ((UnitFactory)i.next()).binOut(out);
        }
        this.getMyData().getEnvironments().binOut(out);
        out.println(this.getMyData().getDescription(), "description");
        out.println(this.getMyData().getBaysProvided(), "baysProvided");
        out.println(this.getMyData().isConquerable(), "conquerable");
        out.println(this.getMyData().getCompProduction(), "compProduction");
        this.getMyData().getInfluence().binOut(out);
        out.println(this.getMyData().getMapSize().width, "x");
        out.println(this.getMyData().getMapSize().height, "y");
        out.println(this.getMyData().getBoardSize().width, "x");
        out.println(this.getMyData().getBoardSize().height, "y");
        out.println(this.getMyData().getTemp().width, "lowtemp");
        out.println(this.getMyData().getTemp().height, "hitemp");
        out.println(this.getMyData().getGravity(), "gravity");
        out.println(this.getMyData().isVacuum(), "vacuum");
        out.println(this.getMyData().getMinPlanetOwnerShip(), "minplanetownership");
        Enumeration at = this.getMyData().getAdvanceTerrain().elements();
        int i2 = 0;
        while (at.hasMoreElements()) {
            at.nextElement();
            ++i2;
        }
        out.println(i2, "AdvanceTerrain.size");
        at = this.getMyData().getAdvanceTerrain().elements();
        Enumeration atKey = this.getMyData().getAdvanceTerrain().keys();
        while (at.hasMoreElements()) {
            Integer id = (Integer)atKey.nextElement();
            out.println(id, "AdvanceTerrainId");
            AdvanceTerrain aTerrain = (AdvanceTerrain)at.nextElement();
            aTerrain.binOut(out);
        }
    }

    public Planet(BinReader in, Map factions, CampaignData data) throws IOException {
        int i;
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().setName(in.readLine("name"));
        this.getMyData().setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.getMyData().setUnitFactories(new UnitFactories());
        int size = in.readInt("unitFactories.size");
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getMyData().getUnitFactories().add(uf);
        }
        this.getMyData().setEnvironments(new PlanetEnvironments());
        this.getMyData().getEnvironments().binIn(in, data);
        this.getMyData().setDescription(in.readLine("description"));
        this.getMyData().setBaysProvided(in.readInt("baysProvided"));
        this.getMyData().setConquerable(in.readBoolean("conquerable"));
        this.getMyData().setCompProduction(in.readInt("compProduction"));
        this.getMyData().setInfluence(new Influences());
        this.getMyData().getInfluence().binIn(in, factions);
        this.getMyData().setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.getMyData().setGravity(in.readDouble("gravity"));
        this.getMyData().setVacuum(in.readBoolean("vacuum"));
        this.getMyData().setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        size = in.readInt("AdvanceTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvanceTerrain aTerrain = new AdvanceTerrain();
            int id = in.readInt("AdvanceTerrainId");
            aTerrain.binIn(in);
            this.getMyData().getAdvanceTerrain().put(new Integer(id), aTerrain);
        }
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        int i;
        this.myData = new PlanetData();
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().setName(in.readLine("name"));
        this.getMyData().setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.getMyData().setUnitFactories(new UnitFactories());
        int size = in.readInt("unitFactories.size");
        for (i = 0; i < size; ++i) {
            UnitFactory uf = new UnitFactory();
            uf.binIn(in);
            this.getMyData().getUnitFactories().add(uf);
        }
        this.getMyData().setEnvironments(new PlanetEnvironments());
        this.getMyData().getEnvironments().binIn(in, data);
        this.getMyData().setDescription(in.readLine("description"));
        this.getMyData().setBaysProvided(in.readInt("baysProvided"));
        this.getMyData().setConquerable(in.readBoolean("conquerable"));
        this.getMyData().setCompProduction(in.readInt("compProduction"));
        this.getMyData().setInfluence(new Influences());
        this.getMyData().getInfluence().binIn(in);
        this.getMyData().setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.getMyData().setGravity(in.readDouble("gravity"));
        this.getMyData().setVacuum(in.readBoolean("vacuum"));
        this.getMyData().setMinPlanetOwnerShip(in.readInt("minplanetownership"));
        size = in.readInt("AdvanceTerrain.size");
        for (i = 0; i < size; ++i) {
            AdvanceTerrain aTerrain = new AdvanceTerrain();
            int id = in.readInt("AdvanceTerrainId");
            System.err.println("AdvanceTerrainId " + id);
            aTerrain.binIn(in);
            this.getMyData().getAdvanceTerrain().put(new Integer(id), aTerrain);
        }
    }

    public StringBuffer getLongDescription(boolean client) {
        Iterator it;
        Influences influence = this.getInfluence();
        StringBuffer result = new StringBuffer("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A Warefaction providing " + this.getBaysProvided() + " bays exists on this planet.<br><br>");
        }
        if (this.getUnitFactories().size() > 0) {
            it = this.getUnitFactories().iterator();
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            while (it.hasNext()) {
                UnitFactory u = (UnitFactory)it.next();
                founder = u.getFounder();
                if (client) {
                    result.append("<img src=\"file:///" + new File(".").getAbsolutePath() + "/data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
                    continue;
                }
                result.append("<img src=\"./data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Planetary Conditions</b><br>");
        result.append("Atmosphere: ");
        if (this.isVacuum()) {
            result.append("None<br>");
        } else {
            result.append("Present<br>");
        }
        result.append("Gravity: " + this.getGravity() + "<br>");
        result.append("Average Low: " + this.getTemp().width + "<br>");
        result.append("Average High: " + this.getTemp().height + "<br>");
        result.append("<br><b>Terrain:</b><br>");
        it = this.getEnvironments().iterator();
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (!it.hasNext()) {
            result.append("nothing special");
        } else {
            while (it.hasNext()) {
                Continent pe = (Continent)it.next();
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                if (client) {
                    result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                } else {
                    result.append(pe.getEnvironment().toImageDescription());
                }
                String terrainName = pe.getEnvironment().getName();
                result.append(" " + terrainName);
                if (!it.hasNext()) continue;
                result.append("<br>");
            }
        }
        result.append("<br><br><b>Influence:</b><br>");
        it = this.getInfluence().getHouses().iterator();
        while (it.hasNext()) {
            House h = (House)it.next();
            result.append("<font color=" + h.getHouseColor() + ">" + h.getName() + "</font> (" + this.getInfluence().getInfluence(h.getId()) + ")");
            if (it.hasNext()) {
                result.append(", ");
                continue;
            }
            result.append("<br>");
        }
        return result;
    }

    public void setId(int id) {
        this.getMyData().setId(new Integer(id));
    }

    public void binOut(TreeWriter out) {
        out.write(this.getMyData().getId(), "id");
        out.write(this.getMyData().getName(), "name");
        out.write(this.getMyData().getPosition().x, "x");
        out.write(this.getMyData().getPosition().y, "y");
        out.write(this.getMyData().getUnitFactories(), "unitFactories");
        out.write(this.getMyData().getEnvironments(), "environments");
        out.write(this.getMyData().getDescription(), "description");
        out.write(this.getMyData().getBaysProvided(), "baysProvided");
        out.write(this.getMyData().isConquerable(), "conquerable");
        out.write(this.getMyData().getCompProduction(), "compProduction");
        out.write(this.getMyData().getInfluence(), "influence");
        out.write(this.getMyData().getMapSize().width, "x");
        out.write(this.getMyData().getMapSize().height, "y");
        out.write(this.getMyData().getBoardSize().width, "x");
        out.write(this.getMyData().getBoardSize().height, "y");
        out.write(this.getMyData().getTemp().width, "lowtemp");
        out.write(this.getMyData().getTemp().height, "hitemp");
        out.write(this.getMyData().getGravity(), "gravity");
        out.write(this.getMyData().isVacuum(), "vacuum");
        out.write(this.getMyData().getMinPlanetOwnerShip(), "minplanetownership");
    }

    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().setName(in.readString("name"));
        this.getMyData().setPosition(new Position(in.readDouble("x"), in.readDouble("y")));
        this.getMyData().setUnitFactories(new UnitFactories());
        in.readCollection(this.getMyData().getUnitFactories(), UnitFactory.class, dataProvider, "unitFactories");
        this.getMyData().setEnvironments(new PlanetEnvironments());
        in.readObject(this.getMyData().getEnvironments(), dataProvider, "environments");
        this.getMyData().setDescription(in.readString("description"));
        this.getMyData().setBaysProvided(in.readInt("baysProvided"));
        this.getMyData().setConquerable(in.readBoolean("conquerable"));
        this.getMyData().setCompProduction(in.readInt("compProduction"));
        this.getMyData().setInfluence(new Influences());
        in.readObject(this.getMyData().getInfluence(), dataProvider, "influence");
        this.getMyData().setMapSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setBoardSize(new Dimension(in.readInt("x"), in.readInt("y")));
        this.getMyData().setTemp(new Dimension(in.readInt("lowtemp"), in.readInt("hitemp")));
        this.getMyData().setGravity(in.readDouble("gravity"));
        this.getMyData().setVacuum(in.readBoolean("vacuum"));
        this.getMyData().setMinPlanetOwnerShip(in.readInt("minplanetownership"));
    }

    public StringBuffer getAdvanceDescription(int level) {
        Iterator it;
        Influences influence = this.getInfluence();
        StringBuffer result = new StringBuffer("Information for Planet: <b>");
        result.append(this.getName() + "</b><br><br>");
        result.append("<b>Location:</b> " + (int)this.getPosition().x + " x " + (int)this.getPosition().y + " y<br>" + Math.round(this.getPosition().distanceSq(0.0, 0.0)) + " Lightyears from the galaxy center <br><br>");
        result.append("<b>Industry:</b><br>");
        if (this.getCompProduction() > 0) {
            result.append("Heavy industry allows an export of " + this.getCompProduction() + " parts.<br>");
        }
        if (this.getBaysProvided() > 0) {
            result.append("A Warefaction providing " + this.getBaysProvided() + " bays exists on this planet.<br><br>");
        }
        if (this.getUnitFactories().size() > 0) {
            it = this.getUnitFactories().iterator();
            String founder = "";
            if (this.getUnitFactories().size() == 1) {
                result.append("<br><b>Factory:</b><br>");
            } else {
                result.append("<br><b>Factories:</b><br>");
            }
            while (it.hasNext()) {
                UnitFactory u = (UnitFactory)it.next();
                founder = u.getFounder();
                result.append("<img src=\"file:///" + new File(".").getAbsolutePath() + "/data/images/open" + founder + ".gif\">" + u.getSize() + " " + u.getFullTypeString() + u.getName() + " built by " + founder + "<br>");
            }
        }
        result.append("<br><b>Terrain:</b><br>");
        it = this.getEnvironments().iterator();
        int maxProbab = this.getEnvironments().getTotalEnivronmentPropabilities();
        if (!it.hasNext()) {
            result.append("nothing special");
        } else {
            while (it.hasNext()) {
                Continent pe = (Continent)it.next();
                int curProb = pe.getSize() * 100 / maxProbab;
                if (curProb < 10) {
                    result.append("0");
                }
                result.append(curProb + "% ");
                result.append(pe.getEnvironment().toImageAbsolutePathDescription());
                AdvanceTerrain aTerrain = new AdvanceTerrain();
                aTerrain = (AdvanceTerrain)this.getAdvanceTerrain().get(new Integer(pe.getEnvironment().getId()));
                result.append(" " + aTerrain.getDisplayName());
                result.append("<br>Atmosphere: ");
                if (aTerrain.isVacuum()) {
                    result.append("None<br>");
                } else {
                    result.append("Present<br>");
                }
                result.append("Gravity: " + aTerrain.getGravity());
                result.append("<br>Average Low: " + aTerrain.getLowTemp());
                result.append("<br>Average High: " + aTerrain.getHighTemp());
                if (level >= 100) {
                    result.append("<br>Night Chance: " + aTerrain.getNightChance());
                    result.append("<br>Night Temp Mod: " + aTerrain.getNightTempMod());
                    if (aTerrain.isStaticMap()) {
                        result.append("<br>Map Name: " + aTerrain.getStaticMapName());
                        result.append("<br>Map Size(XxY): " + aTerrain.getXSize() + " x " + aTerrain.getYSize());
                        result.append("<br>Board Size(XxY): " + aTerrain.getXBoardSize() + " x " + aTerrain.getYBoardSize());
                    }
                }
                if (!it.hasNext()) continue;
                result.append("<br>");
            }
        }
        result.append("<br><br><b>Influence:</b><br>");
        it = this.getInfluence().getHouses().iterator();
        while (it.hasNext()) {
            House h = (House)it.next();
            result.append("<font color=" + h.getHouseColor() + ">" + h.getName() + "</font> (" + this.getInfluence().getInfluence(h.getId()) + ")");
            if (it.hasNext()) {
                result.append(", ");
                continue;
            }
            result.append("<br>");
        }
        return result;
    }

    public int getFactoryCount() {
        int count = 0;
        Iterator i = this.getUnitFactories().iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    public Dimension getMapSize() {
        return this.getMyData().getMapSize();
    }

    public Dimension getBoardSize() {
        return this.getMyData().getBoardSize();
    }

    public void setMapSize(Dimension map) {
        this.getMyData().setMapSize(map);
    }

    public void setBoardSize(Dimension board) {
        this.getMyData().setBoardSize(board);
    }

    public Dimension getTemp() {
        return this.getMyData().getTemp();
    }

    public void setTemp(Dimension temp) {
        this.getMyData().setTemp(temp);
    }

    public double getGravity() {
        return this.getMyData().getGravity();
    }

    public void setGravity(double grav) {
        this.getMyData().setGravity(grav);
    }

    public boolean isVacuum() {
        return this.getMyData().isVacuum();
    }

    public void setVacuum(boolean vac) {
        this.getMyData().setVacuum(vac);
    }

    public int getNightChance() {
        return this.getMyData().getNightChance();
    }

    public void setNightChance(int chance) {
        this.getMyData().setNightChance(chance);
    }

    public int getNightTempMod() {
        return this.getMyData().getNightTempMod();
    }

    public void setNightTempMod(int mod) {
        this.getMyData().setNightTempMod(mod);
    }

    public Hashtable getAdvanceTerrain() {
        return this.getMyData().getAdvanceTerrain();
    }

    public void setAdvanceTerrain(Hashtable terrain) {
        this.getMyData().setAdvanceTerrain(terrain);
    }

    public int getMinPlanetOwnerShip() {
        return this.getMyData().getMinPlanetOwnerShip();
    }

    private PlanetData getMyData() {
        return this.myData;
    }
}

