/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.Continent;
import common.PlanetEnvironment;
import common.TerrainProvider;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class PlanetEnvironments
implements MMNetSerializable {
    public static transient TerrainProvider data;
    private ArrayList continents = new ArrayList();

    public Iterator iterator() {
        return this.continents.iterator();
    }

    public int size() {
        return this.continents.size();
    }

    public Continent[] toArray() {
        Continent[] ret = new Continent[this.size()];
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret[i++] = (Continent)it.next();
        }
        return ret;
    }

    public synchronized void add(Continent newPE) {
        this.continents.add(newPE);
    }

    public Continent getBiggestEnvironment() {
        Continent result = new Continent(0, new PlanetEnvironment());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Continent p = (Continent)it.next();
            if (p.getSize() <= result.getSize()) continue;
            result = p;
        }
        return result;
    }

    public int getTotalEnivronmentPropabilities() {
        int result = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            result += ((Continent)it.next()).getSize();
        }
        return result;
    }

    public PlanetEnvironment getRandomEnvironment(Random r) {
        int probs = this.getTotalEnivronmentPropabilities();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Continent pe = (Continent)it.next();
            if (r.nextInt(probs) < pe.getSize()) {
                return pe.getEnvironment();
            }
            probs -= pe.getSize();
        }
        return new PlanetEnvironment();
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.size(), "terrain.size");
        for (Continent cont : this.continents) {
            out.println(cont.getSize(), "size");
            out.println(cont.getEnvironment().getId(), "id");
        }
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        int size = in.readInt("terrain.size");
        for (int i = 0; i < size; ++i) {
            this.add(new Continent(in.readInt("size"), data.getTerrain(in.readInt("id"))));
        }
    }

    public void binOut(TreeWriter out) {
        out.write(this.size(), "terrain.size");
        for (Continent cont : this.continents) {
            out.write(cont.getSize(), "size");
            out.write(cont.getEnvironment().getId(), "id");
        }
    }

    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        int size = in.readInt("terrain.size");
        for (int i = 0; i < size; ++i) {
            this.add(new Continent(in.readInt("size"), dataProvider.getTerrain(in.readInt("id"))));
        }
    }
}

