/*
 * Decompiled with CFR 0.152.
 */
package common.campaign.pilot;

import common.CampaignData;
import common.MegaMekPilotOption;
import common.campaign.pilot.skills.PilotSkill;
import common.campaign.pilot.skills.PilotSkills;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class Pilot
implements MMNetSerializable {
    private int gunnery = 4;
    private int piloting = 5;
    private String name = "John Doe";
    private int experience = 0;
    private int hits = 0;
    private LinkedList megamekOptions = new LinkedList();
    private String wsSkillWeapon = "Default";
    private String currentFaction = "none";
    private String traitName = "none";
    private PilotSkills skills = new PilotSkills();
    private double bvMod = 0.0;
    private int bayModifier = 0;
    private int kills = 0;
    private int unitType = 0;
    private String weapon = "Default";

    public Pilot(String name, int gunnery, int piloting) {
        this.setName(name);
        this.setGunnery(gunnery);
        this.setPiloting(piloting);
    }

    public Pilot() {
    }

    public int getGunnery() {
        return this.gunnery;
    }

    public void setGunnery(int gunnery) {
        this.gunnery = gunnery;
    }

    public String getSkillString(boolean abbreviated) {
        String result = "";
        Iterator i = this.getSkills().getSkillIterator();
        if (!i.hasNext()) {
            return " ";
        }
        while (i.hasNext()) {
            PilotSkill skill = (PilotSkill)i.next();
            String lvl = "";
            if (skill.getLevel() != -1) {
                lvl = lvl + skill.getLevel();
            }
            if (abbreviated) {
                result = result + skill.getAbbreviation() + lvl;
            } else if (skill.getName().equalsIgnoreCase("Weapon Specialist")) {
                result = result + skill.getName() + " " + this.getWeapon();
            } else if (skill.getName().equalsIgnoreCase("Trait")) {
                StringTokenizer traitName = new StringTokenizer(this.getTraitName(), "*");
                result = result + traitName.nextToken();
            } else {
                result = result + skill.getName() + " " + lvl;
            }
            if (!i.hasNext()) continue;
            if (abbreviated) {
                result = result + ",";
                continue;
            }
            result = result + ", ";
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPiloting() {
        return this.piloting;
    }

    public void setPiloting(int piloting) {
        this.piloting = piloting;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public void addMegamekOption(MegaMekPilotOption op) {
        this.megamekOptions.add(op);
    }

    public double getBVMod() {
        return this.bvMod;
    }

    public void setBvMod(double bvMod) {
        this.bvMod = bvMod;
    }

    public int getBayModifier() {
        return this.bayModifier;
    }

    public void setBayModifier(int bayModifier) {
        this.bayModifier = bayModifier;
    }

    public PilotSkills getSkills() {
        return this.skills;
    }

    public LinkedList getMegamekOptions() {
        return this.megamekOptions;
    }

    public void binOut(TreeWriter out) {
        out.write(this.getName(), "name");
        out.write(this.getGunnery(), "gunnery");
        out.write(this.getPiloting(), "piloting");
        out.write(this.getExperience(), "experience");
        out.write(this.getHits(), "hits");
        out.write(this.megamekOptions, "megamekoptions");
    }

    public void binIn(TreeReader in, CampaignData data) {
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kill) {
        this.kills = kill;
    }

    public void addKill(int kill) {
        this.setKills(this.getKills() + kill);
    }

    public void setWeapon(String weapon) {
        this.weapon = weapon;
    }

    public String getWeapon() {
        return this.weapon;
    }

    public void setUnitType(int type) {
        this.unitType = type;
    }

    public int getUnitType() {
        return this.unitType;
    }

    public String getCurrentFaction() {
        return this.currentFaction;
    }

    public void setCurrentFaction(String faction) {
        this.currentFaction = faction;
    }

    public String getTraitName() {
        return this.traitName;
    }

    public void setTraitName(String Trait) {
        this.traitName = Trait;
    }
}

