/*
 * Decompiled with CFR 0.152.
 */
package common.persistence;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;

public class DatReader
implements TreeReader {
    private BufferedReader in;

    public DatReader(String filename) throws FileNotFoundException {
        this.in = new BufferedReader(new FileReader(filename));
    }

    private Line readLine() throws IOException {
        int j;
        Line line = new Line();
        String l = this.in.readLine();
        int i = 0;
        while (l.charAt(i) == ' ') {
            ++i;
        }
        l = l.substring(i);
        i = 0;
        while (l.charAt(i) != '=') {
            ++i;
        }
        line.name = l.substring(0, i);
        line.value = l.substring(i + 1);
        if (l.endsWith("]={") && (j = line.name.indexOf(91)) != -1) {
            line.size = Integer.parseInt(line.name.substring(j + 1, line.name.length() - 1));
            line.name = line.name.substring(0, j);
        }
        return line;
    }

    private String check(Line line, String name) {
        name.replace('=', '-');
        if (!line.name.equals(name)) {
            throw new RuntimeException("Data structure mismatch");
        }
        return line.value;
    }

    public int readInt(String name) throws IOException {
        return Integer.parseInt(this.check(this.readLine(), name));
    }

    public double readDouble(String name) throws IOException {
        return Double.parseDouble(this.check(this.readLine(), name));
    }

    public boolean readBoolean(String name) throws IOException {
        return Boolean.getBoolean(this.check(this.readLine(), name));
    }

    public String readString(String name) throws IOException {
        return this.check(this.readLine(), name);
    }

    public void readObject(MMNetSerializable obj, CampaignData dataProvider, String name) throws IOException {
        this.startDataBlock(name);
        obj.binIn(this, dataProvider);
        this.endDataBlock(name);
    }

    public void readCollection(Collection col, Class cl, CampaignData dataProvider, String name) throws IOException {
        name.replace('[', '(');
        name.replace(']', ')');
        Line l = this.readLine();
        this.check(l, name);
        for (int i = 0; i < l.size; ++i) {
            try {
                MMNetSerializable obj = (MMNetSerializable)cl.newInstance();
                this.readObject(obj, dataProvider, String.valueOf(i));
                col.add(obj);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.endDataBlock(name);
    }

    public void startDataBlock(String name) throws IOException {
        this.check(this.readLine(), "{");
    }

    public void endDataBlock(String name) throws IOException {
        Line l = new Line();
        l.name = name;
        l.value = this.in.readLine();
        this.check(l, name);
    }

    public void close() throws IOException {
    }

    private static final class Line {
        public String name;
        public String value;
        public int size;

        private Line() {
        }
    }
}

