/*
 * Decompiled with CFR 0.152.
 */
package common.persistence;

import common.persistence.MMNetSerializable;
import common.persistence.TreeWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;

public class DatWriter
implements TreeWriter {
    PrintWriter out;
    String indent = "";

    public DatWriter(String filename) throws IOException {
        this.out = new PrintWriter(new FileWriter(filename));
    }

    private String ensureString(String name) {
        name.replace('=', '-');
        return name;
    }

    public void write(int v, String name) {
        this.out.println(this.indent + this.ensureString(name) + "=" + v);
    }

    public void write(boolean v, String name) {
        this.out.println(this.indent + this.ensureString(name) + "=" + v);
    }

    public void write(double v, String name) {
        this.out.println(this.indent + this.ensureString(name) + "=" + v);
    }

    public void write(String v, String name) {
        this.out.println(this.indent + this.ensureString(name) + "=" + v);
    }

    public void write(MMNetSerializable v, String name) {
        this.startDataBlock(name);
        v.binOut(this);
        this.endDataBlock(name);
    }

    public void write(Collection v, String name) {
        name.replace('[', '(');
        name.replace(']', ')');
        name = this.ensureString(name) + "[" + v.size() + "]";
        this.startDataBlock(name);
        int i = 0;
        Iterator it = v.iterator();
        while (it.hasNext()) {
            this.write((MMNetSerializable)it.next(), String.valueOf(i++));
        }
        this.endDataBlock(name);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public void startDataBlock(String name) {
        this.out.println(this.indent + this.ensureString(name) + "={");
        this.indent = this.indent + "  ";
    }

    public void endDataBlock(String name) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.out.println(this.indent + "}");
    }
}

