/*
 * Decompiled with CFR 0.152.
 */
package common.persistence;

import common.persistence.MMNetSerializable;
import common.persistence.TreeWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;

public class XMLWriter
implements TreeWriter {
    private PrintWriter out;
    private String indent = "";

    private void doWrite(String v, String name) {
        if (v.length() == 0) {
            this.out.println(this.indent + "<" + name + " />");
        } else {
            this.out.println(this.indent + "<" + name + ">" + v + "</" + name + ">");
        }
    }

    public XMLWriter(PrintWriter out) {
        this.out = out;
    }

    public void write(int v, String name) {
        this.doWrite(String.valueOf(v), name);
    }

    public void write(boolean v, String name) {
        this.doWrite(String.valueOf(v), name);
    }

    public void write(double v, String name) {
        this.doWrite(String.valueOf(v), name);
    }

    public void write(String v, String name) {
        this.doWrite(v, name);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public void startDataBlock(String name) {
        this.out.println("<" + name + ">");
        this.indent = this.indent + "  ";
    }

    public void endDataBlock(String name) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.out.println("</" + name + ">");
    }

    public void write(MMNetSerializable v, String name) {
        this.startDataBlock(name);
        v.binOut(this);
        this.endDataBlock(name);
    }

    public void write(Collection v, String name) {
        this.out.println("<" + name + " size=" + v.size() + ">");
        this.indent = this.indent + "  ";
        Iterator it = v.iterator();
        while (it.hasNext()) {
            this.write((MMNetSerializable)it.next(), name);
        }
        this.endDataBlock(name);
    }
}

