/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import java.util.Enumeration;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;

public class UnitUtils {
    public static int STANDARD_ENGINE = 0;
    public static int IS_LIGHT_ENGINE = 1;
    public static int IS_XL_ENGINE = 2;
    public static int IS_XXL_ENGINE = 3;
    public static int CLAN_XL_ENGINE = 4;
    public static int CLAN_XXL_ENGINE = 5;
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    public static final int LOC_CTR = 8;
    public static final int LOC_RTR = 9;
    public static final int LOC_LTR = 10;

    public static String unitBattleDamage(Entity unit) {
        return UnitUtils.unitBattleDamage(unit, true);
    }

    public static String unitBattleDamage(Entity unit, boolean sendAmmo) {
        if (unit instanceof Tank || unit instanceof Infantry || unit instanceof Protomech) {
            return "%%-%%-%%";
        }
        StringBuffer result = new StringBuffer();
        String delimiter = "-";
        String delimiter2 = "%";
        boolean hasData = false;
        try {
            int loc;
            for (loc = 0; loc <= 7; ++loc) {
                if (unit.getArmor(loc) == unit.getOArmor(loc)) continue;
                hasData = true;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getArmor(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(loc));
                }
                result.append(delimiter2);
            }
            if (unit.getArmor(1, true) != unit.getOArmor(1, true)) {
                result.append(8);
                result.append(delimiter2);
                if (unit.getArmor(1, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(1, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (unit.getArmor(3, true) != unit.getOArmor(3, true)) {
                result.append(10);
                result.append(delimiter2);
                if (unit.getArmor(3, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(3, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (unit.getArmor(2, true) != unit.getOArmor(2, true)) {
                result.append(9);
                result.append(delimiter2);
                if (unit.getArmor(2, true) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getArmor(2, true));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (loc = 0; loc <= 7; ++loc) {
                if (unit.getInternal(loc) == unit.getOInternal(loc)) continue;
                result.append(loc);
                result.append(delimiter2);
                if (unit.getInternal(loc) < 0) {
                    result.append(0);
                } else {
                    result.append(unit.getInternal(loc));
                }
                result.append(delimiter2);
                hasData = true;
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            for (int x = 0; x < unit.locations(); ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null) continue;
                    if (cs.isDamaged()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("*");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (cs.isBreached()) {
                        result.append(x);
                        result.append(delimiter2);
                        result.append(y);
                        result.append(delimiter2);
                        result.append("X");
                        result.append(delimiter2);
                        hasData = true;
                        continue;
                    }
                    if (!cs.isRepairing()) continue;
                    result.append(x);
                    result.append(delimiter2);
                    result.append(y);
                    result.append(delimiter2);
                    result.append("!");
                    result.append(delimiter2);
                    hasData = true;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
            hasData = false;
            if (sendAmmo) {
                int location = 0;
                Enumeration en = unit.getAmmo();
                while (en.hasMoreElements()) {
                    Mounted weap = (Mounted)en.nextElement();
                    if (weap.isDestroyed()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(0);
                    } else if (weap.getShotsLeft() != ((AmmoType)weap.getType()).getShots()) {
                        hasData = true;
                        result.append(location);
                        result.append(delimiter2);
                        result.append(weap.getShotsLeft());
                    }
                    ++location;
                }
            }
            if (!hasData) {
                result.append(delimiter2);
                result.append(delimiter2);
            }
            result.append(delimiter);
        }
        catch (Exception ex) {
            System.err.println("Entity: " + unit.getShortNameRaw());
            ex.printStackTrace();
            return "%%-%%-%%";
        }
        return result.toString();
    }

    public static void applyBattleDamage(Entity unit, String report) {
        int armor;
        int location;
        StringTokenizer entry = new StringTokenizer(report, "-");
        StringTokenizer externalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer internalArmor = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer crits = new StringTokenizer(entry.nextToken(), "%");
        StringTokenizer ammo = null;
        if (entry.hasMoreTokens()) {
            ammo = new StringTokenizer(entry.nextToken(), "%");
        }
        while (externalArmor.hasMoreTokens()) {
            location = Integer.parseInt(externalArmor.nextToken());
            armor = Integer.parseInt(externalArmor.nextToken());
            if (location == 8) {
                unit.setArmor(armor, 1, true);
                continue;
            }
            if (location == 10) {
                unit.setArmor(armor, 3, true);
                continue;
            }
            if (location == 9) {
                unit.setArmor(armor, 2, true);
                continue;
            }
            unit.setArmor(armor, location);
        }
        while (internalArmor.hasMoreTokens()) {
            location = Integer.parseInt(internalArmor.nextToken());
            armor = Integer.parseInt(internalArmor.nextToken());
            unit.setInternal(armor, location);
        }
        while (crits.hasMoreTokens()) {
            Mounted mounted;
            location = Integer.parseInt(crits.nextToken());
            int slot = Integer.parseInt(crits.nextToken());
            String damageType = crits.nextToken();
            CriticalSlot critSlot = unit.getCritical(location, slot);
            if (damageType.equals("*")) {
                critSlot.setDestroyed(true);
                if (critSlot.getType() == 1) {
                    mounted = unit.getEquipment(critSlot.getIndex());
                    mounted.setDestroyed(true);
                    if (mounted.getShotsLeft() > 0) {
                        mounted.setShotsLeft(0);
                    }
                }
            } else if (damageType.equals("!")) {
                critSlot.setRepairing(true);
            } else {
                critSlot.setBreached(true);
                if (critSlot.getType() == 1) {
                    mounted = unit.getEquipment(critSlot.getIndex());
                    mounted.setBreached(true);
                }
            }
            unit.setCritical(location, slot, critSlot);
        }
        if (ammo != null && ammo.hasMoreTokens()) {
            int locationCount = 0;
            Enumeration munitions = unit.getAmmo();
            if (munitions.hasMoreElements()) {
                Mounted weapon = (Mounted)munitions.nextElement();
                while (ammo.hasMoreTokens()) {
                    int location2 = Integer.parseInt(ammo.nextToken());
                    int ammoLeft = Integer.parseInt(ammo.nextToken());
                    while (location2 != locationCount) {
                        weapon = (Mounted)munitions.nextElement();
                        ++locationCount;
                    }
                    weapon.setShotsLeft(ammoLeft);
                }
            }
        }
    }

    public static boolean canStartUp(Entity unit) {
        int engineHits = 0;
        if (!(unit instanceof Mech)) {
            return true;
        }
        engineHits = UnitUtils.getNumberOfDamagedEngineCrits(unit);
        return engineHits < 3;
    }

    public static boolean hasArmorDamage(Entity unit) {
        return unit.getTotalArmor() != unit.getTotalOArmor() || unit.getTotalInternal() != unit.getTotalOInternal();
    }

    public static boolean hasCriticalDamage(Entity unit) {
        if (unit instanceof Mech) {
            for (int x = 0; x < unit.locations(); ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (cs == null || !cs.isDamaged() && !cs.isBreached()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getNumberOfEngineCrits(Entity unit) {
        int engines = 0;
        if (unit instanceof Mech) {
            for (int x = 1; x < 3; ++x) {
                for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                    CriticalSlot cs = unit.getCritical(x, y);
                    if (!UnitUtils.isEngineCrit(cs)) continue;
                    ++engines;
                }
            }
        } else {
            engines = 6;
        }
        return engines;
    }

    public static int getEngineType(Entity unit) {
        int techLevel = unit.getTechLevel();
        int engineNumber = UnitUtils.getNumberOfEngineCrits(unit);
        if (unit instanceof Mech) {
            if (techLevel == 2 || techLevel == 6) {
                if (engineNumber == 12) {
                    return CLAN_XXL_ENGINE;
                }
                if (engineNumber == 10) {
                    return CLAN_XL_ENGINE;
                }
            } else {
                if (engineNumber == 18) {
                    return IS_XXL_ENGINE;
                }
                if (engineNumber == 12) {
                    return IS_XL_ENGINE;
                }
                if (engineNumber == 10) {
                    return IS_LIGHT_ENGINE;
                }
            }
        }
        return STANDARD_ENGINE;
    }

    public static int getNumberOfDamagedEngineCrits(Entity unit) {
        int engineHits = 0;
        for (int x = 1; x <= 3; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs) || !cs.isBreached() && !cs.isDamaged()) continue;
                ++engineHits;
            }
        }
        return engineHits;
    }

    public static void repairEquipment(Mounted eq, Entity unit, int location) {
        if (eq.isSplit()) {
            UnitUtils.repairSplitEquipment(eq, unit);
            return;
        }
        for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
            Mounted mounted;
            CriticalSlot crit = unit.getCritical(location, slot);
            if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex()))) continue;
            UnitUtils.fixCriticalSlot(crit, unit);
            unit.setCritical(location, slot, crit);
        }
    }

    public static void repairDamagedEngine(Entity unit) {
        for (int x = 0; x < unit.locations(); ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = unit.getCritical(x, y);
                if (!UnitUtils.isEngineCrit(cs)) continue;
                UnitUtils.fixCriticalSlot(cs, unit);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void repairSplitEquipment(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null) {
                    return;
                }
                if (cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex()))) continue;
                UnitUtils.fixCriticalSlot(cs, unit);
                unit.setCritical(x, y, cs);
            }
        }
    }

    public static void fixCriticalSlot(CriticalSlot cs, Entity unit) {
        if (cs.getType() == 1) {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            mounted.setBreached(false);
            mounted.setDestroyed(false);
            mounted.setHit(false);
        }
        cs.setBreached(false);
        cs.setDestroyed(false);
        cs.setHit(false);
    }

    public static boolean isEngineCrit(CriticalSlot cs) {
        return cs != null && cs.getType() == 0 && cs.getIndex() == 3;
    }

    public static int getNumberOfCrits(Entity unit, CriticalSlot cs) {
        int numberOfCrits = 1;
        if (UnitUtils.isEngineCrit(cs)) {
            numberOfCrits = UnitUtils.getNumberOfEngineCrits(unit);
        } else if (cs.getType() == 1) {
            Mounted mounted = unit.getEquipment(cs.getIndex());
            numberOfCrits = mounted.getType().getCriticals(unit);
        }
        if (numberOfCrits <= 0) {
            numberOfCrits = 1;
        }
        return numberOfCrits;
    }

    public static void setRepairing(Entity unit, CriticalSlot cs) {
        if (cs.getType() == 0) {
            cs.setRepairing(true);
        } else {
            Mounted eq = unit.getEquipment(cs.getIndex());
            int location = eq.getLocation();
            if (eq.isSplit()) {
                UnitUtils.setRepairingSplit(eq, unit);
                return;
            }
            for (int slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                Mounted mounted;
                CriticalSlot crit = unit.getCritical(location, slot);
                if (crit == null || crit.getType() != 1 || !eq.equals(mounted = unit.getEquipment(crit.getIndex()))) continue;
                crit.setRepairing(true);
            }
        }
    }

    public static void setRepairingSplit(Mounted eq, Entity unit) {
        if (!(unit instanceof Mech)) {
            return;
        }
        for (int x = 1; x <= 5; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                Mounted mounted;
                CriticalSlot cs = unit.getCritical(x, y);
                if (cs == null) {
                    return;
                }
                if (cs.getType() != 1 || !eq.equals(mounted = unit.getEquipment(cs.getIndex()))) continue;
                cs.setRepairing(true);
            }
        }
    }
}

