/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import common.MMClientInfo;
import common.MMGame;
import common.comm.Command;
import common.comm.ServerCommand;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import server.SMWLogger;
import server.ServerWrapper;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.comm.CampaignCommand;
import server.campaign.comm.HouseStatus;
import server.campaign.comm.PlayerStatus;
import server.util.IpCountry;
import server.util.MMNetPasswd;
import server.util.MMNetPasswdRecord;
import server.util.TrackerThread;

public class MMServ {
    private ServerWrapper myCommunicator;
    public static String VERSION = "";
    public static MMServ mmserv;
    private Hashtable games = new Hashtable();
    private Hashtable users = new Hashtable();
    private Hashtable ips = new Hashtable();
    private Hashtable<InetAddress, Long> banips = new Hashtable();
    private Hashtable<String, String> banaccounts = new Hashtable();
    private Hashtable iphelp = new Hashtable();
    private Properties config = new Properties();
    private Hashtable mails = new Hashtable();
    private Hashtable iplog = new Hashtable();
    private Hashtable versionsubids = new Hashtable();
    private Date mytime = new Date(System.currentTimeMillis());
    private IpCountry ipToCountry = new IpCountry("./data/iplist.txt", "./data/countrynames.txt");
    private long checkdate = 0L;
    private String log = "";
    private CampaignMain campaign;
    private Command.Table myCommands = new Command.Table();
    private Vector ignoreList = new Vector();
    public static final SMWLogger mmlog;
    private String serverVersion = "0.1.1.0";
    private boolean debug = true;

    public static void main(String[] argv) {
        new MMServ(argv);
    }

    MMServ(String[] argv) {
        PrintStream ps;
        VERSION = this.getServerVersion();
        String logFileName = "./logs/logFile.txt";
        String errorFileName = "./logs/errorFile.txt";
        if (logFileName != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
                System.setOut(ps);
            }
            catch (Exception ex) {
                mmlog.errLog(ex);
                mmlog.errLog("Unable to redirect standard output to " + logFileName);
            }
        }
        if (errorFileName != null) {
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(errorFileName), 64));
                System.setErr(ps);
            }
            catch (Exception ex) {
                mmlog.errLog(ex);
                mmlog.errLog("Unable to redirect standard error to " + errorFileName);
            }
        }
        mmlog.log("----- MekWars Server V " + VERSION + " is starting up... -----");
        mmlog.log("Loading configuration...");
        this.loadConfig();
        mmlog.log("Configuration loaded.");
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[0].equals("debug")) continue;
            this.debug = false;
        }
        mmlog.log("Loading mail file...");
        this.mails = this.checkAndCreateConfig("./data/mails.txt");
        mmlog.log("Mail file loaded.");
        mmlog.log("Creating new campaign environment...");
        this.campaign = new CampaignMain(this);
        mmlog.log("Environment created.");
        mmlog.log("Creating faction status...");
        this.myCommands.put(new HouseStatus(this));
        mmlog.log("House status created.");
        mmlog.log("Creating player status...");
        this.myCommands.put(new PlayerStatus(this));
        mmlog.log("Player status created.");
        CampaignCommand.PublicCommands.put(new HouseStatus(this));
        mmlog.log("Initializing log subsystem. Touching log files.");
        mmlog.mainLog("Main channel log touched.");
        mmlog.factionLog("House channel log touched.");
        mmlog.taskLog("Task report log touched.");
        mmlog.cmdLog("Command log touched.");
        mmlog.pmLog("Private messages (PM) log touched.");
        mmlog.bmLog("Black Market (BM) log touched.");
        mmlog.infoLog("Server info log touched.");
        mmlog.warnLog("Server warnings log touched.");
        mmlog.errLog("Server errors log touched.");
        mmlog.modLog("Moderators log touched.");
        mmlog.cheatLog("Cheat report log touched.");
        mmlog.tickLog("Tick report log touched.");
        boolean useTracker = Boolean.valueOf(this.getConfigParam("USETRACKER"));
        mmlog.infoLog("Use Tracker: " + useTracker);
        if (useTracker) {
            mmlog.infoLog("Attempting to create TrackerThread in MMServ.");
            TrackerThread trackT = new TrackerThread(this);
            trackT.start();
        }
        mmlog.log("Entering main loop cycle. Starting the server...");
        this.startServer(argv);
    }

    public static void addToErrorLog(Exception ex) {
        mmlog.errLog("Generic error occurred. Stack follows:");
        mmlog.errLog(ex);
        try {
            FileOutputStream out = new FileOutputStream("./error.log", true);
            PrintStream p = new PrintStream(out);
            StackTraceElement[] tracer = ex.getStackTrace();
            p.println("---------");
            for (int i = 0; i < tracer.length; ++i) {
                p.println(tracer[i].toString());
            }
            p.println("---------");
            p.close();
            out.close();
        }
        catch (Exception e) {
            mmlog.errLog(e);
        }
    }

    public void loadConfig() {
        try {
            this.config.load(new FileInputStream("./data/serverconfig.txt"));
        }
        catch (Exception e) {
            this.config.setProperty("SERVERNAME", "MekWars Server");
            this.config.setProperty("INFOMESSAGE", "For MekWars project info, visit http://www.sourceforge.net/projects/mekwars");
            this.config.setProperty("UPDATEMESSAGE", "You're not using the a compatible version of the client. You must use" + this.getServerVersion().substring(0, 5) + "*. This is a serious problem, since your Client is incompatible with this server. Contact the server operator or a moderator for details on updating.");
            this.config.setProperty("RESOLVECOUNTRY", "true");
            this.config.setProperty("HELPTEXT", "Recognized Commands:<br>/mail Nickname,Message: Leaves a Message for Nickname<br>/color NewColor: Changes your color to NewColor.<br>/register Nickname,Password,[OldPassword]: Registers your nickname.");
            this.config.setProperty("CAMPAIGNCONFIG", "./data/campaignconfig.txt");
            this.config.setProperty("DATAPORT", "4867");
            this.config.setProperty("USETRACKER", "false");
            this.config.setProperty("TRACKERADDRESS", "none");
            this.config.setProperty("TRACKERLINK", "none");
            this.config.setProperty("TRACKERDESC", "none");
            try {
                this.config.store(new FileOutputStream("./data/serverconfig.txt"), "Server config File");
            }
            catch (Exception e1) {
                mmlog.errLog("config file could not be read or written, defaults will be used.");
                mmlog.errLog(e1);
            }
        }
        this.loadBanPlayers();
        this.loadBanIP();
    }

    public void startServer(String[] args) {
        if (args == null) {
            mmlog.infoLog("Server started without parameters");
        }
        mmserv = this;
        try {
            this.myCommunicator = ServerWrapper.createServer(this);
            this.myCommunicator.start();
        }
        catch (Exception e) {
            mmlog.errLog("== PROBLEM STARTING SERVER WRAPPER ==");
            mmlog.errLog(e);
            mmlog.errLog(e);
        }
    }

    public Hashtable checkAndCreateConfig(String filename) {
        try {
            File configFile = new File(filename);
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            dis.readLine();
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            try {
                mmlog.infoLog("Creating new File");
                mmlog.mainLog("Creating new File");
                if (filename.equals("./data/mails.txt")) {
                    FileOutputStream out = new FileOutputStream(filename);
                    PrintStream p = new PrintStream(out);
                    p.println("<EOF>");
                }
            }
            catch (Exception e) {
                mmlog.errLog(e);
                mmlog.errLog("No file named " + filename + " was found and cannot create one!");
                mmlog.errLog(e);
                mmlog.mainLog("No file named " + filename + " was found and cannot create one!");
                System.exit(1);
            }
        }
        if (filename.equals("./data/mails.txt")) {
            return this.getMails();
        }
        return new Hashtable();
    }

    public void serverStarted() {
        mmlog.infoLog("- SERVER STARTED -");
        mmlog.mainLog("Server started!");
        this.campaign.init();
    }

    public void clientLogin(String name) {
        Long until;
        String originalName = name;
        name = name.toLowerCase();
        InetAddress hisip = this.getIP(name);
        if (!(originalName.startsWith("[Coach]") || originalName.startsWith("[Dedicated]") || originalName.startsWith("Nobody"))) {
            String logname;
            if (this.iplog.get(hisip) != null && !name.equals(logname = (String)this.iplog.get(hisip))) {
                SPlayer b;
                String nametmp = name;
                SPlayer a = this.getCampaign().loadPlayerFile(name);
                if (a != null) {
                    nametmp = nametmp + " " + this.getCampaign().getPlayer(name).getMyHouse().getAbbreviation();
                }
                if ((b = this.getCampaign().getPlayer(logname)) != null) {
                    logname = logname + " " + this.getCampaign().getPlayer(logname).getMyHouse().getAbbreviation();
                }
                if (a != null && b != null) {
                    if (a.getGroupAllowance().intValue() != b.getGroupAllowance().intValue() || a.getGroupAllowance() == 0) {
                        mmlog.modLog("Double Accounting: " + nametmp + " and " + logname + " IP: " + hisip);
                        this.getCampaign().doSendModMail("NOTE:", "Double Accounting: " + nametmp + " and " + logname + " IP: " + hisip);
                    }
                } else {
                    mmlog.modLog("Double Accounting: " + nametmp + " and " + logname + " IP: " + hisip);
                    this.getCampaign().doSendModMail("NOTE:", "Double Accounting: " + nametmp + " and " + logname + " IP: " + hisip);
                }
            }
            this.iplog.put(hisip, name);
        }
        if (this.banips.get(hisip) != null) {
            until = this.banips.get(hisip);
            if (until > System.currentTimeMillis() || until == 0L) {
                if (until != 0L) {
                    this.clientSend("CH|You have been banned. You may not join this server until " + new Date(until).toString(), name);
                }
                this.myCommunicator.kill(name, this.myCommunicator.getClient(ChatServer.clientKey("CampaignServer")), "");
                return;
            }
            this.banips.remove(hisip);
            this.bansUpdate();
        }
        if (this.banaccounts.get(name.toLowerCase()) != null) {
            until = Long.valueOf(this.banaccounts.get(name.toLowerCase()));
            if (until > System.currentTimeMillis() || until == 0L) {
                if (until != 0L) {
                    this.clientSend("CH|You have been banned. You may not join this server until " + new Date(until).toString(), name);
                }
                this.myCommunicator.kill(name, this.myCommunicator.getClient(ChatServer.clientKey("CampaignServer")), "");
                return;
            }
            this.banaccounts.remove(name);
            this.bansUpdate();
        }
        int status = 2;
        ChatClient c = this.myCommunicator.getClient(ChatServer.clientKey(name));
        if (c != null) {
            status = c.getAccessLevel();
        }
        MMClientInfo newUser = new MMClientInfo(originalName, this.getIP(name), System.currentTimeMillis(), status);
        mmlog.infoLog(originalName + " logged in from " + this.getIP(name).toString() + " at " + new Date(System.currentTimeMillis()).toString());
        if (!originalName.startsWith("[Dedicated]")) {
            Vector allthose;
            if (this.ips.get(hisip) != null) {
                allthose = (Vector)this.ips.get(hisip);
                String result = "Warning: " + originalName + " has the same IP as ";
                boolean allowed = true;
                int groupid = 0;
                for (int i = 0; i < allthose.size(); ++i) {
                    MMClientInfo user = (MMClientInfo)allthose.elementAt(i);
                    SPlayer p = this.getCampaign().getPlayer(user.getName());
                    if (p != null) {
                        if (i == 0) {
                            groupid = p.getGroupAllowance();
                        } else if (p.getGroupAllowance() != groupid || groupid == 0) {
                            allowed = false;
                        }
                    } else {
                        allowed = false;
                    }
                    result = result + user.getName();
                    if (allthose.size() <= i + 1) continue;
                    result = result + " and ";
                }
                if (!allowed) {
                    this.getCampaign().doSendModMail("NOTE:", result);
                }
                allthose.add(newUser);
            } else {
                allthose = new Vector();
                allthose.add(newUser);
                this.ips.put(hisip, allthose);
            }
            this.iphelp.put(newUser, hisip);
        }
        String clientVersion = "any " + this.getVersion().substring(0, this.getVersion().length() - 1) + "x";
        this.clientSend("CH|Welcome to " + this.getConfigParam("SERVERNAME") + " (Server Version: " + this.getVersion() + ", Compatible Clients: " + clientVersion + ")", name);
        this.clientSend("CH|" + this.getConfigParam("INFOMESSAGE"), name);
        this.sendGames(name);
        this.sendUsers(name);
        if (Boolean.valueOf(CampaignMain.cm.getConfig("ResolveCountry")).booleanValue()) {
            newUser.setCountry(this.getCountryString(this.getIP(name).toString().substring(1)));
        }
        this.users.put(name, newUser);
        this.checkAndSendMail(name);
    }

    public InetAddress getIP(String name) {
        return this.myCommunicator.getIP(name);
    }

    public boolean isAdmin(String username) {
        ChatClient c = this.myCommunicator.getClient(ChatServer.clientKey(username));
        if (username.startsWith("[Dedicated] ")) {
            return true;
        }
        return c != null && c.getAccessLevel() >= 200;
    }

    public boolean isModerator(String username) {
        ChatClient c = this.myCommunicator.getClient(ChatServer.clientKey(username));
        if (username.startsWith("[Dedicated] ")) {
            return true;
        }
        return c != null && c.getAccessLevel() >= 100;
    }

    public int getUserLevel(String username) {
        ChatClient c = this.myCommunicator.getClient(ChatServer.clientKey(username));
        if (c != null) {
            return c.getAccessLevel();
        }
        return 0;
    }

    public void clientLogout(String name) {
        if (name == null) {
            return;
        }
        MMClientInfo user = this.getUser(name);
        if (user == null) {
            return;
        }
        InetAddress hisip = (InetAddress)this.iphelp.get(user);
        if (hisip != null) {
            Vector all = (Vector)this.ips.get(hisip);
            if (all != null) {
                if (all.size() == 1) {
                    this.ips.remove(hisip);
                } else {
                    all.remove(user);
                }
            }
            this.iphelp.remove(user);
        }
        this.campaign.doDisconnectCheckOnPlayer(name);
        this.campaign.doLogoutPlayer(name);
        this.sendRemoveUserToAll(name, true);
        this.doRemoveUserFromGame(name);
        mmlog.infoLog("Client " + name + "logged out.");
        this.users.remove(name.toLowerCase());
        if (this.games.get(name) != null) {
            MMGame game = (MMGame)this.games.get(name);
            this.games.remove(name);
            this.doCloseGame(game);
        }
    }

    public void clientSend(String msg, String name) {
        if (msg != null && !msg.trim().equals("CH|")) {
            this.myCommunicator.sendServerMessage(msg, name);
        }
    }

    public void broadcastRaw(String msg) {
        this.myCommunicator.broadcastComm(msg);
    }

    public void clientRecieve(String lineIn, String name) {
        block98: {
            StringTokenizer st = new StringTokenizer(lineIn, "|");
            try {
                String task = (String)st.nextElement();
                ServerCommand c = null;
                c = (ServerCommand)this.myCommands.get(task.toUpperCase());
                if (c != null) {
                    c.reset();
                    c.setUsername(name);
                    c.parseArguments(lineIn.substring(lineIn.indexOf("|") + 1));
                    return;
                }
                if (task.equals("NG")) {
                    MMGame game = new MMGame(st.nextToken());
                    game.setUID(name);
                    if (game.getIp().equals("127.0.0.1")) {
                        game.setIp(this.myCommunicator.getClient(name).getHost());
                    }
                    this.games.put(name, game);
                    this.getUser(name).setHisgame(game);
                    Enumeration e = this.users.keys();
                    while (e.hasMoreElements()) {
                        this.clientSend("NG|" + game.toString(), (String)e.nextElement());
                    }
                    break block98;
                }
                if (task.equals("CH")) {
                    String text = (String)st.nextElement();
                    if (text.indexOf("href") != -1 && text.indexOf("MEKWARS") != -1 && !this.isAdmin(name)) {
                        this.clientSend("CH|This message was deleted for security reasons", name);
                        return;
                    }
                    if (!text.startsWith("/") && text.length() > 450 && !this.isModerator(name)) {
                        this.clientSend("CH|This message has been blocked by the spam protector!", name);
                        return;
                    }
                    if (text.startsWith("/")) {
                        String result;
                        MMClientInfo client;
                        text = text.substring(1);
                        StringTokenizer commandTokenizer = new StringTokenizer(text);
                        String taskcommand = commandTokenizer.nextToken();
                        if (text.startsWith("shutdown") && this.isAdmin(name)) {
                            CampaignMain.cm.getMarket().clearMarketOfPlayers();
                            CampaignMain.cm.savePlayers();
                            CampaignMain.cm.forceSavePlayers(name);
                            this.clientSend("CH|You halted the server. Have a nice day.", name);
                            mmlog.infoLog("Server has been halted. Have a nice day!");
                            this.campaign.addToNewsFeed("Server halted!");
                            MMNetPasswd.save();
                            System.exit(0);
                        }
                        if (text.startsWith("me ")) {
                            client = this.getUser(name);
                            if (client != null) {
                                if (this.ignoreList.indexOf(client.getName()) == -1) {
                                    this.sendChat(name + "|#me " + text.substring(3));
                                } else {
                                    this.clientSend("CH|You've been set to ignore mode and cannot participate in chat.", name);
                                }
                            } else {
                                this.sendChat(name + "|#me " + text.substring(3));
                            }
                        }
                        if (text.startsWith("notify") && this.isModerator(name)) {
                            String message = text.substring(7);
                            this.myCommunicator.broadcastComm("SP|" + message);
                        }
                        if (text.startsWith("color")) {
                            if (text.length() < 6) {
                                this.clientSend("CH|You need to choose a color.. terrainID.E.: /color blue", name);
                            } else {
                                this.getUser(name).setColor(text.substring(6));
                                this.broadcastRaw("UC|" + name + "|" + this.getUser(name).getColor());
                            }
                        }
                        if (text.startsWith("log")) {
                            this.writeToLog();
                        }
                        if (text.startsWith("pws")) {
                            mmlog.infoLog("This line intentionally left blank.");
                        }
                        if (text.startsWith("savecampaign")) {
                            if (this.isModerator(name)) {
                                this.campaign.toFile();
                                this.clientSend("CH|You saved the server. Have a nice day.", name);
                            } else {
                                this.clientSend("CH|You need a higher userlevel to save the server. Nice try though.", name);
                            }
                        }
                        if (text.startsWith("config")) {
                            this.loadConfig();
                        }
                        if (text.startsWith("help")) {
                            this.doSendHelp(name);
                        }
                        if (text.startsWith("mail") && text.length() > 5) {
                            this.doStoreMail(text.substring(5), name);
                        }
                        if (text.startsWith("motd")) {
                            this.clientSend("CH|" + this.getConfigParam("INFOMESSAGE"), name);
                        }
                        if (text.startsWith("ignorelist") && this.isModerator(name)) {
                            this.clientSend("CH|Curently ignored people: " + this.ignoreList.toString(), name);
                        }
                        if (text.startsWith("iplist") && this.isModerator(name)) {
                            result = "CH|Current IP's:<br>";
                            TreeSet sorted = new TreeSet();
                            sorted.addAll(this.iphelp.keySet());
                            for (MMClientInfo m : sorted) {
                                result = result + m.getName() + " (" + m.getAddon() + ") " + m.getAdr() + "<br>";
                            }
                            this.clientSend(result, name);
                        }
                        if (text.startsWith("ignore") && !text.startsWith("ignorelist") && this.isModerator(name)) {
                            client = this.getUser(text.substring(7));
                            if (!client.getName().equals("Nobody")) {
                                if (this.ignoreList.indexOf(client.getName()) == -1) {
                                    this.ignoreList.add(client.getName());
                                    mmlog.cheatLog(name + " muted " + client.getName());
                                    this.sendChat(name + " muted " + client.getName());
                                } else {
                                    this.ignoreList.remove(client.getName());
                                    this.sendChat(name + " unmuted " + client.getName());
                                    mmlog.cheatLog(name + " unmuted " + client.getName());
                                }
                            } else {
                                this.ignoreList.remove(text.substring(7));
                                mmlog.cheatLog(name + " unmuted " + client.getName());
                                this.clientSend("CH|You set " + text.substring(7) + " to be ignored to: false. He/She is currently not in the channel.", name);
                            }
                        }
                        if (text.startsWith("kick")) {
                            if (this.isModerator(name)) {
                                String toKick = text.substring(5);
                                if (this.myCommunicator.getClient(ChatServer.clientKey(toKick)) != null) {
                                    this.clientSend("CH|You have been kicked by " + name, toKick);
                                    this.myCommunicator.kill(toKick, this.myCommunicator.getClient(ChatServer.clientKey(this.myCommunicator.getClient(name))), "");
                                }
                                if (this.campaign != null) {
                                    mmlog.cheatLog(name + " kicked " + toKick);
                                    this.sendChat(name + " kicked " + toKick);
                                }
                            } else {
                                this.clientSend("CH|At home I am a nice guy, but I don't want the world to know. Humble people, I've found, don't get very far. - Muhammed Ali", name);
                            }
                        }
                        if (taskcommand.equals("ban")) {
                            if (this.isModerator(name)) {
                                StringTokenizer str = new StringTokenizer(text.substring(4), "#");
                                String toKill = str.nextToken();
                                int howlong = Integer.parseInt(str.nextToken());
                                InetAddress banip = this.getIP(toKill);
                                Long until = new Long(System.currentTimeMillis() + (long)(60000 * howlong));
                                if (this.myCommunicator.getClient(ChatServer.clientKey(toKill)) != null) {
                                    this.clientSend("CH|You have been banned by " + name + " for " + howlong + " minutes", toKill);
                                    this.myCommunicator.kill(toKill, this.myCommunicator.getClient(ChatServer.clientKey(this.myCommunicator.getClient(name))), "");
                                }
                                if (banip != null) {
                                    this.banips.put(banip, until);
                                }
                                this.banaccounts.put(toKill.toLowerCase(), Long.toString(until));
                                this.bansUpdate();
                                if (this.campaign != null) {
                                    mmlog.cheatLog(name + " banned " + toKill + " for " + howlong + " minutes");
                                    this.sendChat(name + " banned " + toKill + " for " + howlong + " minutes");
                                }
                            } else {
                                this.clientSend("CH|It's just a job. Grass grows, birds fly, waves pound the sand. I beat people up. - Muhammed Ali", name);
                            }
                        }
                        if (taskcommand.equals("banlist") && this.isModerator(name)) {
                            result = "CH|Banned accounts:<br>";
                            int i = 1;
                            Enumeration<String> banNames = this.banaccounts.keys();
                            Enumeration<String> banTimes = this.banaccounts.elements();
                            while (banNames.hasMoreElements()) {
                                String banName = banNames.nextElement();
                                String banTime = banTimes.nextElement();
                                Long until = Long.valueOf(banTime);
                                if (until < System.currentTimeMillis() || until == 0L) {
                                    this.banaccounts.remove(banName);
                                    this.bansUpdate();
                                    continue;
                                }
                                Long l = Long.valueOf(banTime);
                                result = result + Integer.toString(i++);
                                result = result + ") ";
                                result = result + banName;
                                result = result + " [unban at ";
                                result = result + new Date(l).toString();
                                result = result + "]<br>";
                            }
                            i = 1;
                            result = result + "Banned IPs:<br>";
                            Enumeration<InetAddress> e = this.banips.keys();
                            while (e.hasMoreElements()) {
                                InetAddress inetAddress = e.nextElement();
                                Long l = this.banips.get(inetAddress);
                                if (l < System.currentTimeMillis() || l == 0L) {
                                    this.banips.remove(inetAddress);
                                    this.bansUpdate();
                                    continue;
                                }
                                result = result + i++ + ") " + inetAddress.toString() + " [unban at " + new Date(l).toString() + "]<br>";
                            }
                            this.clientSend(result, name);
                            mmlog.cheatLog(name + " checked ban list");
                        }
                        if (taskcommand.equals("unbanip") && this.isModerator(name)) {
                            int id = Integer.parseInt(text.substring(8));
                            ++id;
                            Enumeration<InetAddress> e = this.banips.keys();
                            InetAddress inetAddress = InetAddress.getLocalHost();
                            while (id >= 0) {
                                inetAddress = e.nextElement();
                                --id;
                            }
                            this.banips.remove(inetAddress);
                            this.bansUpdate();
                            this.clientSend("CH|You unbanned: " + inetAddress, name);
                        }
                        if (taskcommand.equals("unban") && this.isModerator(name)) {
                            String account = text.substring(6);
                            if (this.banaccounts.get(account.toLowerCase()) != null) {
                                this.banaccounts.remove(account);
                                this.bansUpdate();
                                mmlog.cheatLog(name + " unbanned " + account);
                                this.clientSend("CH|You unbanned " + account, name);
                            } else {
                                this.clientSend("CH|Unban failed for " + account, name);
                                mmlog.cheatLog(name + " tried to uban " + account + " but failed");
                            }
                        }
                        if (taskcommand.equals("setmotd")) {
                            if (this.isModerator(name)) {
                                String motdText = text.substring(8);
                                this.config.setProperty("INFOMESSAGE", motdText);
                                this.saveServerConfig();
                                this.clientSend("CH|You set a new MOTD. Wanker.", name);
                            } else {
                                this.clientSend("CH|Two things are infinite: the universe and human stupidity. And I'm not sure about the universe. - Albert Einstein", name);
                            }
                        }
                        if (text.toUpperCase().startsWith("AM")) {
                            if (this.isModerator(name)) {
                                this.sendChat(name + ": " + text.substring(3));
                            } else {
                                this.clientSend("CH|I said I was the greatest, not the smartest! - Muhammed Ali", name);
                            }
                        }
                        if (text.startsWith("c ") || text.startsWith("C ")) {
                            this.campaign.fromUser(text, name);
                        }
                        if (text.startsWith("roll")) {
                            this.campaign.userRoll(text, name);
                        }
                        if (!text.startsWith("register")) break block98;
                        try {
                            text = text.substring(9);
                            StringTokenizer str = new StringTokenizer(text, ",");
                            String regname = str.nextToken().trim().toLowerCase();
                            String pw = str.nextToken();
                            MMNetPasswdRecord r = null;
                            boolean regged = false;
                            try {
                                r = MMNetPasswd.getRecord(regname, null);
                            }
                            catch (Exception ex) {
                                mmlog.errLog(ex);
                                regged = true;
                            }
                            if (!regged || this.isAdmin(name)) {
                                if (pw.length() > 3 && pw.length() < 11) {
                                    MMNetPasswd.writeRecord(regname, 2, pw);
                                    this.clientSend("CH|You have successfully registered the name " + regname, name);
                                    mmlog.modLog("New player registered: " + regname);
                                } else {
                                    this.clientSend("CH|Your password has to be between 4 and 10 characters!", name);
                                }
                                break block98;
                            }
                            this.clientSend("CH|This name is already registered!", name);
                            mmlog.modLog(name + " tried to register: " + regname + " which was already regged");
                        }
                        catch (Exception e) {
                            mmlog.errLog(e);
                            mmlog.errLog("^ Not supposed to happen! ^");
                            mmlog.errLog(e);
                            mmlog.errLog("Not supposed to happen");
                        }
                        break block98;
                    }
                    MMClientInfo client = this.getUser(name);
                    if (client != null) {
                        if (this.ignoreList.indexOf(client.getName()) == -1) {
                            this.sendChat(name + "|" + text);
                        } else {
                            this.clientSend("CH|You've been set to ignore mode and cannot participate in chat.", name);
                        }
                    } else {
                        this.sendChat(name + "|" + text);
                    }
                    break block98;
                }
                if (task.equals("CR")) {
                    String result = st.nextToken();
                    this.getCampaign().doProcessAutomaticReport(result, name);
                    mmlog.taskLog(name + " reported: " + result);
                } else if (task.equals("IPU")) {
                    String result = st.nextToken();
                    this.getCampaign().addInProgressUpdate(result, name);
                } else if (task.equals("CG")) {
                    MMGame game = (MMGame)this.games.get(name);
                    this.games.remove(name);
                    this.getUser(name).setHisgame(null);
                    this.doCloseGame(game);
                } else if (task.equals("RG")) {
                    this.sendGames(name);
                } else if (task.equals("RU")) {
                    this.sendUsers(name);
                } else if (task.equals("JG")) {
                    MMGame mygame = st.hasMoreTokens() ? (MMGame)this.games.get(st.nextToken()) : this.getUser(name).getHisgame();
                    if (mygame != null && mygame.getStatus().equals("Open")) {
                        this.doAddUserToGame(name, mygame);
                    }
                } else if (task.equals("LG")) {
                    MMGame mygame = (MMGame)this.games.get(st.nextToken());
                    if (mygame != null) {
                        this.doRemoveUserFromGame(name, mygame);
                    }
                } else if (task.equals("UGP")) {
                    MMGame mygame = (MMGame)this.games.get(st.nextToken());
                    if (mygame != null) {
                        this.doUpdateGamePlayers(mygame, st);
                    }
                } else if (task.equals("SS")) {
                    MMGame mygame = st.countTokens() > 1 ? (MMGame)this.games.get(st.nextToken()) : this.getUser(name).getHisgame();
                    mygame.setStatus((String)st.nextElement());
                    this.sendStatusUpdateToAll(mygame);
                } else {
                    this.clientSend("CH|Unknown command. Please make sure your client uses protocol version " + MMServ.getProtocolVersion() + ".", name);
                    mmlog.warnLog("Got a strange command from " + name);
                }
            }
            catch (Exception ex) {
                if (lineIn.equals("GB")) break block98;
                MMServ.addToErrorLog(ex);
                this.clientSend("CH|Your Client sent a false packet or caused a server error. It's most likely that you entered an illegal server command.", name);
                mmlog.errLog("False packet/illegal command:");
                mmlog.errLog(ex);
                mmlog.warnLog("Received: '" + lineIn + "'. Sent an Update Request to " + name);
            }
        }
    }

    public void statusMessage() {
        mmlog.mainLog("Open Games: " + this.games.size());
        mmlog.infoLog("Open Games: " + this.games.size());
    }

    public void sendGames(String name) {
        Enumeration c = this.games.elements();
        String s = "GS";
        while (c.hasMoreElements()) {
            MMGame gm = (MMGame)c.nextElement();
            if (gm == null) continue;
            s = s.concat("|" + gm.toString());
        }
        this.clientSend(s, name);
        Enumeration e = this.games.elements();
        while (e.hasMoreElements()) {
            MMGame mygame = (MMGame)e.nextElement();
            this.clientSend("SS|" + mygame.getUID() + "|" + mygame.getStatus(), name);
        }
    }

    public void sendGamesToAll() {
        Enumeration e = this.users.keys();
        while (e.hasMoreElements()) {
            this.sendGames((String)e.nextElement());
        }
    }

    public void sendUsersToAll() {
        Enumeration e = this.users.keys();
        while (e.hasMoreElements()) {
            this.sendGames((String)e.nextElement());
        }
    }

    public void sendRemoveUserToAll(String name, boolean userGone) {
        if (userGone) {
            mmlog.infoLog(name + " left the room.");
        }
        this.myCommunicator.broadcastComm("UG|" + this.getUser(name) + (userGone ? "|GONE" : ""));
    }

    public void sendNewUserToAll(String name, boolean newUser) {
        this.myCommunicator.broadcastComm("NU|" + this.getUser(name) + (newUser ? "|NEW" : ""));
    }

    public void sendUsers(String name) {
        Enumeration u = this.users.elements();
        String toSend = "US";
        while (u.hasMoreElements()) {
            toSend = toSend.concat("|" + ((MMClientInfo)u.nextElement()).toString());
        }
        this.clientSend(toSend, name);
    }

    public void sendChat(String s) {
        this.myCommunicator.broadcastComm("CH|" + s);
        mmlog.mainLog(s);
    }

    public void checkAndSendMail(String name) {
        if (this.mails.get(name.toLowerCase()) != null) {
            this.clientSend("PM|SERVER|You have stored mail.[<a href=\"MEKWARS/c requestservermail\">Read</a>]", name);
        }
    }

    public int userCount() {
        return this.users.size();
    }

    public int userCount(boolean includeDeds) {
        if (includeDeds) {
            return this.users.size();
        }
        int toReturn = this.users.size();
        for (String currName : this.users.keySet()) {
            if (!currName.startsWith("[Dedicated]")) continue;
            --toReturn;
        }
        return toReturn;
    }

    public boolean nameExists(String n) {
        return this.users.get(n.toLowerCase()) != null;
    }

    public CampaignMain getCampaign() {
        return this.campaign;
    }

    public String getVersion() {
        return VERSION;
    }

    public static String getProtocolVersion() {
        return "4";
    }

    private void doCloseGame(MMGame game) {
        if (game != null) {
            this.myCommunicator.broadcastComm("CG|" + game.toString());
        }
    }

    public Hashtable getMails() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            File configFile = new File("./data/mails.txt");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            String tmp = dis.readLine();
            while (tmp != null) {
                StringTokenizer st = new StringTokenizer(tmp, "|");
                if (st.hasMoreElements()) {
                    String name = (String)st.nextElement();
                    if (st.hasMoreElements()) {
                        String mail = (String)st.nextElement();
                        if (result.get(name) != null) {
                            result.put(name, this.mails.get(name) + "<br>" + mail);
                        } else {
                            result.put(name, mail);
                        }
                    }
                }
                tmp = dis.readLine();
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            mmlog.errLog("Problems reading mail file:");
            mmlog.errLog(ex);
            MMServ.addToErrorLog(ex);
        }
        return result;
    }

    public void doWriteMailFile() {
        try {
            FileOutputStream out = new FileOutputStream("./data/mails.txt");
            PrintStream p = new PrintStream(out);
            Enumeration e = this.mails.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p.println(key + "|" + (String)this.mails.get(key));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            mmlog.errLog("Problems writing mail file:");
            mmlog.errLog(ex);
            MMServ.addToErrorLog(ex);
        }
    }

    public void writeToLog() {
        try {
            FileOutputStream out = new FileOutputStream("serverlog.txt", true);
            PrintStream p = new PrintStream(out);
            p.println(this.log);
            p.close();
            out.close();
            this.log = "";
        }
        catch (Exception ex) {
            mmlog.warnLog("Couldn't write to log file!");
            mmlog.warnLog("(Well, I *AM* writing to log file, so this code should never trigger!");
            mmlog.mainLog("Couldn't write to Log File!");
        }
    }

    public void cleanup() {
        this.writeToLog();
        this.campaign.toFile();
        mmlog.infoLog("Server exiting... Bye bye...");
        System.exit(0);
    }

    public static String removeBadChars(String s) {
        s.replace('\u00a7', ' ');
        s.replace('~', ' ');
        s.replace('|', ' ');
        s.replace('%', ' ');
        s.replace('$', ' ');
        s.replace('#', ' ');
        s.replace('*', ' ');
        return s;
    }

    public void setName(String nn, boolean newUser, String name) {
        nn = MMServ.removeBadChars(nn);
        nn = nn.trim();
        boolean wasSpace = false;
        for (int i = 0; i < nn.length(); ++i) {
            if (nn.charAt(i) == ' ') {
                if (wasSpace) {
                    nn = nn.substring(0, i) + nn.substring(i + 1);
                    --i;
                    continue;
                }
                wasSpace = true;
                continue;
            }
            wasSpace = false;
        }
        boolean allok = false;
        if (allok) {
            if (!newUser) {
                this.sendRemoveUserToAll(name, newUser);
                this.clientSend("CH|Your name was succesfully changed to: " + nn, name);
            }
            if (this.getUser(name).getHisgame() != null) {
                this.doRemoveUserFromGame(name);
            }
            this.getUser(name).setName(nn);
            if (this.getUser(name).getHisgame() != null) {
                this.doAddUserToGame(name, this.getUser(name).getHisgame());
            }
            this.sendNewUserToAll(name, newUser);
        } else if (newUser) {
            this.getUser(name).setName("Nobody");
            this.sendNewUserToAll(name, newUser);
        }
        this.checkAndSendMail(name);
    }

    public void sendNewUser(String username) {
        this.sendNewUserToAll(username, true);
    }

    public void doSendHelp(String name) {
        this.clientSend("CH|" + this.getConfigParam("HELPTEXT"), name);
    }

    public void doStoreMailToHashtable(String from, String name, String text) {
        String[] ids;
        if (name == null || text == null) {
            return;
        }
        if (text.indexOf("CH|") == 0) {
            text = text.substring(3);
        }
        if ((ids = TimeZone.getAvailableIDs(0)).length != 0) {
            SimpleTimeZone pdt = new SimpleTimeZone(0, ids[0]);
            GregorianCalendar now = new GregorianCalendar(pdt);
            Date currentTime = new Date();
            now.setTime(currentTime);
            text = now.get(2) + 1 + "/" + now.get(5) + " " + now.get(10) + ":" + now.get(12) + " " + text;
        }
        if (this.mails.get(name.toLowerCase()) == null) {
            this.mails.put(name.toLowerCase(), text);
        } else {
            this.mails.put(name.toLowerCase(), (String)this.mails.get(name.toLowerCase()) + "<br>" + text);
        }
        this.doWriteMailFile();
    }

    public void doStoreMail(String s, String name) {
        StringTokenizer st = new StringTokenizer(s, ",");
        String target = "";
        String text = "";
        if (st.hasMoreElements()) {
            target = ((String)st.nextElement()).trim();
            if (st.hasMoreElements()) {
                text = "from " + name + ": ";
                String mailtext = "";
                while (st.hasMoreElements()) {
                    mailtext = mailtext + st.nextElement();
                }
                text = text + mailtext;
                if (this.getUser(target).getName().equals(target)) {
                    this.clientSend("PM|" + name + "|" + mailtext, target);
                } else {
                    this.doStoreMailToHashtable(name, target, text);
                    this.clientSend("CH|Your mail to " + target + " has been saved.", name);
                }
                if (this.campaign.getPlayer(name) != null) {
                    if (this.campaign.getPlayer(target) != null) {
                        mmlog.pmLog(name + "[" + this.campaign.getPlayer(name).getMyHouse().getAbbreviation() + "] -> " + target + "[" + this.campaign.getPlayer(target).getMyHouse().getAbbreviation() + "]: " + mailtext);
                    } else {
                        mmlog.pmLog(name + "[" + this.campaign.getPlayer(name).getMyHouse().getAbbreviation() + "] -> " + target + ": " + mailtext);
                    }
                } else {
                    mmlog.pmLog(name + " -> " + target + ": " + mailtext);
                }
            }
        }
    }

    private String getLandForIP(String address) {
        try {
            if (address.startsWith("192.168") || address.startsWith("10.") || address.equals("127.0.0.1")) {
                return "The LAN";
            }
            Socket whoSock = new Socket("whois.arin.net", 43);
            PrintStream outstream = new PrintStream(whoSock.getOutputStream());
            BufferedReader instream = new BufferedReader(new InputStreamReader(whoSock.getInputStream()));
            outstream.println(address);
            String line = instream.readLine();
            if (line != null) {
                String nextline;
                if (line.equals("")) {
                    line = instream.readLine();
                }
                if (line.indexOf("RIPE") != -1) {
                    whoSock.close();
                    return this.getLandForIP("whois.ripe.net", address);
                }
                if (line.indexOf("Asia") != -1) {
                    whoSock.close();
                    return this.getLandForIP("whois.apnic.net", address);
                }
                while ((nextline = instream.readLine()) != null) {
                    if (!nextline.startsWith("Country:") && !nextline.startsWith("country:")) continue;
                    StringTokenizer st = new StringTokenizer(nextline);
                    st.nextToken();
                    String code = st.nextToken();
                    return code;
                }
                StringTokenizer st = new StringTokenizer(line);
                String last = "";
                String current = "";
                while (st.hasMoreElements()) {
                    last = current;
                    current = st.nextToken();
                    if (!current.startsWith("(")) continue;
                    return this.getLandForIP(last);
                }
                whoSock.close();
                return "unknown";
            }
        }
        catch (Exception ex) {
            return "outer space";
        }
        return "far away";
    }

    private String getLandForIP(String authority, String address) {
        try {
            String line;
            Socket whoSock = new Socket(authority, 43);
            PrintStream out = new PrintStream(whoSock.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(whoSock.getInputStream()));
            out.println(address);
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("Country:") && !line.startsWith("country:")) continue;
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                String code = st.nextToken();
                return code;
            }
        }
        catch (IOException ioe) {
            return "--";
        }
        return "--";
    }

    public String getCountryString(String ip) {
        String result;
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        if ((result = this.ipToCountry.seachIpCountry(ip)).equals("LOC")) {
            result = "The LAN";
        }
        return result;
    }

    public void sendStatusUpdateToAll(MMGame mygame) {
        this.myCommunicator.broadcastComm("SS|" + mygame.getUID() + "|" + mygame.getStatus());
    }

    public MMClientInfo getUser(String name) {
        if (name == null || this.users.get(name.toLowerCase()) == null) {
            return new MMClientInfo();
        }
        return (MMClientInfo)this.users.get(name.toLowerCase());
    }

    public String getConfigParam(String p) {
        Object res = this.config.get(p);
        if (res != null) {
            return (String)res;
        }
        return "";
    }

    public void doRemoveUserFromGame(String name) {
        if (this.getUser(name).getHisgame() != null) {
            MMGame mygame = this.getUser(name).getHisgame();
            mygame.getCurrentPlayers().remove(name);
            Enumeration e = this.users.keys();
            while (e.hasMoreElements()) {
                this.clientSend("JG|" + mygame.toString(), (String)e.nextElement());
            }
        }
    }

    public void fromCampaignMod(String txt, String username) {
        MMClientInfo usr = (MMClientInfo)this.users.get(username.toLowerCase());
        if (usr != null) {
            this.clientSend(txt, username);
        } else if (txt.startsWith("CH|")) {
            this.doStoreMailToHashtable(null, username, txt);
        }
    }

    public void doAddUserToGame(String name, MMGame mygame) {
        String playername = name;
        if (mygame.getStatus().equals("Open")) {
            Vector playersvector = mygame.getCurrentPlayers();
            this.getUser(name).setHisgame(mygame);
            if (!playersvector.contains(playername)) {
                playersvector.add(playername);
            }
            Enumeration e = this.users.keys();
            while (e.hasMoreElements()) {
                this.clientSend("JG|" + mygame.toString(), (String)e.nextElement());
            }
        }
    }

    public void doUpdateGamePlayers(MMGame mygame, StringTokenizer st) {
        mygame.getCurrentPlayers().clear();
        while (st.hasMoreTokens()) {
            mygame.getCurrentPlayers().add(st.nextToken());
        }
        this.myCommunicator.broadcastComm("JG|" + mygame.toString());
    }

    public void doRemoveUserFromGame(String name, MMGame mygame) {
        mygame.getCurrentPlayers().remove(name);
        this.myCommunicator.broadcastComm("JG|" + mygame.toString());
    }

    public ServerWrapper getMyCommunicator() {
        return this.myCommunicator;
    }

    public void bansUpdate() {
        try {
            Object q;
            FileOutputStream out = new FileOutputStream("./data/accountbans.txt");
            PrintStream p = new PrintStream(out);
            Enumeration<Object> e = this.banaccounts.keys();
            while (e.hasMoreElements()) {
                q = e.nextElement();
                p.println(q + "=" + this.banaccounts.get(q));
            }
            p.close();
            out.close();
            out = new FileOutputStream("./data/ipbans.txt");
            p = new PrintStream(out);
            e = this.banips.keys();
            while (e.hasMoreElements()) {
                q = e.nextElement();
                p.println(q + "=" + this.banips.get(q));
            }
            p.close();
            out.close();
        }
        catch (Exception e) {
            mmlog.errLog("Problem updating ban files:");
            mmlog.errLog(e);
        }
    }

    public Hashtable getVersionsubids() {
        return this.versionsubids;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public Vector getIgnoreList() {
        return this.ignoreList;
    }

    public void saveServerConfig() {
        try {
            FileOutputStream fos = new FileOutputStream("./data/serverconfig.txt");
            PrintStream ps = new PrintStream(fos);
            this.config.store(ps, "Server Options");
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            mmlog.errLog("Unable to save server config file.");
            mmlog.errLog(ex);
            mmlog.errLog(ex.getMessage());
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Hashtable getServerMail() {
        return this.mails;
    }

    public void loadBanIP() {
        try {
            File banFile = new File("./data/ipbans.txt");
            if (!banFile.exists()) {
                banFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(banFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                InetAddress ia;
                String line = dis.readLine();
                StringTokenizer ST = new StringTokenizer(line, "=");
                String ip = ST.nextToken();
                Long time = Long.valueOf(ST.nextToken());
                if (ip.indexOf("/") > -1) {
                    ip = ip.substring(ip.indexOf("/") + 1);
                }
                if ((ia = InetAddress.getByName(ip)) != null) {
                    this.banips.put(ia, time);
                    mmlog.infoLog("Added " + line + " to the list of banned IPs");
                    mmlog.mainLog("Added " + line + " to the list of banned IP's");
                    continue;
                }
                mmlog.warnLog("Importing IP bans; offending line: " + line);
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            mmlog.errLog("Problems with loading IP banlist:");
            mmlog.errLog(ex);
        }
    }

    public void loadBanPlayers() {
        try {
            mmlog.infoLog("Loading Ban Players");
            File banFile = new File("./data/accountbans.txt");
            if (!banFile.exists()) {
                banFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(banFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String input = dis.readLine();
                StringTokenizer st = new StringTokenizer(input, "=");
                String toBan = st.nextToken().trim();
                String howLong = st.nextToken().trim();
                if (toBan != null && howLong != null) {
                    this.banaccounts.put(toBan.toLowerCase(), howLong);
                    mmlog.infoLog("Added " + toBan + " to the banlist (for " + howLong + ")");
                    mmlog.mainLog("Added " + toBan + " to the banlist (for " + howLong + ")");
                    continue;
                }
                mmlog.warnLog("Initial bans warning: " + toBan + " / " + howLong);
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            mmlog.errLog("Problems reading ban file at startup!");
        }
    }

    static {
        mmlog = new SMWLogger();
    }
}

