/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import java.util.Enumeration;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SUnit;

public class AutoArmy {
    private Vector theUnits;

    public AutoArmy(int i) {
        this.theUnits = this.generateAuto(i);
    }

    private Vector generateAuto(int i) {
        int bvOfSArmy = i;
        Vector<SUnit> autoUnits = new Vector<SUnit>();
        if (i <= 0) {
            return autoUnits;
        }
        int maxLight = Integer.parseInt(CampaignMain.cm.getConfig("MaxLightArtillery"));
        int maxMedium = Integer.parseInt(CampaignMain.cm.getConfig("MaxMediumArtillery"));
        int maxHeavy = Integer.parseInt(CampaignMain.cm.getConfig("MaxHeavyArtillery"));
        int maxAssault = Integer.parseInt(CampaignMain.cm.getConfig("MaxAssaultArtillery"));
        int[] maxNumOfEachWeight = new int[]{maxLight, maxMedium, maxHeavy, maxAssault};
        int bvForLight = Integer.parseInt(CampaignMain.cm.getConfig("BVForLightArtillery"));
        int bvForMedium = Integer.parseInt(CampaignMain.cm.getConfig("BVForMediumArtillery"));
        int bvForHeavy = Integer.parseInt(CampaignMain.cm.getConfig("BVForHeavyArtillery"));
        int bvForAssault = Integer.parseInt(CampaignMain.cm.getConfig("BVForAssaultArtillery"));
        int[] bvForEachWeight = new int[]{bvForLight, bvForMedium, bvForHeavy, bvForAssault};
        boolean topToBottom = Boolean.valueOf(CampaignMain.cm.getConfig("HeaviestArtilleryFirst"));
        int[] loadOrder = new int[]{0, 1, 2, 3};
        loadOrder[0] = 1;
        int[] remainingWeights = new int[]{1, 2, 3};
        int preferedWeight = loadOrder[0];
        int currentWeight = 0;
        for (int j = 0; j < 3; ++j) {
            if (currentWeight == preferedWeight) {
                // empty if block
            }
            remainingWeights[j] = ++currentWeight;
            ++currentWeight;
        }
        if (topToBottom) {
            loadOrder[1] = remainingWeights[2];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[0];
        } else {
            loadOrder[1] = remainingWeights[0];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[2];
        }
        for (int k = 0; k < 4; ++k) {
            int currWeight = loadOrder[k];
            int bvForCurrWeight = bvForEachWeight[currWeight];
            int maxNumOfCurrWeight = maxNumOfEachWeight[currWeight];
            for (int numOfCurrWeight = 0; bvOfSArmy >= bvForCurrWeight && numOfCurrWeight < maxNumOfCurrWeight; bvOfSArmy -= bvForCurrWeight, ++numOfCurrWeight) {
                autoUnits.add(this.makeNewArtilleryPiece(currWeight));
            }
        }
        return autoUnits;
    }

    public SUnit makeNewArtilleryPiece(int i) {
        String filename = "";
        filename = 0 == i ? CampaignMain.cm.getConfig("LightArtilleryFile") : (1 == i ? CampaignMain.cm.getConfig("MediumArtilleryFile") : (2 == i ? CampaignMain.cm.getConfig("HeavyArtilleryFile") : CampaignMain.cm.getConfig("AssaultArtilleryFile")));
        SUnit cm = new SUnit("autoassigned unit", filename, 0);
        return cm;
    }

    public Vector getUnits() {
        return this.theUnits;
    }

    public int getBV() {
        int toReturn = 0;
        Enumeration e = this.getUnits().elements();
        while (e.hasMoreElements()) {
            SUnit currUnit = (SUnit)e.nextElement();
            toReturn += currUnit.getBV();
        }
        return toReturn;
    }

    public String toString(String delimiter) {
        String result = "";
        Vector v = this.getUnits();
        try {
            v.elements();
        }
        catch (Exception e) {
            MMServ.mmlog.mainLog("AUTOARMY UNITS WERE NULL");
        }
        Enumeration en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            SUnit currUnit = (SUnit)en.nextElement();
            result = result + currUnit.getWeightclass() + delimiter;
        }
        return result;
    }
}

