/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;

public class PilotQueues {
    private Vector queues = new Vector();
    private int baseGunnery = 4;
    private int basePiloting = 5;
    private String factionString = "";

    public PilotQueues(int baseGunnery, int basePiloting) {
        for (int i = 0; i <= 4; ++i) {
            LinkedList v = new LinkedList();
            this.queues.add(i, v);
        }
        this.baseGunnery = baseGunnery;
        this.basePiloting = basePiloting;
        this.factionString = "";
    }

    public PilotQueues() {
    }

    public void addPilot(int type, SPilot p, boolean skipSkillChange) {
        if (p.getName().equalsIgnoreCase("Vacant")) {
            p = null;
            return;
        }
        p.setCurrentFaction(this.factionString);
        if (p.getSkills().has(12) && !p.getWeapon().equals("Default")) {
            Iterator ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist")) continue;
                p.getSkills().remove(skill);
                break;
            }
        }
        if (!skipSkillChange) {
            this.addPilot(type, p);
        } else {
            ((LinkedList)this.queues.get(type)).addLast(p);
        }
    }

    public void addPilot(int type, SPilot p) {
        if (p.getName().equalsIgnoreCase("Vacant")) {
            p = null;
            return;
        }
        p.setCurrentFaction(this.factionString);
        if (p.getSkills().has(12) && !p.getWeapon().equals("Default")) {
            Iterator ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist")) continue;
                p.getSkills().remove(skill);
                break;
            }
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("ReduceSkillsInQue")).booleanValue()) {
            int rnd = CampaignMain.cm.getR().nextInt(100);
            if (rnd >= Integer.parseInt(CampaignMain.cm.getConfig("ClearXPInQue"))) {
                p.setExperience(0);
            }
            boolean gunnerAdjust = false;
            boolean pilotAdjust = false;
            if (p.getGunnery() < this.getBaseGunnery()) {
                gunnerAdjust = true;
            }
            if (p.getPiloting() < this.basePiloting) {
                pilotAdjust = true;
            }
            if (!gunnerAdjust && !pilotAdjust) {
                int i;
                if (p.getGunnery() > this.getBaseGunnery()) {
                    int i2 = CampaignMain.cm.getR().nextInt(100);
                    if (i2 >= 50) {
                        p.setGunnery(this.getBaseGunnery());
                    }
                } else if (p.getPiloting() > this.basePiloting && (i = CampaignMain.cm.getR().nextInt(100)) >= 50) {
                    p.setPiloting(this.basePiloting);
                }
            } else if (gunnerAdjust && !pilotAdjust) {
                p.setGunnery(p.getGunnery() + 1);
            } else if (!gunnerAdjust && pilotAdjust) {
                if (p.getPiloting() < this.basePiloting - 1 && p.getGunnery() > this.getBaseGunnery()) {
                    p.setGunnery(this.getBaseGunnery());
                    p.setPiloting(this.basePiloting);
                } else {
                    p.setPiloting(p.getPiloting() + 1);
                }
            } else if (gunnerAdjust && pilotAdjust) {
                if (p.getGunnery() + 1 == p.getPiloting()) {
                    int i = CampaignMain.cm.getR().nextInt(100);
                    if (i >= 50) {
                        p.setPiloting(p.getPiloting() + 1);
                    } else {
                        p.setGunnery(p.getGunnery() + 1);
                    }
                } else if (p.getGunnery() < p.getPiloting()) {
                    p.setGunnery(p.getGunnery() + 1);
                } else {
                    p.setPiloting(p.getPiloting() + 1);
                }
            }
        }
        ((LinkedList)this.queues.get(type)).addLast(p);
    }

    public void loadPilot(int type, SPilot p) {
        p.setCurrentFaction(this.factionString);
        ((LinkedList)this.queues.get(type)).addLast(p);
    }

    public SPilot getPilot(int type) {
        LinkedList list = (LinkedList)this.queues.get(type);
        while (list.size() < 10) {
            this.addPilot(type, this.rollNewPilot(type), true);
        }
        return (SPilot)list.removeFirst();
    }

    private SPilot rollNewPilot(int unitType) {
        int gunnery = this.getBaseGunnery();
        int piloting = this.getBasePiloting();
        boolean increasedSkillChance = false;
        boolean doLoop = true;
        int rnd = CampaignMain.cm.getR().nextInt(100);
        boolean allowGreenPilots = Boolean.valueOf(CampaignMain.cm.getConfig("AllowGreenPilots"));
        if (rnd < 10 && allowGreenPilots) {
            while (rnd < 10 && doLoop) {
                if (rnd < 5) {
                    ++gunnery;
                    increasedSkillChance = true;
                } else if (rnd >= 5 && rnd < 10) {
                    ++piloting;
                    increasedSkillChance = true;
                }
                rnd = CampaignMain.cm.getR().nextInt(100);
                doLoop = Boolean.valueOf(CampaignMain.cm.getConfig("WizwomPilots"));
            }
        } else {
            while (rnd > 90 && doLoop) {
                if (rnd >= 90 && rnd < 95) {
                    --piloting;
                } else if (rnd >= 95) {
                    --gunnery;
                }
                rnd = CampaignMain.cm.getR().nextInt(100);
                doLoop = Boolean.valueOf(CampaignMain.cm.getConfig("WizwomPilots"));
            }
        }
        SPilot result = new SPilot(this.getRandomPilotName(), gunnery, piloting);
        result.setCurrentFaction(this.factionString);
        rnd = CampaignMain.cm.getR().nextInt(100);
        int skillChance = Integer.parseInt(CampaignMain.cm.getConfig("BornSkillChance"));
        if (increasedSkillChance) {
            skillChance = 100;
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("PilotSkills")).booleanValue() && rnd <= skillChance) {
            SPilotSkill skill = CampaignMain.cm.getRandomSkill(result, unitType);
            if (skill instanceof TraitSkill) {
                ((TraitSkill)skill).assignTrait(result);
            }
            skill.addToPilot(result);
            skill.modifyPilot(result);
        }
        return result;
    }

    public int getQueueSize(int type) {
        return ((LinkedList)this.queues.get(type)).size();
    }

    public void listDispossessedPilots(String user) {
        String Desc = "House bases " + this.getBaseGunnery() + "/" + this.getBasePiloting() + "<br>";
        for (int type = 0; type <= 4; ++type) {
            Desc = Desc + "<FONT SIZE=+2>Queue for " + SUnit.getTypeClassDesc(type) + ":</FONT><OL>";
            LinkedList l = (LinkedList)this.queues.get(type);
            for (int i = 0; i < l.size(); ++i) {
                SPilot pil = (SPilot)l.get(i);
                Desc = Desc + "<LI>" + pil.getName() + "(" + pil.getGunnery() + "/" + pil.getPiloting() + ") [" + pil.getSkillString(true) + "]</LI>";
            }
            Desc = Desc + "</OL>";
        }
        CampaignMain.cm.toUser(Desc, user, true);
    }

    public void setFactionString(String s) {
        this.factionString = s;
    }

    public String getFactionString() {
        return this.factionString;
    }

    public int getBasePiloting() {
        return this.basePiloting;
    }

    public int getBaseGunnery() {
        return this.baseGunnery;
    }

    public void setBasePiloting(int piloting) {
        this.basePiloting = piloting;
    }

    public void setBaseGunnery(int gunnery) {
        this.baseGunnery = gunnery;
    }

    public String getRandomPilotName() {
        String result = "Noelle";
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCommonPilotNameFileOnly")).booleanValue()) {
            result = SUnit.getRandomPilotName(CampaignMain.cm.getR());
        } else {
            try {
                File configFile = new File("./data/pilotnames/" + this.factionString + "Pilotnames.txt");
                FileInputStream fis = new FileInputStream(configFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int names = Integer.parseInt(dis.readLine());
                int pilotid = CampaignMain.cm.getR().nextInt(names);
                while (dis.ready()) {
                    String line = dis.readLine();
                    if (pilotid <= 0) {
                        return line;
                    }
                    --pilotid;
                }
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured while retreiving a name from the " + this.factionString + " Pilotnames File! Tried using Pilotnames.txt instead.");
                result = SUnit.getRandomPilotName(CampaignMain.cm.getR());
            }
        }
        return result;
    }

    public LinkedList getPilotQueue(int type) {
        LinkedList list = (LinkedList)this.queues.get(type);
        return list;
    }
}

