/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.AdvanceTerrain;
import common.CampaignData;
import common.Continent;
import common.Influences;
import common.PlanetEnvironment;
import common.util.Position;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.NewbiePlanet;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnitFactory;
import server.campaign.data.TimeUpdatePlanet;
import server.campaign.dataFiles.SPlanetData;

public class SPlanet
extends TimeUpdatePlanet
implements Serializable,
Comparable {
    private SPlanetData myData = new SPlanetData();

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this instanceof NewbiePlanet) {
            result.append("[N]");
        }
        result.append("PL#");
        result.append(this.getName());
        result.append("#");
        result.append(this.getCompProduction());
        if (this.getUnitFactories() != null) {
            result.append("#" + this.getUnitFactories().size());
            for (int i = 0; i < this.getUnitFactories().size(); ++i) {
                SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
                result.append("#" + MF.toString());
            }
        } else {
            result.append("#0");
        }
        result.append("#" + this.getPosition().getX());
        result.append("#" + this.getPosition().getY());
        result.append("#");
        for (SHouse next : this.getInfluence().getHouses()) {
            result.append(next.getName());
            result.append("$");
            result.append(this.getInfluence().getInfluence(next.getId()));
            result.append("$");
        }
        result.append("#");
        result.append(this.getEnvironments().size());
        result.append("#");
        Iterator it = this.getEnvironments().iterator();
        while (it.hasNext()) {
            Continent t = (Continent)it.next();
            result.append(t.getSize());
            result.append("#");
            result.append(t.getEnvironment().getId());
            result.append("#");
            if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) continue;
            AdvanceTerrain aTerrain = new AdvanceTerrain();
            aTerrain = (AdvanceTerrain)this.getAdvanceTerrain().get(new Integer(t.getEnvironment().getId()));
            if (aTerrain == null) {
                aTerrain = new AdvanceTerrain();
            }
            if (aTerrain.getDisplayName().length() <= 1) {
                result.append(t.getEnvironment().getName());
            } else {
                result.append(aTerrain.getDisplayName());
            }
            result.append("#");
            result.append(aTerrain.getXSize());
            result.append("#");
            result.append(aTerrain.getYSize());
            result.append("#");
            result.append(aTerrain.isStaticMap());
            result.append("#");
            result.append(aTerrain.getXBoardSize());
            result.append("#");
            result.append(aTerrain.getYBoardSize());
            result.append("#");
            result.append(aTerrain.getLowTemp());
            result.append("#");
            result.append(aTerrain.getHighTemp());
            result.append("#");
            result.append(aTerrain.getGravity());
            result.append("#");
            result.append(aTerrain.isVacuum());
            result.append("#");
            result.append(aTerrain.getNightChance());
            result.append("#");
            result.append(aTerrain.getNightTempMod());
            result.append("#");
            result.append(aTerrain.getStaticMapName());
            result.append("#");
        }
        if (this.getDescription().equals("")) {
            result.append(" ");
        } else {
            result.append(this.getDescription());
        }
        result.append("#");
        result.append(this.getBaysProvided());
        result.append("#");
        result.append(this.isConquerable());
        result.append("#");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        result.append(sdf.format(this.getLastChanged()));
        result.append("#");
        result.append(this.getId());
        result.append("#");
        result.append(this.getMapSize().width);
        result.append("#");
        result.append(this.getMapSize().height);
        result.append("#");
        result.append(this.getBoardSize().width);
        result.append("#");
        result.append(this.getBoardSize().height);
        result.append("#");
        result.append(this.getTemp().width);
        result.append("#");
        result.append(this.getTemp().height);
        result.append("#");
        result.append(this.getGravity());
        result.append("#");
        result.append(this.isVacuum());
        result.append("#");
        result.append(this.getNightChance());
        result.append("#");
        result.append(this.getNightTempMod());
        result.append("#");
        result.append(this.getMyData().getMinPlanetOwnerShip());
        return result.toString();
    }

    public String fromString(String s, Random r, CampaignData data) {
        MMServ.mmlog.mainLog(s);
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "#");
        this.setName(ST.nextToken());
        this.setCompProduction(Integer.parseInt(ST.nextToken()));
        int hasMF = Integer.parseInt((String)ST.nextElement());
        for (int i = 0; i < hasMF; ++i) {
            SUnitFactory mft = new SUnitFactory();
            mft.fromString((String)ST.nextElement(), this, r);
            this.getUnitFactories().add(mft);
        }
        this.setPosition(new Position(Double.parseDouble((String)ST.nextElement()), Double.parseDouble((String)ST.nextElement())));
        int Infcount = 0;
        try {
            HashMap<Integer, Integer> influence = new HashMap<Integer, Integer>();
            StringTokenizer influences = new StringTokenizer((String)ST.nextElement(), "$");
            while (influences.hasMoreElements()) {
                String HouseName = (String)influences.nextElement();
                SHouse h = (SHouse)data.getHouseByName(HouseName);
                Integer HouseInf = new Integer((String)influences.nextElement());
                Infcount += HouseInf.intValue();
                if (h != null) {
                    influence.put(new Integer(h.getId()), HouseInf);
                    continue;
                }
                MMServ.mmlog.errLog("House not found: " + HouseName);
            }
            this.setInfluence(new Influences(influence));
        }
        catch (RuntimeException ex) {
            MMServ.mmlog.errLog("Problem on Planet: " + this.getName());
            MMServ.mmlog.errLog(ex);
        }
        if (ST.hasMoreElements()) {
            int Envs = Integer.parseInt(ST.nextToken());
            for (int i = 0; i < Envs; ++i) {
                Continent PE2 = new Continent(Integer.parseInt(ST.nextToken()), data.getTerrain(Integer.parseInt(ST.nextToken())));
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                    AdvanceTerrain aTerrain = new AdvanceTerrain();
                    aTerrain.setDisplayName(ST.nextToken());
                    aTerrain.setXSize(Integer.parseInt(ST.nextToken()));
                    aTerrain.setYSize(Integer.parseInt(ST.nextToken()));
                    aTerrain.setStaticMap(Boolean.valueOf(ST.nextToken()));
                    aTerrain.setXBoardSize(Integer.parseInt(ST.nextToken()));
                    aTerrain.setYBoardSize(Integer.parseInt(ST.nextToken()));
                    aTerrain.setLowTemp(Integer.parseInt(ST.nextToken()));
                    aTerrain.setHighTemp(Integer.parseInt(ST.nextToken()));
                    aTerrain.setGravity(Double.parseDouble(ST.nextToken()));
                    aTerrain.setVacuum(Boolean.valueOf(ST.nextToken()));
                    aTerrain.setNightChance(Integer.parseInt(ST.nextToken()));
                    aTerrain.setNightTempMod(Integer.parseInt(ST.nextToken()));
                    aTerrain.setStaticMapName(ST.nextToken());
                    this.getAdvanceTerrain().put(new Integer(PE2.getEnvironment().getId()), aTerrain);
                }
                this.getEnvironments().add(PE2);
            }
        }
        if (ST.hasMoreElements()) {
            this.setDescription(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.setBaysProvided(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.setConquerable(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                this.setTimestamp(sdf.parse(ST.nextToken()));
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("The following excepion is not critical, but will cause useless bandwith usage: please fix!");
                MMServ.mmlog.errLog(ex);
                this.setTimestamp(new Date(0L));
            }
        } else {
            this.setTimestamp(new Date(0L));
        }
        if (ST.hasMoreElements()) {
            this.setId(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            int x = Integer.parseInt(ST.nextToken());
            int y = Integer.parseInt(ST.nextToken());
            this.setMapSize(new Dimension(x, y));
        }
        if (ST.hasMoreElements()) {
            int x = Integer.parseInt(ST.nextToken());
            int y = Integer.parseInt(ST.nextToken());
            this.setBoardSize(new Dimension(x, y));
        }
        if (ST.hasMoreElements()) {
            int x = Integer.parseInt(ST.nextToken());
            int y = Integer.parseInt(ST.nextToken());
            this.setTemp(new Dimension(x, y));
        }
        if (ST.hasMoreElements()) {
            this.setGravity(Double.parseDouble(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.setVacuum(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            int chance = Integer.parseInt(ST.nextToken());
            int mod = Integer.parseInt(ST.nextToken());
            this.setNightChance(chance);
            this.setNightTempMod(mod);
        }
        if (ST.hasMoreElements()) {
            this.setMinPlanetOwnerShip(Integer.parseInt(ST.nextToken()));
        }
        this.setOwner(this.checkOwner());
        return s;
    }

    public SPlanet() {
        super(CampaignMain.cm.getData().getUnusedPlanetID(), "", new Position(0.0, 0.0), null);
        this.setTimestamp(new Date(0L));
    }

    public SPlanet(int id, String name, Influences flu, int income, int CompProd, double xcood, double ycood) {
        super(id, name, new Position(xcood, ycood), flu);
        this.setCompProduction(CompProd);
        this.setTimestamp(new Date(0L));
    }

    public SUnitFactory getRandomUnitFactory() {
        if (this.getUnitFactories().size() == 0) {
            return null;
        }
        return (SUnitFactory)this.getUnitFactories().get(CampaignMain.cm.getR().nextInt(this.getUnitFactories().size()));
    }

    public SUnitFactory getBestUnitFactory() {
        if (this.getUnitFactories().size() == 0) {
            return null;
        }
        SUnitFactory result = null;
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            if (result == null) {
                result = MF;
                continue;
            }
            if (MF.getWeightclass() > result.getWeightclass()) {
                result = MF;
                continue;
            }
            if (MF.getWeightclass() != result.getWeightclass() || MF.getBestTypeProducable() >= result.getBestTypeProducable()) continue;
            result = MF;
        }
        return result;
    }

    public Vector getFactoriesOfWeighclass(int weightclass) {
        Vector<SUnitFactory> result = new Vector<SUnitFactory>();
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            if (MF.getWeightclass() != weightclass) continue;
            result.add(MF);
        }
        return result;
    }

    public SUnitFactory getRandomFactoryOfSize(int weightclass, int type_id) {
        Vector possible = this.getFactoriesOfWeighclass(weightclass);
        Vector<SUnitFactory> result = new Vector<SUnitFactory>();
        for (int i = 0; i < possible.size(); ++i) {
            SUnitFactory MF = (SUnitFactory)possible.elementAt(i);
            if (!MF.canProduce(type_id)) continue;
            result.add(MF);
        }
        return (SUnitFactory)result.elementAt(CampaignMain.cm.getR().nextInt(result.size()));
    }

    public int doGainInfluence(SHouse winner, SHouse looser, int amount) {
        if (!winner.canConquerPlanets()) {
            return 0;
        }
        int infgain = this.getInfluence().moveInfluence(winner, looser, amount);
        winner.updated();
        looser.updated();
        this.updated();
        this.setOwner(this.checkOwner());
        return infgain;
    }

    public String addInfluenceFor(SHouse h, int amount, Hashtable possibleDefenders) {
        if (possibleDefenders.size() == 0) {
            return "There was no one to defend against you, didn't HQ tell you that?";
        }
        String result = "";
        SHouse hs2 = h;
        Influences inf = this.getInfluence();
        int enemyinfluence = 0;
        for (SHouse hs2 : inf.getHouses()) {
            if (hs2.equals(h) || hs2.getActMembers().size() <= 0 || possibleDefenders.get(hs2.getName()) == null) continue;
            enemyinfluence += inf.getInfluence(hs2.getId());
        }
        if (enemyinfluence != 0) {
            for (int i = amount; i > 0; --i) {
                Iterator it = inf.getHouses().iterator();
                int ran = CampaignMain.cm.getR().nextInt(enemyinfluence) + 1;
                while (ran > 0 && it.hasNext()) {
                    hs2 = (SHouse)it.next();
                    if (hs2.equals(h) || hs2.getActMembers().size() <= 0 || possibleDefenders.get(hs2.getName()) == null) continue;
                    ran -= inf.getInfluence(hs2.getId());
                }
                this.doGainInfluence(h, hs2, amount);
                result = "<font color=\"" + h.getHouseColor() + "\">" + h.getName() + "</font> gained " + amount + "% control of " + this.getName() + ". Control has been taken from <font color=\"" + hs2.getHouseColor() + "\">" + hs2.getName() + "</font>";
            }
        }
        return result;
    }

    public Vector getDefenders(SHouse Attacker) {
        Vector<SHouse> result = new Vector<SHouse>();
        for (SHouse h : this.getInfluence().getHouses()) {
            if (h.equals(Attacker) && !Attacker.isInHouseAttacks()) continue;
            result.add(h);
        }
        return result;
    }

    public boolean equals(SPlanet p) {
        return p.getId() == this.getId();
    }

    public void tick(boolean real, int refreshminiticks) {
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            int total = 0;
            if (MF.canProduce(0)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(1)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(2)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(3)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(4)) {
                total += refreshminiticks;
            }
            MF.tick(real, total);
        }
    }

    private HashSet whichHouses(HashSet planets, int minvalue) {
        HashSet<SHouse> result = new HashSet<SHouse>();
        Iterator i = planets.iterator();
        Iterator e = null;
        while (i.hasNext()) {
            SPlanet p = (SPlanet)i.next();
            for (SHouse h : p.getInfluence().getHouses()) {
                if (p.getInfluence().getInfluence(h.getId()) < minvalue) continue;
                result.add(h);
            }
        }
        return result;
    }

    private String generateOwnerNeighbours(HashSet closePlanets, HashSet farPlanets) {
        String result = "";
        HashSet factionsFar = this.whichHouses(farPlanets, 25);
        HashSet factionsClose = this.whichHouses(closePlanets, 25);
        factionsFar.remove(this.getOwner());
        factionsClose.remove(this.getOwner());
        if (!factionsFar.isEmpty() || !factionsClose.isEmpty()) {
            HashSet factions;
            if (!factionsFar.isEmpty()) {
                factions = factionsClose;
                result = result + this.getName() + " is close to the border, and therefore often target of attacks by ";
            } else {
                factions = factionsFar;
                result = result + this.getName() + " lies in far from the border, but not far enough. ";
                result = result + "On rare occasions it was quickly and speedily raided by ";
            }
            Iterator i = factions.iterator();
            int count = 0;
            while (i.hasNext()) {
                result = result + ((SHouse)i.next()).getName();
                if (++count >= factions.size()) continue;
                result = result + (count == factions.size() - 1 ? " and " : ", ");
            }
            result = result + ". <br>";
            result = result + "But the proximity to the territory of the opponent makes ";
            result = result + "it also a good starting pointing for operation versus these factions. <br>";
        } else {
            result = result + "Deep in the " + this.getOwner() + "-territory it lies ";
            result = result + "well guarded against all the -wanne-be-first-lords-of-the-star-league- ";
            result = result + "(and we all know there is only one). <br>";
        }
        return result;
    }

    private String generateAlienNeighbours(HashSet closePlanets, HashSet farPlanets) {
        String result = "";
        if (!farPlanets.isEmpty() || !closePlanets.isEmpty()) {
            HashSet factions;
            if (!closePlanets.isEmpty()) {
                factions = this.whichHouses(closePlanets, 25);
                result = result + this.getName() + " is close to the border, and therefore often target of attacks by ";
            } else {
                factions = this.whichHouses(farPlanets, 25);
                result = result + this.getName() + " lies far from the border, but not far enough. ";
                result = result + "On rare occasions it was quickly raided by ";
            }
            Iterator i = factions.iterator();
            int count = 0;
            while (i.hasNext()) {
                result = result + ((SHouse)i.next()).getName();
                if (++count >= factions.size()) continue;
                result = result + (count == factions.size() - 1 ? " and " : ", ");
            }
            result = result + ". <br>";
            result = result + "But the proximity to the opponent's territory also makes ";
            result = result + "it a good starting pointing for operations against these factions.<br>";
        }
        return result;
    }

    public String getStatus(SPlayer requestor) {
        int raidDist = 30;
        double RDistSq = raidDist * raidDist;
        boolean reqIsInOwnerHouse = false;
        if (this.getOwner() != null) {
            reqIsInOwnerHouse = this.getOwner().equals(requestor.getMyHouse());
        }
        String bnd = requestor.getMyHouse().getScoutSource();
        String result = "<html><body><font color=\"red\">" + bnd + " CONFIDENTIAL </font> <br>";
        result = result + this.getLongDescription(false);
        result = result + "<hr>";
        Collection neighbours = CampaignMain.cm.getData().getAllPlanets();
        HashSet<SPlanet> closeNeighbours = new HashSet<SPlanet>();
        HashSet farNeighbours = new HashSet();
        for (SPlanet p : neighbours) {
            double distSq;
            if (p == this || !((distSq = this.getPosition().distanceSq(p.getPosition())) < RDistSq)) continue;
            closeNeighbours.add(p);
        }
        result = result + (reqIsInOwnerHouse ? this.generateOwnerNeighbours(closeNeighbours, farNeighbours) : this.generateAlienNeighbours(closeNeighbours, farNeighbours));
        result = result + "</body></html>";
        return result;
    }

    public String getSmallStatus(boolean useHTML) {
        String result = "";
        result = useHTML ? this.getNameAsLink() : this.getName();
        if (useHTML) {
            result = this.getOwner() != null ? "<b><font color=\"" + this.getOwner().getHouseColor() + "\">" + result + "</font></b>" : "<b><font color=\"000000\">" + result + "</font></b>";
        }
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            result = result + " [" + MF.getSize() + "," + MF.getFounder() + "," + MF.getTypeString() + "]";
        }
        result = result + ":";
        Iterator it = this.getInfluence().getHouses().iterator();
        while (it.hasNext()) {
            SHouse h = (SHouse)it.next();
            result = result + h.getName() + "(" + this.getInfluence().getInfluence(h.getId()) + "%)";
            if (it.hasNext()) {
                result = result + ", ";
                continue;
            }
            if (!useHTML) continue;
            result = result + "<br>";
        }
        return result;
    }

    public SHouse checkOwner() {
        if (this.getInfluence() == null) {
            MMServ.mmlog.errLog("getINF == null Planet: " + this.getName());
            return null;
        }
        SHouse h = null;
        Integer houseID = this.getInfluence().getOwner();
        if (houseID == null) {
            return null;
        }
        h = (SHouse)CampaignMain.cm.getData().getHouse(houseID);
        if (this.getInfluence().getInfluence(houseID) < this.getMinPlanetOwnerShip()) {
            return null;
        }
        return h;
    }

    public boolean isValidDefender(SHouse h) {
        return this.getInfluence().getInfluence(h.getId()) > 0;
    }

    public String getShortDescription(boolean withTerrain) {
        String result = this.getName();
        if (withTerrain) {
            Continent p = this.getEnvironments().getBiggestEnvironment();
            PlanetEnvironment pe = p.getEnvironment();
            if (pe != null) {
                result = result + " " + pe.toImageDescription();
            }
            if (this.getUnitFactories().size() > 0) {
                for (int i = 0; i < this.getUnitFactories().size(); ++i) {
                    SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
                    result = result + MF.getIcons();
                }
            }
            result = pe != null && this.getEnvironments().getTotalEnivronmentPropabilities() > 0 ? result + " (" + Math.round((double)p.getSize() * 100.0 / (double)this.getEnvironments().getTotalEnivronmentPropabilities()) + "% correct)" : result + " (100% correct)";
        }
        return result;
    }

    public SHouse getOwner() {
        if (this.getMyData().getOwner() == null) {
            this.checkOwner();
        }
        if (this.getMyData().getOwner() == null) {
            return null;
        }
        return SHouse.getHouse(this.getMyData().getOwner());
    }

    public void setOwner(SHouse owner) {
        if (this.getMyData().getOwner() != null) {
            SHouse.getHouse(this.getMyData().getOwner()).removePlanet(this);
        }
        if (owner != null) {
            this.getMyData().setOwner(owner.getMySHouseData());
        } else {
            this.getMyData().setOwner(null);
        }
        if (this.getMyData().getOwner() != null) {
            SHouse.getHouse(this.getMyData().getOwner()).addPlanet(this);
        }
    }

    public SPlanetData getMyData() {
        return this.myData;
    }

    public String getNameAsColoredLink() {
        String colorString = "";
        SHouse owner = this.getOwner();
        colorString = owner == null ? "black" : owner.getHouseColor();
        String toReturn = "<font color=\"" + colorString + "\">" + this.getNameAsLink() + "</font>";
        return toReturn;
    }

    public int getMinPlanetOwnerShip() {
        int ownership = this.myData.getMinPlanetOwnerShip();
        if (ownership == -1) {
            ownership = Integer.parseInt(CampaignMain.cm.getConfig("MinPlanetOwnerShip"));
        }
        return ownership;
    }

    public void setMinPlanetOwnerShip(int ownership) {
        this.myData.setMinPlanetOwnerShip(ownership);
    }
}

