/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.UnitFactory;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SUnit;
import server.campaign.pilot.SPilot;
import server.campaign.util.TimeZoneData;
import server.campaign.util.UnitHistoryKeeper;

public class SUnitFactory
extends UnitFactory
implements Serializable {
    private SPlanet planet;

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("MF*");
        result.append(this.getName());
        result.append("*");
        result.append(this.getSize());
        result.append("*");
        result.append(this.getFounder());
        result.append("*");
        result.append(this.getTicksUntilRefresh());
        result.append("*");
        result.append(this.getRefreshSpeed());
        if (this.getTimeZones().size() > 0) {
            result.append("*");
            result.append(this.getTimeZones().size());
            Enumeration e = this.getTimeZones().elements();
            while (e.hasMoreElements()) {
                TimeZoneData TZData = (TimeZoneData)e.nextElement();
                result.append("*" + TZData.toString());
            }
        }
        result.append("*");
        result.append(this.getType());
        result.append("*");
        result.append(this.isLocked());
        result.append("*");
        result.append(this.getProductionTable());
        return result.toString();
    }

    public String getIcons() {
        String sizeid = "";
        String result = "";
        int size = this.getWeightclass();
        if (size == 0) {
            sizeid = sizeid + "l";
        } else if (size == 1) {
            sizeid = sizeid + "m";
        } else if (size == 2) {
            sizeid = sizeid + "h";
        } else if (size == 3) {
            sizeid = sizeid + "a";
        }
        if (this.canProduce(0)) {
            sizeid = sizeid + "m";
        } else if (this.canProduce(1)) {
            sizeid = sizeid + "v";
        } else if (this.canProduce(2)) {
            sizeid = sizeid + "li";
        } else if (this.canProduce(4)) {
            sizeid = sizeid + "b";
        } else if (this.canProduce(3)) {
            sizeid = sizeid + "p";
        }
        result = result + "<img src=\"data/images/" + sizeid + ".gif\">";
        return result;
    }

    public void fromString(String s, SPlanet p, Random r) {
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "*");
        this.setName((String)ST.nextElement());
        this.setSize((String)ST.nextElement());
        this.setFounder((String)ST.nextElement());
        this.setTicksUntilRefresh(Integer.parseInt(ST.nextToken()));
        this.setRefreshSpeed(Integer.parseInt(ST.nextToken()));
        this.setTimeZones(new Hashtable());
        int TimeZonesCounter = 0;
        if (ST.hasMoreElements()) {
            TimeZonesCounter = Integer.parseInt((String)ST.nextElement());
        }
        for (int count = 0; count < TimeZonesCounter; ++count) {
            TimeZoneData TZData;
            String Data = ST.nextToken();
            if (Data.indexOf("~") != -1) {
                TZData = new TimeZoneData(Data);
                this.getTimeZones().put(TZData.getName(), TZData);
                continue;
            }
            TZData = new TimeZoneData();
            TZData.setName(Data);
            TZData.setPropability(Integer.parseInt(ST.nextToken()));
            this.getTimeZones().put(TZData.getName(), TZData);
        }
        if (ST.hasMoreElements()) {
            this.setType(Integer.parseInt(ST.nextToken()));
        } else {
            this.setType(BUILDMEK);
        }
        if (ST.hasMoreElements()) {
            this.setLock(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.setProductionTable(ST.nextToken());
        }
        this.setPlanet(p);
    }

    public SUnitFactory() {
    }

    public SUnitFactory(String Name2, SPlanet P, String Size, String Faction, Hashtable TimeZones, int ticksuntilrefresh, int refreshSpeed, int type) {
        this.setName(Name2);
        this.setPlanet(P);
        this.setSize(Size);
        this.setFounder(Faction);
        this.setTimeZones(TimeZones);
        this.setTicksUntilRefresh(ticksuntilrefresh);
        this.setRefreshSpeed(refreshSpeed);
        this.setType(type);
    }

    public SUnitFactory(String name, SPlanet planet, String size, String faction) {
        this.setName(name);
        this.setPlanet(planet);
        this.setSize(size);
        this.setFounder(faction);
        this.setType(0);
    }

    public String getConfig(String key) {
        return CampaignMain.cm.getConfig(key);
    }

    public void tick(boolean real, int miniticks) {
        this.addRefresh(-miniticks);
    }

    public SUnit getMechProduced(int type_id, SPilot pilot) {
        String MechConstructor = this.getFounder();
        if (!this.getProductionTable().equals("")) {
            MechConstructor = this.getProductionTable();
        }
        String Filename = "";
        TimeZoneData TZUsed = null;
        if (this.getTimeZones().size() > 0) {
            String timezone = "3025";
            Enumeration e = this.getTimeZones().keys();
            for (int time = CampaignMain.cm.getR().nextInt(100); time >= 0 && e.hasMoreElements(); time -= ((TimeZoneData)this.getTimeZones().get(timezone)).getPropability()) {
                timezone = (String)e.nextElement();
            }
            TZUsed = (TimeZoneData)this.getTimeZones().get(timezone);
            MMServ.mmlog.mainLog("Timezone used: " + timezone + " Planet: " + this.getPlanet().getName());
        } else {
            TZUsed = new TimeZoneData();
            TZUsed.setName("3025");
            TZUsed.setPropability(100);
        }
        String producer = "Built by ";
        producer = this.getPlanet().getOwner() != null ? producer + this.getPlanet().getOwner().getName() : producer + this.getFounder();
        producer = this.getPlanet().getName() == null ? producer + " from spare parts stockpiles" : producer + " on " + this.getPlanet().getName();
        String unitSize = this.getSize();
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyOneVehicleSize")).booleanValue() && type_id == 1) {
            unitSize = SUnit.getWeightClassDesc(CampaignMain.cm.getR().nextInt(4));
        }
        Filename = BuildTable.getUnitFilename(MechConstructor, unitSize, type_id, TZUsed);
        MMServ.mmlog.mainLog(this.getSize() + MechConstructor);
        MMServ.mmlog.mainLog("Filename: " + Filename);
        MMServ.mmlog.mainLog("Producer: " + producer);
        MMServ.mmlog.mainLog("Filename: " + Filename);
        SUnit cm = new SUnit(producer, Filename, this.getWeightclass());
        producer = this.getPlanet().getOwner() != null ? this.getPlanet().getOwner().getName() : this.getFounder();
        UnitHistoryKeeper.addProductionEntry(cm.getId(), this.getName(), this.getPlanet().getName(), producer, cm.getUnitFilename());
        cm.setPilot(pilot, true);
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseCalculatedCosts")).booleanValue()) {
            if (this.getWeightclass() == 0) {
                this.setTicksUntilRefresh(Integer.parseInt(this.getConfig("LightRefresh")) * 100 / this.getRefreshSpeed());
            } else if (this.getWeightclass() == 1) {
                this.setTicksUntilRefresh(Integer.parseInt(this.getConfig("MediumRefresh")) * 100 / this.getRefreshSpeed());
            } else if (this.getWeightclass() == 2) {
                this.setTicksUntilRefresh(Integer.parseInt(this.getConfig("HeavyRefresh")) * 100 / this.getRefreshSpeed());
            } else if (this.getWeightclass() == 3) {
                this.setTicksUntilRefresh(Integer.parseInt(this.getConfig("AssaultRefresh")) * 100 / this.getRefreshSpeed());
            }
        }
        return cm;
    }

    public void addRefresh(int i) {
        if (this.getTicksUntilRefresh() < 0) {
            return;
        }
        this.setTicksUntilRefresh(this.getTicksUntilRefresh() + i);
        if (this.getTicksUntilRefresh() < 0) {
            this.setTicksUntilRefresh(0);
        }
    }

    public SPlanet getPlanet() {
        return this.planet;
    }

    public void setPlanet(SPlanet planet) {
        this.planet = planet;
    }
}

