/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.comm;

import client.MWClient;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.NormalHouse;
import server.campaign.comm.CampaignCommand;

public class HouseStatus
extends CampaignCommand {
    public static final String prefix = "HS";

    public HouseStatus(MWClient mwclient) {
        super(prefix);
        this.setClient(mwclient);
    }

    public HouseStatus(MMServ server) {
        super(prefix);
        this.setServer(server);
    }

    public void parseArguments(String s) {
        super.parseArguments(s);
        if (!this.hasError()) {
            String result = "HS|";
            for (NormalHouse normalHouse : CampaignMain.cm.getData().getAllHouses()) {
                result = result + normalHouse.getHouseColor() + "#" + normalHouse.getName() + "#" + normalHouse.getPlanets().size() + "#" + ((Vector)normalHouse.getMechs().elementAt(1)).size() + "#" + normalHouse.getMembers().size() + "|";
            }
            this.clientSend(result);
        }
    }

    public void parseReplyArgs(String s) {
        String result = "<h2>House Status</h2>";
        if (!this.hasError()) {
            try {
                StringTokenizer st = new StringTokenizer(s, "|");
                while (st.hasMoreTokens()) {
                    String faction = st.nextToken();
                    StringTokenizer h = new StringTokenizer(faction, "#");
                    result = result + "<FONT Color=\"" + h.nextToken() + "\">";
                    result = result + h.nextToken() + " has " + h.nextToken() + " Planets, " + h.nextToken() + " Light Meks and " + h.nextToken() + " Members. </font><br>";
                }
                this.mwclient.addToChat(result);
            }
            catch (Exception e) {
                MMServ.mmlog.errLog(e);
            }
        } else {
            this.mwclient.addToChat(this.getErrorMessage());
        }
    }

    public String toString() {
        return prefix;
    }
}

