/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class AcceptContractCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String offeringPlayerName = (String)command.nextElement();
        SPlayer offeringPlayer = CampaignMain.cm.getPlayer(offeringPlayerName);
        SPlayer claimingPlayer = CampaignMain.cm.getPlayer(Username);
        String claimingPlayerName = claimingPlayer.getName();
        ContractInfo info = null;
        boolean contractAccepted = false;
        for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
            info = (ContractInfo)CampaignMain.cm.getUnresolvedContracts().get(i);
            String receivingPlayerName = info.getPlayerName();
            if (CampaignMain.cm.getPlayer(receivingPlayerName) != claimingPlayer || info.getOfferingPlayer() != CampaignMain.cm.getPlayer(offeringPlayerName)) continue;
            MercHouse factionToSaveContract = (MercHouse)claimingPlayer.getMyHouse();
            factionToSaveContract.setContract(info, claimingPlayer);
            contractAccepted = true;
            CampaignMain.cm.getUnresolvedContracts().remove(i);
        }
        if (contractAccepted) {
            CampaignMain.cm.toUser("You have accepted the contract offered by " + offeringPlayerName + " and are now in the employ of " + offeringPlayer.getMyHouse().getName(), Username, true);
            CampaignMain.cm.toUser(claimingPlayerName + "has accepted your contract offer.", offeringPlayerName, true);
            int contractPay = info.getPayment();
            int immediatePay = contractPay / 2;
            claimingPlayer.addMoney(immediatePay);
            CampaignMain.cm.toUser("Received " + CampaignMain.cm.moneyOrFluMessage(true, true, immediatePay) + ". The remainder of your pay will be delivered upon contract completion.", Username, true);
            offeringPlayer.addMoney(0 - contractPay);
            CampaignMain.cm.toUser("You have spent " + CampaignMain.cm.moneyOrFluMessage(true, true, contractPay) + " to hire " + claimingPlayerName, offeringPlayerName, true);
        } else {
            CampaignMain.cm.toUser("You have no contract to accept from a player of the given name", Username, true);
        }
    }
}

