/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.CheckAttackThread;
import server.campaign.commands.Command;

public class ActivateCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (new Boolean(CampaignMain.cm.getConfig("CampaignLock")).booleanValue()) {
            CampaignMain.cm.toUser("The campaign is currently locked. Player activation is disabled until the campaign is unlocked. NOTE: Running games will resolve normally.", Username, true);
            return;
        }
        if (p.HasVacantUnitsInArmies()) {
            CampaignMain.cm.toUser("You may not go active with pilotless units!", Username, true);
            return;
        }
        try {
            if (!CampaignMain.cm.getServer().getServerVersion().substring(0, 5).equals(p.getPlayerClientVersion().substring(0, 5))) {
                MMServ.mmlog.modLog(Username + " failed to activate. Was using version " + p.getPlayerClientVersion() + " Server Version: " + CampaignMain.cm.getServer().getServerVersion());
                CampaignMain.cm.doSendModMail("NOTE", Username + " failed to activate. Was using version " + p.getPlayerClientVersion() + " Server Version: " + CampaignMain.cm.getServer().getServerVersion());
                CampaignMain.cm.toUser("You may not go active with an incompatible client version! Please switch to version " + CampaignMain.cm.getServer().getServerVersion() + "!", Username, true);
                return;
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error activating player. User reported client verson: " + p.getPlayerClientVersion() + " --- Stack Trace Follows.");
            MMServ.mmlog.errLog(ex);
        }
        if (p.hasEmptyArmies() || p.getArmies().size() == 0) {
            CampaignMain.cm.toUser("You may not go active with empty armies or no armies!", Username, true);
            return;
        }
        if (p.hasEnginedUnits()) {
            CampaignMain.cm.toUser("You may not activate with engine-disabled units in your armies.", Username, true);
            return;
        }
        if (!p.isActive()) {
            boolean hasUnmaintained = false;
            Enumeration<SArmy> e = p.getArmies().elements();
            Enumeration<Unit> f = null;
            while (e.hasMoreElements()) {
                SArmy currentArmy = e.nextElement();
                f = currentArmy.getUnits().elements();
                while (f.hasMoreElements()) {
                    Unit currentUnit = f.nextElement();
                    if (currentUnit.getStatus() != 3) continue;
                    hasUnmaintained = true;
                }
            }
            if (hasUnmaintained) {
                CampaignMain.cm.toUser("You may not send armies containing unmaintained units to the front lines!", Username, true);
                return;
            }
            p.setActive(true);
            p.setChickenCount(0);
            p.setOnlineSince(System.currentTimeMillis());
            CampaignMain.cm.toUser("<font color=\"black\">[!] You're on your way to the front lines.</font>", Username, true);
            CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
            int threadLenth = Integer.parseInt(CampaignMain.cm.getConfig("MinActiveTime")) * 1000;
            CheckAttackThread caThread = new CheckAttackThread(p, threadLenth);
            caThread.start();
        } else {
            CampaignMain.cm.toUser("You already are on active duty!", Username, true);
            CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
        }
    }
}

