/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.util.MuseumEntry;
import server.campaign.util.MuseumEntryKeeper;

public class AddToMuseumCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            int unitId = Integer.parseInt(command.nextToken());
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            if (p == null) {
                return;
            }
            if (CampaignMain.cm.useHibernate()) {
                if (p.getUnit(unitId) == null) {
                    CampaignMain.cm.toUser("You do not own that unit!", Username, true);
                    return;
                }
                if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
                    CampaignMain.cm.toUser("You may not add to your museum while you're in a game.", Username, true);
                    return;
                }
                if (p.getActivityStatus() >= 3) {
                    CampaignMain.cm.toUser("You may not add to your museum while you're active.", Username, true);
                    return;
                }
                p.removeUnit(unitId, true);
                MuseumEntry entry = MuseumEntry.getEntry(unitId, Username);
                MuseumEntryKeeper.addEntry(entry);
                CampaignMain.cm.toUser("The unit was added to your museum.", Username, true);
            } else {
                CampaignMain.cm.toUser("This server does not support Museums!", Username, true);
            }
        }
    }
}

