/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ArmyLowerLimiterCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            boolean limitsAllowed = new Boolean(CampaignMain.cm.getConfig("AllowLimiters"));
            if (!limitsAllowed) {
                CampaignMain.cm.toUser("Limits are disabled.", Username, true);
                return;
            }
            int armyid = Integer.parseInt((String)command.nextElement());
            if (command.hasMoreElements()) {
                int limit = Integer.parseInt(command.nextToken());
                SPlayer p = CampaignMain.cm.getPlayer(Username);
                if (p != null) {
                    if (p.isActive()) {
                        CampaignMain.cm.toUser("You cannot change limits while active.", Username, true);
                        return;
                    }
                    SArmy army = p.getArmy(armyid);
                    if (army != null) {
                        if (limit < -1) {
                            CampaignMain.cm.toUser("You may not set negative limits.", Username, true);
                            return;
                        }
                        int bufferAmt = Integer.parseInt(CampaignMain.cm.getConfig("LowerLimitBuffer"));
                        if (limit < bufferAmt && limit != -1) {
                            CampaignMain.cm.toUser("You must set a lower limit of " + bufferAmt + " or more.", Username, true);
                            return;
                        }
                        army.setLowerLimiter(limit);
                        if (limit == -1) {
                            CampaignMain.cm.toUser("Army #" + armyid + "'s lower limit disabled.", Username, true);
                        } else {
                            CampaignMain.cm.toUser("Army #" + armyid + "'s lower limit set to " + limit + ".", Username, true);
                        }
                        CampaignMain.cm.toUser("PL|SAB|" + army.getID() + "#" + army.getLowerLimiter() + "#" + army.getUpperLimiter(), Username, false);
                        p.getMyHouse().fireStatusEvent("Army lowerLimit changed", Username);
                    }
                }
            }
        }
    }
}

