/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.NewbiePlanet;
import server.campaign.SArmy;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class AttackCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        String s;
        boolean minActiveMet;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        OperationManager manager = CampaignMain.cm.getOpsManager();
        SPlayer ap = CampaignMain.cm.getPlayer(Username);
        if (ap == null) {
            CampaignMain.cm.toUser("Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        if (!ap.isActive()) {
            CampaignMain.cm.toUser("You aren't on the front lines! (You are currently in Reserve. Activate in order to attack.)", Username, true);
            return;
        }
        if (ap.getActivityStatus() == 4) {
            CampaignMain.cm.toUser("You are already fighting!", Username, true);
            return;
        }
        boolean bl = minActiveMet = System.currentTimeMillis() - ap.getActiveSince() >= Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
        if (!ap.getMyHouse().isBusy(Username) && ap.isActive() && !minActiveMet) {
            CampaignMain.cm.toUser("You're still on your way to the frontline. You cannot attack until you arrive.", Username, true);
            return;
        }
        int altID = CampaignMain.cm.getOpsManager().playerIsAnAttacker(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("You're only allowed to attack once, and are already in Attack #" + altID + ".", Username, true);
            return;
        }
        altID = CampaignMain.cm.getOpsManager().playerIsADefender(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("You're already defending against Attack #" + altID + ".", Username, true);
            return;
        }
        String opName = command.nextToken();
        Operation o = manager.getOperation(opName);
        if (o == null) {
            CampaignMain.cm.toUser("Operation Type: " + opName + " does not exist.", Username, true);
            return;
        }
        int armyID = -1;
        try {
            armyID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Non-number given for Army ID. Try again.", Username, true);
            return;
        }
        SArmy aa = ap.getArmy(armyID);
        if (aa == null) {
            CampaignMain.cm.toUser("An error occured while creating your Army (The Army was null. This usually means the army includes destroyed units, or you tried to use an army that doesn't exist. Example: you tried to use Army 1, but you only have Armies 0 and 2.)", Username, true);
            return;
        }
        if (aa.getBV() == 0) {
            CampaignMain.cm.toUser("Army #" + armyID + " has a BV of 0 and may not be used to attack.", Username, true);
            return;
        }
        String planetName = command.nextToken();
        SPlanet target = CampaignMain.cm.getPlanetFromPartialString(planetName, Username);
        if (target == null) {
            return;
        }
        if (ap.getMyHouse().isNewbieHouse() && !(target instanceof NewbiePlanet)) {
            CampaignMain.cm.toUser("Players in the training house may only attack the training world.", Username, true);
            return;
        }
        int longID = -1;
        if (o.getTypeIndicator() == Operation.TYPE_SHORTANDLONG) {
            if (!manager.hasSpecificLongOnPlanet(ap.getHouseFightingFor(), target, o)) {
                CampaignMain.cm.toUser("Your faction has no " + opName + " in progress on " + target.getName() + ".", Username, true);
                return;
            }
            longID = manager.getLongID(ap.getHouseFightingFor(), target);
        }
        if ((s = manager.validateShortAttack(ap, aa, o, target, longID)) != null && !s.trim().equals("")) {
            CampaignMain.cm.toUser("Attack failed " + s, Username, true);
            return;
        }
    }
}

