/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.market.Bid;
import server.campaign.market.Market;

public class BidCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            long id = Integer.parseInt((String)command.nextElement());
            if (command.hasMoreElements()) {
                SPlayer p = CampaignMain.cm.getPlayer(Username);
                int bidFluCost = Integer.parseInt(CampaignMain.cm.getConfig("BMBidFlu"));
                int amount = Integer.parseInt((String)command.nextElement());
                if (!p.getMyHouse().isMayUseBM() || p.getExperience() < Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforBMBuying"))) {
                    CampaignMain.cm.toUser("You may not bid on the BM. Your faction doesn't allow it, or you're too inexperienced.", Username, true);
                    return;
                }
                if (p.getInfluence() < bidFluCost) {
                    CampaignMain.cm.toUser("You need " + CampaignMain.cm.moneyOrFluMessage(false, true, bidFluCost) + " to place a bid.", Username, true);
                    return;
                }
                p.addInfluence(-bidFluCost);
                CampaignMain.cm.toUser("You placed a " + CampaignMain.cm.moneyOrFluMessage(true, false, amount) + " bid. (-" + CampaignMain.cm.moneyOrFluMessage(false, true, bidFluCost) + ")", Username, true);
                Bid b = new Bid(amount, p);
                CampaignMain.cm.getMarket().addBid(id, b);
                CampaignMain.cm.getMarket().removeStatusKnown(Username);
                String result = Market.getBMStatus(Username, true);
                if (result != null && !result.equals("")) {
                    CampaignMain.cm.toUser(result, Username, false);
                }
                p.setSave(true);
            }
        }
    }
}

