/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class BuyPilotsFromHouseCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (!new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            return;
        }
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int type = Integer.parseInt(command.nextToken());
            int weight = Integer.parseInt(command.nextToken());
            if (p.getPlayerPersonalPilotQueue().getPilotQueue(type, weight).size() > 0 && !new Boolean(CampaignMain.cm.getConfig("AllowPlayerToBuyPilotsFromHouseWhenPoolIsFull")).booleanValue()) {
                CampaignMain.cm.toUser("You faction will not let you plunder their pilot reserves while you have perfectly able pilots in your barracks!", Username, true);
                return;
            }
            if (p.getPlayerPersonalPilotQueue().getPilotQueue(type, weight).size() > Integer.parseInt(CampaignMain.cm.getConfig("MaxAllowedPilotsInQueueToBuyFromHouse"))) {
                CampaignMain.cm.toUser("Your Faction will only allow you to buy pilots from their reserve when you have less then " + new Integer(CampaignMain.cm.getConfig("MaxAllowedPilotsInQueueToBuyFromHouse")) + " pilots in your barracks.", Username, true);
                return;
            }
            int money = Integer.parseInt(CampaignMain.cm.getConfig("CostToBuyNewPilot"));
            if (p.getName().startsWith("[Coach]")) {
                money = 0;
            }
            if (p.getMoney() < money) {
                CampaignMain.cm.toUser("You do not have enough money to procure a new pilot from your faction.(" + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ") needed.", Username, true);
                return;
            }
            p.addMoney(-money);
            SHouse h = p.getHouseFightingFor();
            SPilot pilot = h.getNewPilot(type);
            p.getPlayerPersonalPilotQueue().addPilot(type, weight, pilot);
            String toUser = "";
            String skills = pilot.getSkillString(true).trim();
            if (type == 0) {
                toUser = "You have purchased " + pilot.getName() + " (" + pilot.getGunnery() + "/" + pilot.getPiloting();
                toUser = skills == null || skills.equals("") ? toUser + " " + skills + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + "." : toUser + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ".";
            } else {
                toUser = "You have purchased " + pilot.getName() + " (" + pilot.getGunnery();
                toUser = skills == null || skills.equals("") ? toUser + " " + skills + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + "." : toUser + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ".";
            }
            CampaignMain.cm.toUser(toUser, Username, true);
            CampaignMain.cm.toUser("PL|PPQ|" + p.getPlayerPersonalPilotQueue().toString(true), Username, false);
        }
    }
}

