/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;

public class CancelOfferCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer offeringPlayer = CampaignMain.cm.getPlayer(Username);
        boolean contractRemoved = false;
        String receivingPlayerName = "";
        for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
            ContractInfo info = (ContractInfo)CampaignMain.cm.getUnresolvedContracts().get(i);
            if (info.getOfferingPlayer() != offeringPlayer) continue;
            receivingPlayerName = info.getPlayerName();
            CampaignMain.cm.getUnresolvedContracts().remove(i);
            contractRemoved = true;
        }
        if (contractRemoved) {
            CampaignMain.cm.toUser("You have cancelled your offer to " + receivingPlayerName, Username, true);
            CampaignMain.cm.toUser(offeringPlayer.getName() + " has rescinded his contract offer", receivingPlayerName, true);
        } else if (!contractRemoved) {
            CampaignMain.cm.toUser("There was no outstanding contract to cancel!", Username, true);
        }
    }
}

