/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class CheckAttackCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        boolean minActiveMet;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (!new Boolean(CampaignMain.cm.getConfig("ProbeInReserve")).booleanValue() && !p.isActive()) {
            CampaignMain.cm.toUser("You are not on the frontline. You can't probe enemy forces from reserve!", Username, true);
            return;
        }
        boolean bl = minActiveMet = System.currentTimeMillis() - p.getActiveSince() >= Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
        if (!p.getMyHouse().isBusy(Username) && p.isActive() && !minActiveMet) {
            CampaignMain.cm.toUser("You're still on your way to the frontline. Contact an intelligence officer once you arrive at your post.", Username, true);
            return;
        }
        long minTimeBetween = Long.parseLong(CampaignMain.cm.getConfig("MinTimeBetweenChecks"));
        if (System.currentTimeMillis() - p.getLastCheckAttack() < minTimeBetween * 1000L) {
            CampaignMain.cm.toUser("Your attack checks must be at least " + minTimeBetween + " seconds apart.", Username, true);
            return;
        }
        if (p.getActivityStatus() == 4) {
            CampaignMain.cm.toUser("You should focus on playing your game!", Username, true);
            return;
        }
        if (p.getMyHouse().isMercHouse() && p.getHouseFightingFor() == p.getMyHouse()) {
            CampaignMain.cm.toUser("You are not under contract!", Username, true);
            return;
        }
        boolean usingOpRules = new Boolean(CampaignMain.cm.getConfig("UseOperationsRule"));
        String Desc = "<br>";
        if (command.hasMoreElements()) {
            StringTokenizer STR = new StringTokenizer(command.nextToken());
            Desc = "<br><font color=\"black\">Army ";
            SArmy arm = p.getArmy(Integer.parseInt(STR.nextToken()));
            Desc = usingOpRules ? Desc + arm.getID() + " (" + arm.getOperationsBV(null) + " BV vs 4) " : Desc + arm.getID() + " (" + arm.getBV() + " BV) ";
            Desc = Desc + " may attack: ";
            Enumeration<SArmy> targets = arm.getOpponents().elements();
            while (targets.hasMoreElements()) {
                SArmy currTarget = targets.nextElement();
                SPlayer currTargetP = CampaignMain.cm.getPlayer(currTarget.getPlayerName());
                String coloredHouseName = currTargetP.getMyHouse().getHouseFightingFor(currTargetP).getColoredName();
                Desc = new Boolean(CampaignMain.cm.getConfig("ShowInfInCheckAttack")) != false ? Desc + coloredHouseName + "(" + currTarget.getAmountOfUnits() + ")" : Desc + coloredHouseName + "(" + currTarget.getAmountOfUnitsWithoutInfantry() + ")";
                if (!targets.hasMoreElements()) continue;
                Desc = Desc + ", ";
            }
        } else {
            Desc = "<font color=\"black\">Intelligence reports the following attack options:<br>";
            Enumeration<SArmy> e = p.getArmies().elements();
            while (e.hasMoreElements()) {
                SArmy arm = e.nextElement();
                if (arm == null) continue;
                Desc = Desc + "Army " + arm.getID() + " (";
                Desc = usingOpRules ? Desc + arm.getOperationsBV(null) + " BV vs 4): " : Desc + arm.getBV() + " BV): ";
                Enumeration<SArmy> targets = arm.getOpponents().elements();
                while (targets.hasMoreElements()) {
                    SArmy currTarget = targets.nextElement();
                    SPlayer currTargetP = CampaignMain.cm.getPlayer(currTarget.getPlayerName());
                    String coloredHouseName = currTargetP.getMyHouse().getHouseFightingFor(currTargetP).getColoredName();
                    Desc = Desc + coloredHouseName + "(" + currTarget.getAmountOfUnits() + ")";
                    if (!targets.hasMoreElements()) continue;
                    Desc = Desc + ", ";
                }
                Desc = Desc + "<br>";
            }
        }
        CampaignMain.cm.toUser(Desc + "</font><br>", Username, true);
        p.setLastCheckAttack(System.currentTimeMillis());
    }
}

