/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class DeactivateCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("Null player. Big Failure. Report to admin immediately.", Username, true);
            return;
        }
        if (!p.isActive()) {
            CampaignMain.cm.toUser("You're already on reserve duty.", Username, true);
            return;
        }
        if (p.getMyHouse().isBusy(Username)) {
            CampaignMain.cm.toUser("You're currently fighting! You cannot go into the reserve!", Username, true);
            return;
        }
        if (System.currentTimeMillis() - p.getActiveSince() < Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L) {
            CampaignMain.cm.toUser("You haven't even reached the front yet! (Must meet minimum activity requirement before deactivating)", Username, true);
            return;
        }
        p.setActive(false);
        CampaignMain.cm.toUser("<font color=\"black\">[*] You've left active duty and are now in reserve.", Username, true);
        CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
    }
}

