/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.House;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.dataFiles.SUnitData;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.PlayerDefectionEntry;
import server.campaign.util.PlayerDefectionEntryKeeper;
import server.util.MMNetPasswd;
import server.util.MMNetPasswdRecord;

public class DefectCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreTokens()) {
            PlayerDefectionEntry entry;
            SPlayer p;
            String HouseName = command.nextToken();
            boolean commandConfirmed = false;
            if (command.hasMoreElements() && ((String)command.nextElement()).equals("CONFIRM")) {
                commandConfirmed = true;
            }
            if ((p = CampaignMain.cm.getPlayer(Username)).getUnitsOnMarket().size() > 0) {
                CampaignMain.cm.toUser("You are not allowed to defect while you have units on the black market.", Username, true);
                return;
            }
            if (CampaignMain.cm.getData().getHouseByName(HouseName) == null) {
                CampaignMain.cm.toUser("Could not find a faction with that name. Try again?", Username, true);
                return;
            }
            SHouse newHouse = (SHouse)CampaignMain.cm.getData().getHouseByName(HouseName);
            SHouse oldHouse = p.getMyHouse();
            if (!oldHouse.getHouseDefectionFrom()) {
                CampaignMain.cm.toUser("You may not defect from this faction!", Username, true);
                return;
            }
            if (!newHouse.getHouseDefectionTo()) {
                CampaignMain.cm.toUser("You may not defect to the " + newHouse.getName() + " faction.", Username, true);
                return;
            }
            if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
                CampaignMain.cm.toUser("You may not defect while playing a game. Try again after your game is finished.", Username, true);
                return;
            }
            int mercEXPRequired = Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforMercenaries")) - 10 * (int)(p.getRating() - 1600.0);
            int minEXPRequired = Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforDefecting"));
            Iterator<House> e = CampaignMain.cm.getData().getAllHouses().iterator();
            TreeSet s = CampaignMain.cm.getHouseRanking();
            Iterator it = s.iterator();
            int factionPlace = s.size();
            while (it.hasNext()) {
                HouseRankingHelpContainer h = (HouseRankingHelpContainer)it.next();
                --factionPlace;
                if (!h.getHouse().equals(newHouse)) continue;
                minEXPRequired += factionPlace * Integer.parseInt(CampaignMain.cm.getConfig("EXPNeededPerHouseRank"));
            }
            if (p.getExperience() < minEXPRequired) {
                CampaignMain.cm.toUser("You're too inexperienced to defect. You need at least " + minEXPRequired + " XP to join that faction.", p.getName(), true);
                return;
            }
            if (newHouse.equals(oldHouse)) {
                CampaignMain.cm.toUser("You're already in that faction!", p.getName(), true);
                return;
            }
            if (p.getExperience() < mercEXPRequired && newHouse.isMercHouse()) {
                if (new Boolean(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
                    CampaignMain.cm.toUser("You're too inexperienced to defect to a Mercenary faction!", p.getName(), true);
                } else {
                    CampaignMain.cm.toUser("You're too inexperienced to defect to a Mercenary faction!  You need " + mercEXPRequired + " experience with your current Rating!", p.getName(), true);
                }
                return;
            }
            if (newHouse.isNewbieHouse()) {
                CampaignMain.cm.toUser("You may not defect back to the training faction.", Username, true);
                return;
            }
            MMNetPasswdRecord r = null;
            boolean regged = false;
            try {
                r = MMNetPasswd.getRecord(p.getName(), null);
            }
            catch (Exception ex) {
                regged = true;
            }
            if (!regged) {
                CampaignMain.cm.toUser("<br>-----<br>You may not join a faction until you set a password for your account. Go to the File menu and select the 'Register Nickname' option. After registering your password, open the configuration menu (File menu -> Configuration) and add your password to the aptly named \"Password\" field. Quit the client and rejoin toensure that the password was properly set, then try defecting again.<br><br>If you have trouble registering, please contact a server moderator or administrator. If none are avaliable post to the server's forums, email the administrator or ask experienced non-moderator players for assistance.<br><br>NOTE: Passwords must be between 6 and 10 characters in length and use standard ASCII characters).<br>-----", Username, true);
                return;
            }
            boolean penalizeDefection = true;
            if (oldHouse.isNewbieHouse()) {
                penalizeDefection = false;
            }
            if (newHouse.isMercHouse() && !Boolean.valueOf(CampaignMain.cm.getConfig("PenalizeDefectToMerc")).booleanValue()) {
                penalizeDefection = false;
            }
            if (!newHouse.isConquerable() && !Boolean.valueOf(CampaignMain.cm.getConfig("PenalizeDefectToNonConq")).booleanValue()) {
                penalizeDefection = false;
            }
            int oldExp = p.getExperience();
            int oldMoney = p.getMoney();
            int oldFlu = p.getInfluence();
            int oldRP = p.getReward();
            int newExp = 0;
            int newMoney = 0;
            int newFlu = 0;
            int newRP = 0;
            int expLoss = 0;
            int mnyLoss = 0;
            int fluLoss = 0;
            int rwdLoss = 0;
            int startingUnits = p.getNumberOfUnits();
            int unitsToLose = 0;
            int varsWhichChange = 0;
            if (penalizeDefection) {
                int expLossPerc = Integer.parseInt(CampaignMain.cm.getConfig("DefectionEXPLossPercent"));
                int expLossFlat = Integer.parseInt(CampaignMain.cm.getConfig("DefectionEXPLossFlat"));
                int mnyLossPerc = Integer.parseInt(CampaignMain.cm.getConfig("DefectionCBillLossPercent"));
                int mnyLossFlat = Integer.parseInt(CampaignMain.cm.getConfig("DefectionCBillLossFlat"));
                int fluLossPerc = Integer.parseInt(CampaignMain.cm.getConfig("DefectionInfluenceLossPercent"));
                int fluLossFlat = Integer.parseInt(CampaignMain.cm.getConfig("DefectionInfluenceLossFlat"));
                int rwdLossPerc = Integer.parseInt(CampaignMain.cm.getConfig("DefectionRewardLossPercent"));
                int rwdLossFlat = Integer.parseInt(CampaignMain.cm.getConfig("DefectionRewardLossFlat"));
                int unitLossPerc = Integer.parseInt(CampaignMain.cm.getConfig("DefectionUnitLossPercent"));
                int unitLossFlat = Integer.parseInt(CampaignMain.cm.getConfig("DefectionUnitLossFlat"));
                if (expLossPerc > 0) {
                    newExp = oldExp * (100 - expLossPerc) / 100;
                } else {
                    newExp = oldExp - expLossFlat;
                    if (newExp < 0) {
                        newExp = 0;
                    }
                }
                expLoss = oldExp - newExp;
                if (expLoss > 0) {
                    ++varsWhichChange;
                }
                if (mnyLossPerc > 0) {
                    newMoney = oldMoney * (100 - mnyLossPerc) / 100;
                } else {
                    newMoney = oldMoney - mnyLossFlat;
                    if (newMoney < 0) {
                        newMoney = 0;
                    }
                }
                mnyLoss = oldMoney - newMoney;
                if (mnyLoss > 0) {
                    ++varsWhichChange;
                }
                if (fluLossPerc > 0) {
                    newFlu = oldFlu * (100 - fluLossPerc) / 100;
                } else {
                    newFlu = oldFlu - fluLossFlat;
                    if (newFlu < 0) {
                        newFlu = 0;
                    }
                }
                fluLoss = oldFlu - newFlu;
                if (fluLoss > 0) {
                    ++varsWhichChange;
                }
                if (rwdLossPerc > 0) {
                    newRP = oldRP * (100 - rwdLossPerc) / 100;
                } else {
                    newRP = oldRP - rwdLossFlat;
                    if (newRP < 0) {
                        newRP = 0;
                    }
                }
                rwdLoss = oldRP - newRP;
                if (rwdLoss > 0) {
                    ++varsWhichChange;
                }
                if (unitLossPerc > 0) {
                    unitsToLose = startingUnits * unitLossPerc / 100;
                } else {
                    unitsToLose = unitLossFlat;
                    if (unitsToLose > startingUnits) {
                        unitsToLose = startingUnits;
                    }
                }
            }
            int varsAddedToString = 0;
            String penString = "";
            if (penalizeDefection && varsWhichChange > 0) {
                penString = "";
                if (expLoss > 0) {
                    penString = penString + expLoss + " XP";
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (mnyLoss > 0) {
                    penString = penString + CampaignMain.cm.moneyOrFluMessage(true, false, mnyLoss);
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (fluLoss > 0) {
                    penString = penString + CampaignMain.cm.moneyOrFluMessage(false, false, fluLoss);
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
                if (rwdLoss > 0) {
                    penString = penString + rwdLoss + " Reward Points";
                    ++varsAddedToString;
                }
                if (varsAddedToString + 1 == varsWhichChange && unitsToLose == 0) {
                    penString = penString + " and ";
                } else if (varsAddedToString > 0 && varsAddedToString != varsWhichChange) {
                    penString = penString + ", ";
                }
            }
            if (!commandConfirmed) {
                if (!penalizeDefection) {
                    CampaignMain.cm.toUser("Click <a href=\"MWDEFECTDLG/c defect#" + newHouse.getName() + "#CONFIRM\">here</a> to confirm your defection to " + newHouse.getName() + ".<br>", p.getName(), true);
                    return;
                }
                if (varsWhichChange == 0 && unitsToLose == 0) {
                    CampaignMain.cm.toUser("Click <a href=\"MWDEFECTDLG/c defect#" + newHouse.getName() + "#CONFIRM\">here</a> to confirm your defection to " + newHouse.getName() + ".<br>", p.getName(), true);
                    return;
                }
                String toReturn = "If you defect to " + newHouse.getName() + "  you will lose " + penString;
                if (varsWhichChange != 0) {
                    toReturn = toReturn + "and ";
                }
                toReturn = unitsToLose == startingUnits ? toReturn + "all of your units." : (unitsToLose > 0 ? toReturn + unitsToLose + " units." : toReturn.trim() + ".");
                toReturn = toReturn + " Click <a href=\"MWDEFECTDLG/c defect#" + newHouse.getName() + "#CONFIRM\">here</a> to confirm your defection to " + newHouse.getName() + ".<br>";
                CampaignMain.cm.toUser(toReturn, p.getName(), true);
                return;
            }
            String toReturn = "You succesfully defected to " + newHouse.getName() + ". ";
            if (penalizeDefection && (unitsToLose > 0 || varsWhichChange > 0)) {
                p.setExperience(newExp);
                p.setMoney(newMoney);
                p.setInfluence(newFlu);
                p.setReward(newRP);
                toReturn = toReturn + "You've lost " + penString;
                if (unitsToLose == startingUnits) {
                    Vector v = p.getAllUnitsData();
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        oldHouse.addUnit(new SUnit((SUnitData)v.elementAt(i)), true);
                    }
                    p.stripOfAllUnits();
                    toReturn = toReturn + " and all of your units";
                } else if (unitsToLose > 0) {
                    toReturn = toReturn + " and the following units: ";
                    for (int numRemoved = 0; numRemoved < unitsToLose; ++numRemoved) {
                        if (numRemoved != 0) {
                            toReturn = toReturn + ", ";
                        }
                        SUnitData data = (SUnitData)p.getUnitsData().get(CampaignMain.cm.getR().nextInt(p.getUnitsData().size()));
                        SUnit toRemove = new SUnit(data);
                        toReturn = toReturn + toRemove.getModelName();
                        oldHouse.addUnit(new SUnit(data), true);
                        p.removeUnit(data.getId(), false);
                    }
                }
                toReturn = toReturn + ".";
            }
            p.getMyHouse().removePlayer(Username, false);
            p.setMyHouse(newHouse);
            newHouse.addMember(p);
            CampaignMain.cm.toUser(toReturn, Username, true);
            CampaignMain.cm.doSendHouseMail(oldHouse, "NOTE: ", p.getName() + " has defected to " + newHouse.getName());
            CampaignMain.cm.doSendHouseMail(newHouse, "NOTE: ", p.getName() + " has joined the faction! (Defected from " + oldHouse.getName() + ")");
            CampaignMain.cm.addToNewsFeed(Username + " has defected from " + oldHouse.getName() + " to " + newHouse.getName());
            if (p.getMyHouse().equals(newHouse) && !CampaignMain.cm.getServer().isAdmin(Username)) {
                MMNetPasswd.getRecord(Username).setAccess(2);
            }
            Vector units = p.getUnitsData();
            for (int i = 0; i < units.size(); ++i) {
                SUnit unit = new SUnit((SUnitData)units.elementAt(i));
                p.checkAmmoForUnit(unit);
            }
            CampaignMain.cm.getPlayer(Username);
            CampaignMain.cm.doLoginPlayer(Username);
            if (p.getFreeBays() < 0) {
                p.setRandomUnmaintained();
                int factionBays = p.getMyHouse().getBaysProvided();
                int minBays = Integer.parseInt(CampaignMain.cm.getConfig("MinimumHouseBays"));
                String dismayMessage = "You are dismayed when you discover that " + p.getHouseName() + " only has ";
                dismayMessage = minBays > factionBays ? dismayMessage + minBays : dismayMessage + factionBays;
                dismayMessage = dismayMessage + " technicians avaliable to assign to your force. You order your techs to ignore the maintaince needs of some units, adjust the duty roster, and consider hiring moretechnicians ... (Some units are now unmaintained! Check your status!)";
                CampaignMain.cm.toUser(dismayMessage, Username, true);
            }
            if (CampaignMain.cm.useHibernate() && (entry = PlayerDefectionEntry.getEntry(p.getName(), oldHouse.getName(), newHouse.getName())) != null) {
                PlayerDefectionEntryKeeper.addPlayerDefectionEntry(entry);
            }
        }
    }
}

