/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class EnrollCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (Username.startsWith("Nobody")) {
            CampaignMain.cm.toUser("Nobodies are not allowed to enroll. If you're signing on for the first time and have been labelled a Nobody, you're probably using a name someone else has already registered. If you've registered this name previously, you're either not sending a password or sending an incorrect password. Try re-entering your password in the configuration menu.", Username, true);
            return;
        }
        if (Username.startsWith("[Dedicated]")) {
            CampaignMain.cm.toUser("Dedicated hosts may not enroll in the campaign.", Username, true);
            return;
        }
        if (CampaignMain.cm.getHouseForPlayer(Username) != null) {
            CampaignMain.cm.toUser("You are already enrolled in the campaign. Nice try though.", Username, true);
            return;
        }
        SHouse nh = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"), null);
        if (nh == null) {
            CampaignMain.cm.toUser("Training faction is null. Contact an admin immediately.", Username, true);
            return;
        }
        SPlayer newPlayer = new SPlayer(Username, nh);
        CampaignMain.cm.toUser("<fontcolor=\"navy\">You have been assigned to " + nh.getName() + ", a training faction.</font>", Username, true);
        nh.addMember(newPlayer);
        CampaignMain.cm.doLoginPlayer(Username);
        newPlayer.updateSQLPlayerEntry();
        newPlayer.setSave(true);
        newPlayer.savePlayerFile();
    }
}

