/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class ExchangePilotInUnitCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            return;
        }
        if (command.hasMoreElements()) {
            SUnit m;
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int mechid = Integer.parseInt(command.nextToken());
            int newPilotId = -1;
            if (command.hasMoreElements()) {
                newPilotId = Integer.parseInt(command.nextToken());
            }
            if ((m = p.getUnit(mechid)) != null) {
                if (p.isActive() && p.getAmountOfTimesUnitExistsInArmies(mechid) > 0) {
                    CampaignMain.cm.toUser(m.getModelName() + " cannot have its pilot switched out while active and in an exisiting army.", Username, true);
                    return;
                }
                SPilot pilot = (SPilot)m.getPilot();
                if (!pilot.getName().equals("Vacant")) {
                    p.getPlayerPersonalPilotQueue().addPilot(m.getType(), m.getWeightclass(), pilot);
                    CampaignMain.cm.toUser(pilot.getName() + " has been moved from your " + m.getModelName() + " to your barracks.", Username, true);
                }
                SPilot p2 = null;
                if (newPilotId > -1) {
                    try {
                        p2 = (SPilot)p.getPlayerPersonalPilotQueue().getPilot(m.getType(), m.getWeightclass(), newPilotId);
                    }
                    catch (Exception ex) {
                        MMServ.mmlog.errLog(ex);
                        CampaignMain.cm.toUser("Invalid Pilot try again!", Username, true);
                        return;
                    }
                } else {
                    p2 = new SPilot("Vacant", 99, 99);
                }
                m.setPilot(p2, true);
                CampaignMain.cm.toUser(p2.getName() + " has been assigned to the " + m.getModelName() + " [New BV: " + m.getBV() + "].", Username, true);
                CampaignMain.cm.toUser("PL|PPQ|" + p.getPlayerPersonalPilotQueue().toString(true), Username, false);
                CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), Username, false);
                Vector<SArmy> armies = p.getArmies();
                Enumeration<SArmy> f = armies.elements();
                while (f.hasMoreElements()) {
                    SArmy currArmy = f.nextElement();
                    if (currArmy.getUnit(m.getId()) == null) continue;
                    currArmy.setBV(0);
                    CampaignMain.cm.toUser("PL|SAD|" + currArmy.toString(true, "%"), Username, false);
                    CampaignMain.cm.getOpsManager().checkOperations(currArmy, true);
                }
            }
        }
    }
}

