/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class FactionLeaderMuteCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer leader = CampaignMain.cm.getPlayer(Username);
        SPlayer p = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c factionleadermute#PlayerName", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find a player with that name.", Username, true);
            return;
        }
        if (!leader.getHouseName().equalsIgnoreCase(p.getHouseName())) {
            CampaignMain.cm.toUser("You are not in the same faction as " + p.getName() + " therefore you maynot mute them!", Username, true);
            return;
        }
        Vector ignoreList = CampaignMain.cm.getServer().getIgnoreList();
        if (ignoreList.indexOf(p.getName()) == -1) {
            ignoreList.add(p.getName());
            MMServ.mmlog.modLog(Username + " muted " + p.getName());
            CampaignMain.cm.doSendModMail("NOTE", Username + " muted " + p.getName());
            CampaignMain.cm.toUser("You have muted " + p.getName(), Username, true);
            CampaignMain.cm.toUser("You have been muted by " + Username, Username, true);
        } else {
            ignoreList.remove(p.getName());
            MMServ.mmlog.modLog(Username + " unmuted " + p.getName());
            CampaignMain.cm.doSendModMail("NOTE", Username + " unmuted " + p.getName());
            CampaignMain.cm.toUser("You have unmuted " + p.getName(), Username, true);
            CampaignMain.cm.toUser("You have been unmuted by " + Username, Username, true);
        }
    }
}

