/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Iterator;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class GamesCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        boolean factionSort = false;
        String factionName = "";
        if (command.hasMoreElements()) {
            try {
                factionName = command.nextToken().toLowerCase();
                if (!factionName.equals("") && !factionName.startsWith(" ")) {
                    factionSort = true;
                }
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("Games command failed. Check your input. It should be:/c games (to get all games) or /c games#faction (for a filtered list)", Username, true);
                return;
            }
        }
        String result = "<h2>Games:</h2>";
        Iterator<ShortOperation> i = CampaignMain.cm.getOpsManager().getRunningOps().values().iterator();
        if (!factionSort) {
            while (i.hasNext()) {
                ShortOperation so = i.next();
                if (so.hasPlayerFrom(p.getMyHouse())) {
                    result = result + "<br>" + so.getInfo(true);
                    continue;
                }
                result = result + "<br>" + so.getInfo(false);
            }
        } else {
            while (i.hasNext()) {
                ShortOperation so = i.next();
                if (!so.hasPlayerWhoseHouseBeginsWith(factionName)) continue;
                if (so.hasPlayerFrom(p.getMyHouse())) {
                    result = result + "<br>" + so.getInfo(true);
                    continue;
                }
                result = result + "<br>" + so.getInfo(false);
            }
        }
        CampaignMain.cm.toUser("SM|" + result, Username, false);
    }
}

