/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;
import server.campaign.util.PlanetNameComparator;

public class ISStatusCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            String HouseString = (String)command.nextElement();
            SHouse theone = CampaignMain.cm.getHouseFromPartialString(HouseString, Username);
            if (theone == null) {
                return;
            }
            if (command.hasMoreElements()) {
                String next = command.nextToken();
                boolean owner = false;
                if (next.equalsIgnoreCase("own")) {
                    owner = true;
                    if (command.hasMoreElements()) {
                        next = command.nextToken();
                    }
                }
                this.doShowISStatus(Username, theone.getName(), next, owner);
            } else {
                this.doShowISStatus(Username, theone.getName(), "null", false);
            }
        }
    }

    public void doShowISStatus(String User, String h, String h2, boolean onlyOwner) {
        String result = "<h2>Universe Status";
        TreeSet<SPlanet> Sorted = new TreeSet<SPlanet>(new PlanetNameComparator());
        int hID = CampaignMain.cm.getData().getHouseByName(h).getId();
        int hID2 = -1;
        if (CampaignMain.cm.getData().getHouseByName(h2) != null) {
            hID2 = CampaignMain.cm.getData().getHouseByName(h2).getId();
        }
        if (h != null) {
            result = result + " for Faction " + h;
            if (onlyOwner) {
                result = result + " (only planets owned are shown)";
            }
            if (hID2 != -1) {
                result = result + " and Faction " + h2;
            }
        }
        result = result + ":</h2>";
        for (SPlanet p : CampaignMain.cm.getData().getAllPlanets()) {
            boolean show = false;
            if (h != null) {
                if (onlyOwner) {
                    if (p.getOwner() != null) {
                        if (hID2 != -1 && p.getOwner().getName().equals(h) && p.getInfluence().getInfluence(hID2) > 0) {
                            show = true;
                        } else if (p.getOwner().getName().equals(h)) {
                            show = true;
                        }
                    }
                } else if (hID2 != -1) {
                    if (p.getInfluence().getInfluence(hID2) > 0 && p.getInfluence().getInfluence(hID) > 0) {
                        show = true;
                    }
                } else if (p.getInfluence().getInfluence(hID) > 0) {
                    show = true;
                }
            } else {
                show = true;
            }
            if (!show) continue;
            Sorted.add(p);
        }
        Iterator it = Sorted.iterator();
        while (it.hasNext()) {
            result = result + ((SPlanet)it.next()).getSmallStatus(true);
        }
        CampaignMain.cm.toUser("SM|" + result, User, false);
    }
}

