/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.House;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SmallPlayer;
import server.campaign.commands.Command;

public class LastOnlineCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String name = command.nextToken().toLowerCase();
        SmallPlayer smallp = null;
        Iterator<House> i = CampaignMain.cm.getData().getAllHouses().iterator();
        boolean playerFound = false;
        while (i.hasNext() && !playerFound) {
            SHouse h = (SHouse)i.next();
            smallp = (SmallPlayer)h.getSmallPlayers().get(name);
            if (smallp == null) continue;
            playerFound = true;
        }
        if (smallp == null) {
            CampaignMain.cm.toUser("Target player could not be found.", Username, true);
            return;
        }
        if (smallp.getLastOnline() != 0L) {
            Date lastDate = new Date(smallp.getLastOnline());
            String result = smallp.getName() + " (" + smallp.getMyHouse().getColoredName() + ") was last online: " + lastDate + ". ";
            result = result + "That's " + (System.currentTimeMillis() - smallp.getLastOnline()) / 86400000L + " days";
            result = result + ", " + (System.currentTimeMillis() - smallp.getLastOnline()) % 86400000L / 3600000L + " hours";
            CampaignMain.cm.toUser(result, Username, true);
        } else {
            CampaignMain.cm.toUser(smallp.getName() + " has not been here for a long time.", Username, true);
        }
    }
}

