/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class LinkUnitCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            SArmy a;
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int armyid = Integer.parseInt(command.nextToken());
            int slaveid = Integer.parseInt(command.nextToken());
            int masterid = -1;
            int linkid = -1;
            if (command.hasMoreElements()) {
                masterid = Integer.parseInt(command.nextToken());
            }
            if ((a = p.getArmy(armyid)) == null) {
                CampaignMain.cm.toUser("Army #" + armyid + " does not exist.", Username, true);
                return;
            }
            if (a.isLocked()) {
                CampaignMain.cm.toUser("You may not change C3 networks while an Army is in combat.", Username, true);
                return;
            }
            if (p.isActive()) {
                CampaignMain.cm.toUser("You may not change C3 networks while on active duty.", Username, true);
                return;
            }
            Unit slaveUnit = a.getUnit(slaveid);
            if (slaveUnit == null) {
                CampaignMain.cm.toUser("Could not find unit #" + slaveid + " in army #" + armyid + ".", Username, true);
                return;
            }
            boolean usingOpRules = Boolean.valueOf(CampaignMain.cm.getConfig("UseOperationsRule"));
            double opRuleBaseSize = Double.parseDouble(CampaignMain.cm.getConfig("BaseForceSize"));
            if (slaveUnit.hasBeenC3LinkedTo(a) && masterid == -1) {
                Enumeration c3Key = a.getC3Network().keys();
                Enumeration c3Unit = a.getC3Network().elements();
                while (c3Key.hasMoreElements()) {
                    Integer keyId = (Integer)c3Key.nextElement();
                    Integer unitId = (Integer)c3Unit.nextElement();
                    if (slaveUnit.getId() != unitId.intValue()) continue;
                    a.getC3Network().remove(keyId);
                }
                a.setRawForceSize(0.0);
                a.setBV(0);
                String toReturn = "Unit #" + slaveid + " has been removed from its network. New BV: " + a.getBV();
                if (usingOpRules && a.getRawForceSize() > opRuleBaseSize) {
                    toReturn = toReturn + " / BV vs 4: " + a.getOperationsBV(null);
                }
                CampaignMain.cm.toUser(toReturn, Username, true);
                p.getMyHouse().fireStatusEvent("LinkUnit called", Username);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
                return;
            }
            if (masterid == -1) {
                a.getC3Network().remove(new Integer(slaveid));
                a.setRawForceSize(0.0);
                a.setBV(0);
                String toReturn = "Unit #" + slaveid + " has been removed from its network. New BV: " + a.getBV();
                if (usingOpRules && a.getRawForceSize() > opRuleBaseSize) {
                    toReturn = toReturn + " / BV vs 4: " + a.getOperationsBV(null);
                }
                CampaignMain.cm.toUser(toReturn, Username, true);
                p.getMyHouse().fireStatusEvent("LinkUnit called", Username);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
                return;
            }
            Unit masterUnit = a.getUnit(masterid);
            if (masterUnit == null) {
                CampaignMain.cm.toUser("Unable to find master unit (#" + masterid + ") in Army #" + armyid + ".", Username, true);
                return;
            }
            linkid = slaveUnit.linkToC3Network(a, masterUnit);
            if (linkid == masterUnit.getId()) {
                a.setRawForceSize(0.0);
                a.setBV(0);
                String toReturn = "Unit #" + slaveUnit.getId() + " has been linked to Unit #" + masterUnit.getId() + ". New BV: " + a.getBV();
                if (usingOpRules && a.getRawForceSize() > opRuleBaseSize) {
                    toReturn = toReturn + " / BV vs 4: " + a.getOperationsBV(null);
                }
                CampaignMain.cm.toUser(toReturn, Username, true);
                p.getMyHouse().fireStatusEvent("LinkUnit called", Username);
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(a, true);
            } else {
                CampaignMain.cm.toUser("Unabled to Link Unit #" + slaveUnit.getId() + " to unit #" + masterUnit.getId() + ".", Username, true);
            }
        }
    }
}

