/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class OfferContractCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String receivingPlayerName = (String)command.nextElement();
        int contractPayment = Integer.parseInt(command.nextToken());
        int contractDuration = Integer.parseInt(command.nextToken());
        SPlayer offeringPlayer = CampaignMain.cm.getPlayer(Username);
        SPlayer receivingPlayer = CampaignMain.cm.getPlayer(receivingPlayerName);
        if (receivingPlayer == null) {
            CampaignMain.cm.toUser("There's no such player", Username, true);
            return;
        }
        if (receivingPlayer.getMyHouse().isMercHouse()) {
            boolean noOtherOffers = true;
            for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
                ContractInfo info = (ContractInfo)CampaignMain.cm.getUnresolvedContracts().get(i);
                if (info.getOfferingPlayer() != offeringPlayer) continue;
                noOtherOffers = false;
            }
            if (contractPayment < 2) {
                CampaignMain.cm.toUser("You must pay a mercenary at least " + CampaignMain.cm.moneyOrFluMessage(true, true, 2) + ".", Username, true);
            } else if (contractDuration < Integer.parseInt(CampaignMain.cm.getConfig("MinContractEXP"))) {
                CampaignMain.cm.toUser("Mercenaries must do work to get paid. Set a contract term of at least " + Integer.parseInt(CampaignMain.cm.getConfig("MinContractEXP")) + " XP", Username, true);
            } else if (!noOtherOffers) {
                CampaignMain.cm.toUser("You may offer only one contract at a time.", Username, true);
            } else if (offeringPlayer.getMoney() < contractPayment) {
                CampaignMain.cm.toUser("Your offer exceeds your monetary resources. Get loans or lower your offer.", Username, true);
            } else if (offeringPlayer.getMyHouse().isNewbieHouse()) {
                CampaignMain.cm.toUser("No Mercenary would ever fight for SOL!", Username, true);
            } else if (offeringPlayer.getMyHouse().isMercHouse()) {
                CampaignMain.cm.toUser("Mercenaries may not employ other mercenaries", Username, true);
            } else if (!receivingPlayer.getMyHouse().isLoggedIn(receivingPlayerName)) {
                CampaignMain.cm.toUser("You may only offer contracts to players currently online", Username, true);
            } else if (((MercHouse)receivingPlayer.getMyHouse()).getContractInfo(receivingPlayer) != null) {
                CampaignMain.cm.toUser("You may not offer contracts to mercenaries with employers", Username, true);
            } else {
                CampaignMain.cm.toUser(offeringPlayer.getName() + " of " + offeringPlayer.getMyHouse().getName() + " has offered you " + CampaignMain.cm.moneyOrFluMessage(true, false, contractPayment) + " for " + contractDuration + " XP of service.", receivingPlayerName, true);
                CampaignMain.cm.toUser("You have offered " + receivingPlayerName + " " + CampaignMain.cm.moneyOrFluMessage(true, false, contractPayment) + " for " + contractDuration + " XP of service.", Username, true);
                ContractInfo newContract = new ContractInfo(contractDuration, receivingPlayer.getExperience(), contractPayment, offeringPlayer.getMyHouse(), receivingPlayerName);
                newContract.setOfferingPlayer(offeringPlayer);
                CampaignMain.cm.getUnresolvedContracts().add(newContract);
                CampaignMain.cm.toUser("Accept this contract by <a href=\"MEKWARS/c acceptcontract#" + offeringPlayer.getName() + "\">clicking here</a>", receivingPlayerName, true);
                CampaignMain.cm.toUser("Decline this contract by <a href=\"MEKWARS/c refusecontract#" + offeringPlayer.getName() + "\">clicking here</a>", receivingPlayerName, true);
                CampaignMain.cm.toUser("Cancel this offer by <a href=\"MEKWARS/c canceloffer\">clicking here</a>", Username, true);
            }
        } else {
            CampaignMain.cm.toUser("You may not offer contracts to non-mercenary players.", Username, true);
        }
    }
}

