/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RangeCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            String target;
            int range = Integer.parseInt(command.nextToken());
            SHouse targetfaction = null;
            if (command.hasMoreElements() && (targetfaction = CampaignMain.cm.getHouseFromPartialString(target = command.nextToken(), Username)) == null) {
                CampaignMain.cm.toUser("Could not find faction " + target + ". Try again?", Username, true);
                return;
            }
            boolean facWorldsOnly = false;
            if (command.hasMoreElements()) {
                try {
                    facWorldsOnly = Boolean.valueOf(command.nextToken());
                }
                catch (Exception e) {
                    CampaignMain.cm.toUser("Improper format. Try: /c range#Distance#Faction#true to return only production worlds.", Username, true);
                    return;
                }
            }
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SHouse h = player.getMyHouse();
            String result = "<font color=\"black\">These planets are within " + range + " light-years ";
            if (targetfaction != null) {
                result = facWorldsOnly ? result + "and " + targetfaction.getName() + " production facilities are present " : result + "and " + targetfaction.getName() + " military assets are present ";
            }
            result = result + ":<br>";
            for (SPlanet p : CampaignMain.cm.getData().getAllPlanets()) {
                SHouse owner;
                if (h.getDistanceTo(p, CampaignMain.cm.getPlayer(Username)) > range) continue;
                if (targetfaction == null) {
                    owner = p.getOwner();
                    if (facWorldsOnly && owner.equals(targetfaction) && p.getFactoryCount() > 0) {
                        result = result + "<font color=\"" + p.getOwner().getHouseColor() + "\">" + p.getShortDescription(true) + "</font>" + "<br>";
                        continue;
                    }
                    if (owner != null) {
                        result = result + "<font color=\"" + p.getOwner().getHouseColor() + "\">" + p.getShortDescription(true) + "</font>" + "<br>";
                        continue;
                    }
                    result = result + "<font color=\"black\">" + p.getSmallStatus(true) + "</font>" + "<br>";
                    continue;
                }
                if (p.getInfluence().getInfluence(targetfaction.getId()) <= 0) continue;
                owner = p.getOwner();
                if (owner != null) {
                    result = result + "<font color=\"" + p.getOwner().getHouseColor() + "\">" + p.getShortDescription(true) + "</font>" + "<br>";
                    continue;
                }
                result = result + "<font color=\"black\">" + p.getSmallStatus(true) + "</font>" + "<br>";
            }
            result = result.substring(0, result.length() - 2);
            result = result + "</font>";
            CampaignMain.cm.toUser("SM|" + result, Username, false);
        }
    }
}

