/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.House;
import common.Unit;
import common.util.AorAn;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Mech;
import server.MMServ;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.util.TimeZoneData;

public class RepodCommand
implements Command {
    int accessLevel = 0;
    private boolean global = false;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        this.global = false;
        if (command.hasMoreElements()) {
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            if (p.mayAcquireWelfareUnits()) {
                CampaignMain.cm.toUser("Sorry but you may not repod your units while you are on welfare!", Username, true);
                return;
            }
            int unitid = Integer.parseInt(command.nextToken());
            SUnit m = p.getUnit(unitid);
            SHouse h = p.getHouseFightingFor();
            String target = "<none>";
            if (command.hasMoreTokens() && (target = command.nextToken()).equals("GLOBAL")) {
                this.global = true;
                target = command.hasMoreTokens() ? command.nextToken() : "<none>";
            }
            if (m == null) {
                CampaignMain.cm.toUser("You do not have a unit with ID# " + unitid + ".", Username, true);
                return;
            }
            if (!m.isOmni()) {
                CampaignMain.cm.toUser("Your " + m.getVerboseModelName() + " is not an Omni.", Username, true);
                return;
            }
            if (p.getAmountOfTimesUnitExistsInArmies(m.getId()) > 0) {
                CampaignMain.cm.toUser("You may not repod a unit while it is in an army.", Username, true);
                return;
            }
            Entity mEnt = m.getEntity();
            String targetChassis = mEnt.getChassis();
            Vector possible = new Vector();
            Vector<String> tables = new Vector<String>();
            if (this.global) {
                Iterator<House> Houses = CampaignMain.cm.getData().getAllHouses().iterator();
                String fileName = "";
                String timeZone = CampaignMain.cm.getConfig("RewardsRepodFolder");
                while (Houses.hasNext()) {
                    SHouse faction = (SHouse)Houses.next();
                    fileName = BuildTable.getFileName(faction.getName(), Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType());
                    if (tables.contains(fileName)) continue;
                    tables.add(fileName);
                }
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCommonTableForRepod")).booleanValue() && !tables.contains(fileName = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType()))) {
                    tables.add(fileName);
                }
            } else if (!Boolean.valueOf(CampaignMain.cm.getConfig("RepodUsesFactory")).booleanValue()) {
                String fileName = "";
                String timeZone = CampaignMain.cm.getConfig("NoFactoryRepodFolder");
                fileName = BuildTable.getFileName(h.getName(), Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType());
                if (!tables.contains(fileName)) {
                    tables.add(fileName);
                }
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCommonTableForRepod")).booleanValue() && !tables.contains(fileName = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType()))) {
                    tables.add(fileName);
                }
            } else {
                possible = p.getMyHouse().getPossibleFactoryForProduction(m.getType(), m.getWeightclass());
                int i = possible.size();
                while (i > 0) {
                    SUnitFactory working = (SUnitFactory)possible.elementAt(--i);
                    Hashtable zonesH = working.getTimeZones();
                    Enumeration zones = zonesH.elements();
                    while (zones.hasMoreElements()) {
                        TimeZoneData tzData = (TimeZoneData)zones.nextElement();
                        String timeZone = tzData.getName();
                        String fileName = BuildTable.getFileName(working.getFounder(), Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType());
                        if (!tables.contains(fileName)) {
                            tables.add(fileName);
                        }
                        if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseCommonTableForRepod")).booleanValue() || tables.contains(fileName = BuildTable.getFileName("Common", Unit.getWeightClassDesc(m.getWeightclass()), timeZone, m.getType()))) continue;
                        tables.add(fileName);
                    }
                }
            }
            if (!target.equals("<none>")) {
                if (target.equals("RANDOM")) {
                    if (!Boolean.valueOf(CampaignMain.cm.getConfig("RandomRepodAllowed")).booleanValue()) {
                        CampaignMain.cm.toUser("Random repodding is not allowed.", Username, true);
                        return;
                    }
                } else if (Boolean.valueOf(CampaignMain.cm.getConfig("RandomRepodOnly")).booleanValue()) {
                    CampaignMain.cm.toUser("Only random repods are allowed.", Username, true);
                    return;
                }
            }
            String result = "";
            Vector<String> variants = new Vector<String>();
            int i = tables.size();
            if (i < 1) {
                CampaignMain.cm.toUser("Repod Failed: No acceptable factory currently available", Username, true);
                return;
            }
            while (i > 0) {
                String prodFile = (String)tables.elementAt(--i);
                try {
                    FileInputStream fis = new FileInputStream(prodFile);
                    BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                    while (dis.ready()) {
                        String l = dis.readLine();
                        StringTokenizer ST = new StringTokenizer(l);
                        if (ST.hasMoreElements()) {
                            SUnit cm;
                            int from = Integer.parseInt((String)ST.nextElement());
                            if (new Boolean(CampaignMain.cm.getConfig("UseOldStyleBuildTables")).booleanValue()) {
                                int to = Integer.parseInt((String)ST.nextElement());
                            }
                            String Filename = "";
                            while (ST.hasMoreElements()) {
                                Filename = Filename + (String)ST.nextElement();
                                if (!ST.hasMoreElements()) continue;
                                Filename = Filename + " ";
                            }
                            if (!Filename.startsWith(targetChassis) || (cm = new SUnit(m.getProducer(), Filename, m.getWeightclass(), unitid)) == null) continue;
                            Entity cme = cm.getEntity();
                            String chassis = cme.getChassis();
                            if (!cm.isOmni() || !chassis.equals(targetChassis)) continue;
                            String model = cm.getModelName();
                            if (target.equals("<none>") || target.equals("RANDOM")) {
                                if (target.equals("RANDOM") && cm.getModelName().equals(m.getModelName()) || variants.contains(Filename)) continue;
                                variants.add(Filename);
                                String repodMoneyCfg = "RepodCost" + SUnit.getWeightClassDesc(cm.getWeightclass());
                                String repodInfluCfg = "RepodFlu" + SUnit.getWeightClassDesc(cm.getWeightclass());
                                String repodCompCfg = "RepodComp" + SUnit.getWeightClassDesc(cm.getWeightclass());
                                int repodMoneyMod = Integer.parseInt(CampaignMain.cm.getConfig(repodMoneyCfg));
                                int repodFluMod = Integer.parseInt(CampaignMain.cm.getConfig(repodInfluCfg));
                                int repodCompMod = Integer.parseInt(CampaignMain.cm.getConfig(repodCompCfg));
                                if (CampaignMain.cm.getOmniVariantMods().get(model) != null) {
                                    String mods = CampaignMain.cm.getOmniVariantMods().get(model);
                                    StringTokenizer modlist = new StringTokenizer(mods, "$");
                                    repodMoneyMod += Integer.parseInt(modlist.nextToken());
                                    repodCompMod += Integer.parseInt(modlist.nextToken());
                                    repodFluMod += Integer.parseInt(modlist.nextToken());
                                }
                                result = result + model + "#" + repodMoneyMod + "$" + repodCompMod + "$" + repodFluMod + "#";
                                continue;
                            }
                            if (!target.equals(model)) continue;
                            this.createOmni(m, Filename, m.getId(), p, possible, false);
                            return;
                        }
                        MMServ.mmlog.mainLog("File " + prodFile + " has a problem with line:" + l);
                    }
                    dis.close();
                    fis.close();
                }
                catch (FileNotFoundException ex) {
                    MMServ.mmlog.mainLog("File " + prodFile + " was not Found");
                }
                catch (IOException ex) {
                    MMServ.mmlog.mainLog("File " + prodFile + " had an I/O error");
                }
                catch (Exception ex) {
                    MMServ.mmlog.errLog(ex);
                    MMServ.mmlog.mainLog("File " + prodFile + " has a problem");
                }
            }
            if (target.equals("RANDOM")) {
                int size = variants.size();
                if (size <= 0) {
                    CampaignMain.cm.toUser("No random targets available for " + m.getModelName() + ".", Username, true);
                    return;
                }
                if (size == 1) {
                    String Filename = (String)variants.elementAt(0);
                    this.createOmni(m, Filename, m.getId(), p, possible, true);
                    return;
                }
                int number = CampaignMain.cm.getR().nextInt(size);
                String Filename = (String)variants.elementAt(number);
                this.createOmni(m, Filename, m.getId(), p, possible, true);
                return;
            }
            if (this.global) {
                result = result + "#GLOBAL";
            }
            CampaignMain.cm.toUser("RUD|" + unitid + "|" + result, Username, false);
        }
    }

    private void createOmni(SUnit m, String Filename, int unitid, SPlayer p, Vector possible, boolean random) {
        SUnit cm;
        SHouse h = p.getHouseFightingFor();
        String Username = p.getName();
        int influenceCost = 0;
        int moneyCost = 0;
        int compCost = 0;
        int refreshTime = 0;
        int rpCost = Integer.parseInt(CampaignMain.cm.getConfig("GlobalRepodWithRPCost"));
        if (random) {
            rpCost /= 2;
        }
        if ((cm = new SUnit(m.getProducer(), Filename, m.getWeightclass(), unitid)).getModelName().equals("OMG-UR-FD")) {
            CampaignMain.cm.toUser("Invaild repod format try again!", Username, true);
            return;
        }
        if (!this.global) {
            String repodMoneyCfg = "RepodCost" + SUnit.getWeightClassDesc(m.getWeightclass());
            String repodInfluCfg = "RepodFlu" + SUnit.getWeightClassDesc(m.getWeightclass());
            String repodCompCfg = "RepodComp" + SUnit.getWeightClassDesc(m.getWeightclass());
            String repodRefreshCfg = "RepodRefreshTime" + SUnit.getWeightClassDesc(m.getWeightclass());
            int repodMoneyMod = 0;
            int repodCompMod = 0;
            int repodFluMod = 0;
            if (CampaignMain.cm.getOmniVariantMods().get(cm.getModelName()) != null) {
                String mods = CampaignMain.cm.getOmniVariantMods().get(cm.getModelName());
                StringTokenizer modList = new StringTokenizer(mods, "$");
                repodMoneyMod = Integer.parseInt(modList.nextToken());
                repodCompMod = Integer.parseInt(modList.nextToken());
                repodFluMod = Integer.parseInt(modList.nextToken());
            }
            int repodRandomMod = Integer.parseInt(CampaignMain.cm.getConfig("RepodRandomMod"));
            if (Boolean.valueOf(CampaignMain.cm.getConfig("DoesRepodCost")).booleanValue()) {
                moneyCost = Integer.parseInt(CampaignMain.cm.getConfig(repodMoneyCfg)) + repodMoneyMod;
                if (random) {
                    moneyCost = moneyCost * repodRandomMod / 100;
                }
                if (p.getMoney() < moneyCost) {
                    CampaignMain.cm.toUser("You do not have enough money to repod this unit! It will cost " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " to repod this unit", Username, true);
                    return;
                }
                influenceCost = Integer.parseInt(CampaignMain.cm.getConfig(repodInfluCfg)) + repodFluMod;
                if (random) {
                    influenceCost = influenceCost * repodRandomMod / 100;
                }
                if (p.getInfluence() < influenceCost) {
                    CampaignMain.cm.toUser("You do not have enough influence to repod this unit! It will cost " + CampaignMain.cm.moneyOrFluMessage(false, false, influenceCost) + " to repod this unit!", Username, true);
                    return;
                }
                if (Boolean.valueOf(CampaignMain.cm.getConfig("RepodUsesComp")).booleanValue()) {
                    compCost = Integer.parseInt(CampaignMain.cm.getConfig(repodCompCfg)) + repodCompMod;
                    if (random) {
                        compCost = compCost * repodRandomMod / 100;
                    }
                    if (h.getPP(m.getWeightclass(), m.getType()) < compCost) {
                        CampaignMain.cm.toUser("Your faction doesn't have enough components to repod this unit. You need " + compCost + " components to repod.", Username, true);
                        return;
                    }
                }
                if (Boolean.valueOf(CampaignMain.cm.getConfig("RepodUsesFactory")).booleanValue()) {
                    SUnitFactory working = (SUnitFactory)possible.elementAt(0);
                    refreshTime = Integer.parseInt(CampaignMain.cm.getConfig(repodRefreshCfg));
                    if (random) {
                        refreshTime = refreshTime * repodRandomMod / 100;
                    }
                    working.addRefresh(refreshTime);
                }
                h.addPP(m.getWeightclass(), m.getType(), -compCost);
                p.setMoney(p.getMoney() - moneyCost);
                p.setInfluence(p.getInfluence() - influenceCost);
            }
        } else {
            if (p.getReward() < rpCost) {
                CampaignMain.cm.toUser("You do not have enough reward points to repod this unit!", Username, true);
                return;
            }
            p.addReward(-rpCost);
        }
        cm.setPilot((SPilot)m.getPilot(), false);
        cm.setExperience(m.getExperience());
        if (cm.getType() == 0) {
            Entity entity = p.getUnit(unitid).getEntity();
            ((Mech)cm.getEntity()).setAutoEject(((Mech)entity).isAutoEject());
        }
        p.removeUnit(unitid, false);
        p.addUnit(cm, true);
        CampaignMain.cm.toUser("The " + m.getVerboseModelName() + " has been repodded to " + AorAn.check(m.getModelName(), true) + " " + cm.getVerboseModelName() + ".", Username, true);
        if (!this.global) {
            if (new Boolean(CampaignMain.cm.getConfig("RepodUsesComp")).booleanValue()) {
                CampaignMain.cm.toUser("Repod cost was " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, influenceCost) + " " + compCost + " Components", Username, true);
            } else {
                CampaignMain.cm.toUser("Repod cost was " + CampaignMain.cm.moneyOrFluMessage(true, false, moneyCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, influenceCost), Username, true);
            }
        } else {
            CampaignMain.cm.toUser("Repod cost was " + rpCost + " reward points", Username, true);
        }
    }
}

