/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.NewbiePlanet;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.util.UnitHistoryKeeper;

public class RequestCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        NewbieHouse nh;
        int weightclass;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SPlanet planet = null;
        boolean planetIsOk = false;
        String result = "";
        String factoryName = "";
        boolean needsMoreTechs = false;
        boolean hasMezzoIncrease = false;
        SUnitFactory UnitFactory2 = null;
        String weightstring = command.nextToken();
        if (p.getMyHouse().isNewbieHouse()) {
            if (weightstring.equals("resetunits")) {
                NewbieHouse nh2 = (NewbieHouse)p.getMyHouse();
                CampaignMain.cm.toUser(nh2.requestNewMech(p), Username, true);
                if (Username.startsWith("[Coach]")) {
                    for (int type = 0; type < 2; ++type) {
                        for (int weight = 0; weight < 4; ++weight) {
                            p.getPlayerPersonalPilotQueue().getPilotQueue(type, weight).clear();
                        }
                    }
                }
                return;
            }
            result = CampaignMain.cm.getConfig("NewbieHouseName") + " players may not purchase new units; however, they may reset their units.";
            result = result + "<br><a href=\"MEKWARS/c request#resetunits\">Click here to request a reset of your units.</a>";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            SHouse house = p.getHouseFightingFor();
            SUnit unit = CampaignMain.cm.buildWelfareMek(house.getName());
            SPilot pilot = house.getNewPilot(unit.getType());
            unit.setPilot(pilot);
            p.addUnit(unit, true);
            CampaignMain.cm.toUser("High Command has given you a Mek from its welfare rolls to help you get back on your feet!", Username, true);
            return;
        }
        try {
            weightclass = Integer.parseInt(weightstring);
        }
        catch (Exception ex) {
            weightclass = Unit.getWeightIDForName(weightstring.toUpperCase());
        }
        int type_id = 0;
        String typestring = command.nextToken();
        try {
            type_id = Integer.parseInt(typestring);
        }
        catch (Exception ex) {
            type_id = Unit.getTypeIDForName(typestring);
        }
        if (!p.mayUse(weightclass)) {
            result = "You are not experienced enough to use " + Unit.getWeightClassDesc(weightclass) + " units.";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            String planetname = command.nextToken();
            planet = (SPlanet)CampaignMain.cm.getData().getPlanetByName(planetname);
            if (planet == null && !planetname.equals(" ")) {
                CampaignMain.cm.toUser("This planet does not exist!", Username, true);
                return;
            }
        } else {
            SUnitFactory MF = p.getMyHouse().getUnitFactoryForProduction(type_id, weightclass);
            if (MF != null) {
                planet = MF.getPlanet();
            }
        }
        if (command.hasMoreElements()) {
            factoryName = command.nextToken();
        }
        if (planet == null) {
            if (p.getMyHouse().isNewbieHouse()) {
                nh = (NewbieHouse)p.getMyHouse();
                CampaignMain.cm.toUser(nh.requestNewMech(p), Username, true);
                return;
            }
            CampaignMain.cm.toUser("Your faction has no factories capable of fulfilling your order at this time.", Username, true);
            return;
        }
        if (planet instanceof NewbiePlanet) {
            if (p.getMyHouse().isNewbieHouse()) {
                nh = (NewbieHouse)p.getMyHouse();
                CampaignMain.cm.toUser(nh.requestNewMech(p), Username, true);
                return;
            }
            CampaignMain.cm.toUser("Newbie planets are not valid production targets.", Username, true);
            return;
        }
        Vector potentialFactories = planet.getFactoriesOfWeighclass(weightclass);
        if (potentialFactories.size() > 0 && planet.getOwner().equals(p.getMyHouse())) {
            Enumeration e = potentialFactories.elements();
            while (e.hasMoreElements()) {
                SUnitFactory mf = (SUnitFactory)e.nextElement();
                if (factoryName.length() > 0 && mf.getName().equalsIgnoreCase(factoryName)) {
                    planetIsOk = mf.getTicksUntilRefresh() <= 0 && mf.canProduce(type_id);
                    UnitFactory2 = mf;
                    break;
                }
                if (mf.getTicksUntilRefresh() > 0 || !mf.canProduce(type_id)) continue;
                planetIsOk = true;
            }
        } else {
            result = planet.getFactoriesOfWeighclass(weightclass).size() == 0 ? "This world does not produce units of the weight class specified." : (planet.getOwner().equals(p.getMyHouse()) ? "Your faction does not control the factories on this world." : "For some reason, this planet can not produce what you're looking for right now.");
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (!planetIsOk) {
            result = "The Factory on this planet is refreshing right now. Check back later!";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (planetIsOk) {
            SHouse playerHouse = p.getMyHouse();
            if (p.hasUnmaintainedUnit()) {
                result = "Your faction refuses to assign new units to you force while existing resources are not being properly maintained!";
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            int mechCbills = playerHouse.getPriceForUnit(weightclass, type_id, p);
            int mechPP = playerHouse.getPPCost(weightclass, type_id);
            int mechInfluence = playerHouse.getInfluenceForUnit(weightclass, type_id, p);
            boolean hasEnoughMoney = false;
            boolean hasEnoughInfluence = false;
            boolean factionHasEnoughPP = false;
            if (p.getMoney() >= mechCbills) {
                hasEnoughMoney = true;
            }
            if (p.getInfluence() >= mechInfluence) {
                hasEnoughInfluence = true;
            }
            if (playerHouse.getPP(weightclass, type_id) >= mechPP) {
                factionHasEnoughPP = true;
            }
            if (hasEnoughMoney && hasEnoughInfluence && factionHasEnoughPP) {
                int spaceTaken = CampaignMain.cm.getHangarSpaceRequired(type_id, weightclass, 0, "null");
                if (spaceTaken > p.getFreeBays()) {
                    needsMoreTechs = true;
                }
                if (hasMezzoIncrease && needsMoreTechs) {
                    int techCost = p.getTechHiringFee();
                    int numTechs = spaceTaken - p.getFreeBays();
                    int totalCost = (techCost *= numTechs) + mechCbills;
                    if (totalCost > p.getMoney()) {
                        result = "You cannot afford to bribe the Quartermaster and hire the additional technicians that would be needed to maintain the requested unit. (Unit cost after pricemodifier increase and tech hiring would be " + CampaignMain.cm.moneyOrFluMessage(true, false, totalCost) + " and you only have " + p.getMoney() + ".)";
                        CampaignMain.cm.toUser(result, Username, true);
                        return;
                    }
                    result = "This one is going to cost you. Command won't release a new unit to your force until you hire more technicians <b>and</b> the Quartermaster is demanding a bribe!";
                    result = result + "Total cost, for techs and the unit itself, will be " + CampaignMain.cm.moneyOrFluMessage(true, true, totalCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, mechInfluence) + ".";
                    result = result + "<br><a href=\"MEKWARS/c hireandrequestnew#" + numTechs + "#" + Unit.getWeightClassDesc(weightclass) + "#" + type_id + "#";
                    result = planet == null ? result + " " : result + planet.getName();
                    result = result + "#" + mechCbills + "\">Click here to hire the technicians and buy the unit at the increased price</a>.";
                    CampaignMain.cm.toUser(result, Username, true);
                    return;
                }
                if (hasMezzoIncrease) {
                    result = "You're going to have to bribe the quartermaster to get that unit! (Total Price: " + mechCbills + " " + CampaignMain.cm.moneyOrFluMessage(true, true, mechCbills) + " / " + mechInfluence + " " + CampaignMain.cm.moneyOrFluMessage(false, true, mechInfluence) + ")";
                    result = result + "<br><a href=\"MEKWARS/c request#" + Unit.getWeightClassDesc(weightclass) + "#" + type_id + "#";
                    result = planet == null ? result + " " : result + planet.getName();
                    result = result + "#" + mechCbills + "\">Click here to buy at the increased price</a>.";
                    CampaignMain.cm.toUser(result, Username, true);
                    return;
                }
                if (needsMoreTechs) {
                    int techCost = p.getTechHiringFee();
                    int numTechs = spaceTaken - p.getFreeBays();
                    int totalCost = (techCost *= numTechs) + mechCbills;
                    if (totalCost > p.getMoney()) {
                        result = "Command will not release a new unit to you unless support is in place; however, you cannot afford to buy the unit *and* hire technicians. Total cost would be " + CampaignMain.cm.moneyOrFluMessage(true, true, totalCost) + " and you only have " + CampaignMain.cm.moneyOrFluMessage(true, true, p.getMoney()) + ".";
                        CampaignMain.cm.toUser(result, Username, true);
                        return;
                    }
                    result = "Quartermaster command will not send a new unit to your force until support resources are in place. You will need to hire " + numTechs + " more technicians (total tech cost: " + CampaignMain.cm.moneyOrFluMessage(true, true, techCost) + "). Combined cost of the new unit and necessary " + "technicians is " + CampaignMain.cm.moneyOrFluMessage(true, true, mechCbills + techCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, mechInfluence) + ".";
                    result = result + "<br><a href=\"MEKWARS/c hireandrequestnew#" + numTechs + "#" + Unit.getWeightClassDesc(weightclass) + "#" + type_id + "#";
                    result = planet == null ? result + " " : result + planet.getName();
                    result = result + "#" + mechCbills + "\">Click here to hire the technicians and purchase the unit.</a>";
                    CampaignMain.cm.toUser(result, Username, true);
                    return;
                }
                if (UnitFactory2 == null) {
                    UnitFactory2 = planet.getRandomFactoryOfSize(weightclass, type_id);
                }
                SPilot pilot = playerHouse.getNewPilot(type_id);
                SUnit mech = UnitFactory2.getMechProduced(type_id, pilot);
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCalculatedCosts")).booleanValue()) {
                    for (int i = 0; i < 10; ++i) {
                        mech = UnitFactory2.getMechProduced(type_id, pilot);
                        mechCbills = (int)(mech.getEntity().getCost() * Double.valueOf(CampaignMain.cm.getConfig("CostModifier")));
                        if (mech.getModelName().equals("OMG-UR-FD") || mechCbills <= p.getMoney()) break;
                    }
                    if (mechCbills > p.getMoney()) {
                        CampaignMain.cm.toUser("The quartermaster regrets to inform you that the factories cannot create any units within your current buget. Please try again later", Username, true);
                        return;
                    }
                    if (UnitFactory2.getWeightclass() == 0) {
                        UnitFactory2.setTicksUntilRefresh(Integer.parseInt(CampaignMain.cm.getConfig("LightRefresh")) * 100 / UnitFactory2.getRefreshSpeed());
                    } else if (UnitFactory2.getWeightclass() == 1) {
                        UnitFactory2.setTicksUntilRefresh(Integer.parseInt(CampaignMain.cm.getConfig("MediumRefresh")) * 100 / UnitFactory2.getRefreshSpeed());
                    } else if (UnitFactory2.getWeightclass() == 2) {
                        UnitFactory2.setTicksUntilRefresh(Integer.parseInt(CampaignMain.cm.getConfig("HeavyRefresh")) * 100 / UnitFactory2.getRefreshSpeed());
                    } else if (UnitFactory2.getWeightclass() == 3) {
                        UnitFactory2.setTicksUntilRefresh(Integer.parseInt(CampaignMain.cm.getConfig("AssaultRefresh")) * 100 / UnitFactory2.getRefreshSpeed());
                    }
                }
                if (new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue() && (mech.getType() == 0 || mech.getType() == 3)) {
                    SPilot pilot1 = (SPilot)mech.getPilot();
                    SPilot pilot2 = new SPilot("Vacant", 99, 99);
                    mech.setPilot(pilot2, true);
                    if (!pilot1.getName().equalsIgnoreCase("Vacant")) {
                        playerHouse.getPilotQueues().addPilot(mech.getType(), pilot1);
                    }
                }
                UnitHistoryKeeper.addBoughtFromFactoryEntry(mech.getId(), p.getName(), playerHouse.getName());
                p.addUnit(mech, true);
                p.addMoney(-mechCbills);
                p.addInfluence(-mechInfluence);
                if (type_id == 0) {
                    if (weightclass == 0) {
                        p.addPricePenalty(Integer.parseInt(CampaignMain.cm.getConfig("LightMezzoModifier")));
                    }
                    if (weightclass == 1) {
                        p.addPricePenalty(Integer.parseInt(CampaignMain.cm.getConfig("MediumMezzoModifier")));
                    } else if (weightclass == 2) {
                        p.addPricePenalty(Integer.parseInt(CampaignMain.cm.getConfig("HeavyMezzoModifier")));
                    } else if (weightclass == 3) {
                        p.addPricePenalty(Integer.parseInt(CampaignMain.cm.getConfig("AssaultMezzoModifier")));
                    }
                }
                playerHouse.addPP(weightclass, type_id, -mechPP);
                result = "You've been granted a " + mech.getModelName() + ". (-";
                result = result + CampaignMain.cm.moneyOrFluMessage(true, false, mechCbills) + " / -" + CampaignMain.cm.moneyOrFluMessage(false, true, mechInfluence) + ")";
                MMServ.mmlog.bmLog(p.getName() + " has bought a " + mech.getVerboseModelName() + " from " + UnitFactory2.getName() + " on " + planet.getName());
                CampaignMain.cm.toUser(result, Username, true);
                CampaignMain.cm.toUser(playerHouse.getAutoStatus(), p.getName(), false);
                CampaignMain.cm.doSendHouseMail(playerHouse, "NOTE", p.getName() + " has bought a " + mech.getVerboseModelName() + " from " + UnitFactory2.getName() + " on " + planet.getName() + "!");
                return;
            }
            if (!hasEnoughMoney || !hasEnoughInfluence) {
                result = "You need at least " + CampaignMain.cm.moneyOrFluMessage(true, false, mechCbills) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, mechInfluence) + " to request a " + SUnit.getDescriptionForID(type_id) + " of this weight class from a factory.";
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            if (!factionHasEnoughPP) {
                result = "Your faction does not have the components needed to produce such a unit at this time. Wait for your faction to gather more resources.";
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
        }
    }
}

