/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.util.MMNetPasswd;
import server.util.MMNetPasswdRecord;

public class SetMyLogoCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String newLogo = command.nextToken();
        MMNetPasswdRecord p = MMNetPasswd.getRecord(Username);
        if (p == null) {
            CampaignMain.cm.toUser("You cannot set a logo until you registered your Name. Please use the File Menu -> Register Nickname to do so!", Username, true);
            return;
        }
        p.setPlayerLogo(newLogo);
        try {
            MMNetPasswd.writeRecord(p);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        CampaignMain.cm.toUser("You've set your Logo to " + p.getPlayerLogo(), Username, true);
        CampaignMain.cm.toUser("It'll look like this: <img height=\"150\" width=\"150\" src =\"" + p.getPlayerLogo() + "\">", Username, true);
    }
}

