/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.util.TimeZoneData;
import server.campaign.util.UnitHistoryKeeper;

public class UseRewardPointsCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int rewardSelection = Integer.parseInt(command.nextToken());
        int rewardPoints = 0;
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        if (rewardSelection < 0 || rewardSelection > 2) {
            CampaignMain.cm.toUser("Invalid reward selection. 0 for techs, 1 for influence, 2 for units.", Username, true);
            return;
        }
        switch (rewardSelection) {
            case 0: {
                rewardPoints = Integer.parseInt(command.nextToken());
                if (rewardPoints < 0) {
                    CampaignMain.cm.toUser("Invalid input - negative reward points.", Username, true);
                    return;
                }
                if (!new Boolean(CampaignMain.cm.getConfig("AllowTechsForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("Sorry but you are not allowed to buy techs with reward points.", Username, true);
                    return;
                }
                if (rewardPoints > player.getReward()) {
                    if (player.getReward() == 1) {
                        CampaignMain.cm.toUser("You only have 1 reward point. Try again later.", Username, true);
                    } else {
                        CampaignMain.cm.toUser("You only have " + player.getReward() + " reward points. Try again later.", Username, true);
                    }
                    return;
                }
                int numOfTechBought = Integer.parseInt(CampaignMain.cm.getConfig("TechsForARewardPoint"));
                String techs = "";
                String rewards = "";
                if ((numOfTechBought *= rewardPoints) > 1) {
                    techs = "s";
                }
                if (rewardPoints > 1) {
                    rewards = "s";
                }
                CampaignMain.cm.toUser("You've bought " + numOfTechBought + " tech" + techs + " for " + rewardPoints + " reward point" + rewards + ".", Username, true);
                player.addReward(-rewardPoints);
                player.addTechnicians(numOfTechBought);
                break;
            }
            case 1: {
                rewardPoints = Integer.parseInt(command.nextToken());
                if (rewardPoints < 0) {
                    CampaignMain.cm.toUser("Invalid input - negative reward points.", Username, true);
                    return;
                }
                if (!new Boolean(CampaignMain.cm.getConfig("AllowInfluenceForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("Sorry but you are not allowed to buy influence with reward points.", Username, true);
                    return;
                }
                if (rewardPoints > player.getReward()) {
                    if (player.getReward() == 1) {
                        CampaignMain.cm.toUser("You only have 1 reward point try again.", Username, true);
                    } else {
                        CampaignMain.cm.toUser("You only have " + player.getReward() + " reward points try again.", Username, true);
                    }
                    return;
                }
                int amountOfInfluenceBought = Integer.parseInt(CampaignMain.cm.getConfig("InfluenceForARewardPoint"));
                String rewards = rewardPoints > 1 ? "s" : "";
                CampaignMain.cm.toUser("You've bought " + CampaignMain.cm.moneyOrFluMessage(false, true, amountOfInfluenceBought *= rewardPoints) + " for " + rewardPoints + " reward point" + rewards + ".", Username, true);
                player.addReward(-rewardPoints);
                player.addInfluence(amountOfInfluenceBought);
                break;
            }
            case 2: {
                double nonHouseUnitMod;
                if (!new Boolean(CampaignMain.cm.getConfig("AllowUnitsForRewards")).booleanValue()) {
                    CampaignMain.cm.toUser("Sorry but you are not allowed to buy units with reward points.", Username, true);
                    return;
                }
                int rewardPointsAvailable = player.getReward();
                int unitTotalRewardPointCost = 0;
                String typestring = command.nextToken();
                String weightstring = command.nextToken();
                int unitType = 0;
                int unitWeight = 0;
                int typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAMek"));
                int weightCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForALight"));
                SHouse faction = player.getHouseFightingFor();
                double rareCost = 1.0;
                boolean buyRareUnit = false;
                SUnit newUnit = null;
                SPilot newPilot = null;
                String factionstring = "common";
                if (new Boolean(CampaignMain.cm.getConfig("AllowRareUnitsForRewards")).booleanValue()) {
                    rareCost = Double.parseDouble(CampaignMain.cm.getConfig("RewardPointMultiplierForRare"));
                }
                try {
                    unitType = Integer.parseInt(typestring);
                }
                catch (Exception ex) {
                    unitType = SUnit.getTypeIDForName(typestring);
                }
                try {
                    unitWeight = Integer.parseInt(weightstring);
                }
                catch (Exception ex) {
                    unitWeight = SUnit.getWeightIDForName(weightstring.toUpperCase());
                }
                if (command.hasMoreElements()) {
                    factionstring = command.nextToken();
                    if (factionstring.equalsIgnoreCase("rare")) {
                        if (!new Boolean(CampaignMain.cm.getConfig("AllowRareUnitsForRewards")).booleanValue()) {
                            CampaignMain.cm.toUser("Sorry but you are not allowed to buy rare units with your reward points.", Username, true);
                            return;
                        }
                        buyRareUnit = true;
                        factionstring = "Rare";
                    } else if (!factionstring.equalsIgnoreCase("common")) {
                        faction = CampaignMain.cm.getHouseFromPartialString(factionstring, Username);
                    }
                    if (faction == null && (faction = player.getHouseFightingFor()) == null) {
                        factionstring = "Common";
                    }
                }
                switch (unitType) {
                    case 0: {
                        typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAMek"));
                        break;
                    }
                    case 1: {
                        typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAVeh"));
                        if (!new Boolean(CampaignMain.cm.getConfig("UseOnlyOneVehicleSize")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 2: {
                        typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForInf"));
                        if (!new Boolean(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 3: {
                        typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForInf"));
                        if (!new Boolean(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                        break;
                    }
                    case 4: {
                        typeCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForInf"));
                        if (!new Boolean(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue()) break;
                        unitWeight = 0;
                    }
                }
                switch (unitWeight) {
                    case 0: {
                        weightCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForALight"));
                        break;
                    }
                    case 1: {
                        weightCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAMed"));
                        break;
                    }
                    case 2: {
                        weightCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAHeavy"));
                        break;
                    }
                    case 3: {
                        weightCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointsForAnAssault"));
                    }
                }
                unitTotalRewardPointCost = weightCost + typeCost;
                if (!player.getHouseFightingFor().equals(faction) && (nonHouseUnitMod = Double.parseDouble(CampaignMain.cm.getConfig("RewardPointNonHouseMultiplier"))) > 0.0) {
                    unitTotalRewardPointCost = (int)((double)unitTotalRewardPointCost * nonHouseUnitMod);
                }
                if (buyRareUnit) {
                    unitTotalRewardPointCost = (int)((double)unitTotalRewardPointCost * rareCost);
                }
                if (unitTotalRewardPointCost > rewardPointsAvailable) {
                    CampaignMain.cm.toUser("Sorry but you do not have enough reward points to buy that unit.", Username, true);
                    return;
                }
                String era = "rewards";
                try {
                    newPilot = new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")) != false && (unitType == 0 || unitType == 3) ? new SPilot("Vacant", 99, 99) : player.getHouseFightingFor().getNewPilot(unitType);
                    newUnit = this.getUnitProduced(unitType, unitWeight, newPilot, factionstring, era);
                    player.addUnit(newUnit, true);
                    CampaignMain.cm.toUser("You've bought a " + newUnit.getModelName() + " for " + unitTotalRewardPointCost + " reward points.", Username, true);
                    player.addReward(-unitTotalRewardPointCost);
                    break;
                }
                catch (Exception ex) {
                    CampaignMain.cm.toUser("An error has occured while trying to create your requested unit please contact an admin. Era: " + era + " House: " + factionstring + " Type: " + unitType + " Class: " + unitWeight, Username, true);
                    MMServ.mmlog.errLog(ex);
                    MMServ.mmlog.errLog("Error creating unit in " + this.getClass().getName());
                }
            }
        }
    }

    private SUnit getUnitProduced(int type_id, int weightClass, SPilot pilot, String faction, String era) {
        SUnitFactory factory = new SUnitFactory();
        String unitSize = SUnit.getWeightClassDesc(weightClass);
        factory.setFounder(faction);
        factory.setProductionTable(faction);
        String MechConstructor = faction;
        String Filename = "";
        String timezone = era;
        TimeZoneData TZUsed = new TimeZoneData();
        TZUsed.setName(timezone);
        TZUsed.setPropability(100);
        String producer = "Built by reward points interstellar from spare parts stockpiles";
        if (new Boolean(CampaignMain.cm.getConfig("UseOnlyOneVehicleSize")).booleanValue() && type_id == 1) {
            unitSize = SUnit.getWeightClassDesc(CampaignMain.cm.getR().nextInt(4));
        }
        Filename = BuildTable.getUnitFilename(MechConstructor, unitSize, type_id, TZUsed);
        SUnit cm = new SUnit(producer, Filename, weightClass);
        producer = factory.getFounder();
        UnitHistoryKeeper.addProductionEntry(cm.getId(), "Reward Points Factory", "ComStar", producer, cm.getUnitFilename());
        cm.setPilot(pilot, true);
        return cm;
    }
}

