/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.Iterator;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;

public class AdminDestroyFactoryCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            String factoryname = command.nextToken();
            if (p == null) {
                CampaignMain.cm.toUser("Planet not found:", Username, true);
                return;
            }
            SUnitFactory UF = null;
            Iterator it = p.getUnitFactories().iterator();
            if (!it.hasNext()) {
                CampaignMain.cm.toUser("This planet does not have any factories!", Username, true);
                return;
            }
            int count = 0;
            while (it.hasNext()) {
                UF = (SUnitFactory)it.next();
                if (UF.getName().equalsIgnoreCase(factoryname)) {
                    p.getUnitFactories().removeElementAt(count);
                    p.getUnitFactories().trimToSize();
                    break;
                }
                ++count;
            }
            if (UF == null) {
                CampaignMain.cm.toUser("Factory " + factoryname + " not found", Username, true);
                return;
            }
            MMServ.mmlog.modLog("Factory " + factoryname + " has been removed.");
            CampaignMain.cm.toUser("Factory " + factoryname + " has been removed.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + "has removed factory " + factoryname + " has been removed.");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }
}

