/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.Iterator;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminDestroyTerrainCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            int placeToDelete = Integer.parseInt(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Planet not found:", Username, true);
                return;
            }
            Iterator pe = p.getEnvironments().iterator();
            int count = 0;
            while (pe.hasNext()) {
                pe.next();
                if (count == placeToDelete) {
                    pe.remove();
                    break;
                }
                ++count;
            }
            p.updated();
            MMServ.mmlog.modLog("Terrain has been removed.");
            CampaignMain.cm.toUser("Terrain has been removed.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " has removed terrain on planet" + p.getName());
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }
}

