/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminExchangePlanetOwnershipCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = null;
        SHouse winningHouse = null;
        SHouse losingHouse = null;
        int amount = 0;
        try {
            planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            winningHouse = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            losingHouse = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
            amount = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminexchangeplanetownership#planet#winner#loser#amount", Username, true);
            return;
        }
        if (planet == null) {
            CampaignMain.cm.toUser("Could not find a matching planet.", Username, true);
            return;
        }
        if (winningHouse == null) {
            CampaignMain.cm.toUser("Could not find a matching faction for the winner.", Username, true);
            return;
        }
        if (losingHouse == null) {
            CampaignMain.cm.toUser("Could not find a matching faction for the loser.", Username, true);
            return;
        }
        if (amount <= 0) {
            CampaignMain.cm.toUser("Get real try a number above 0!", Username, true);
            return;
        }
        int newAmount = planet.doGainInfluence(winningHouse, losingHouse, amount);
        MMServ.mmlog.modLog(Username + " has exchanged " + newAmount + "% of " + planet.getName() + " between " + winningHouse.getName() + " and " + losingHouse.getName() + ".");
        CampaignMain.cm.toUser("You have exchanged " + newAmount + "% of " + planet.getName() + " between " + winningHouse.getName() + " and " + losingHouse.getName() + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has exchanged " + newAmount + "% of " + planet.getName() + " between " + winningHouse.getName() + " and " + losingHouse.getName() + ".");
    }
}

